package com.mastercard.merchant.checkout;

import com.mastercard.merchant.checkout.model.PreCheckoutData;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.merchant.checkout.impl.APITrackerImpl;

public class PreCheckoutDataApi {

 /**
   * PreCheckout Data Service
   * <p>Use the consumer’s pairingID to retrieve their shipping and payment information prior to complete an Express Checkout.  You can use the data returned from this service to confirm the user’s payment selections before completing the checkout. API URL: /masterpass/precheckoutdata/{pairingId}</p>
   * @param pairingId	the The unique pairing token identifier used to fetch pre-checkout data for a wallet that is paired with a merchant.
   * @return 	the PreCheckoutData.
   */
     public static PreCheckoutData show(String pairingId){
			return show( pairingId, MasterCardApiConfig.config());
            
	}
 
 
 /**
   * PreCheckout Data Service
   * <p>Use the consumer’s pairingID to retrieve their shipping and payment information prior to complete an Express Checkout.  You can use the data returned from this service to confirm the user’s payment selections before completing the checkout. API URL: /masterpass/precheckoutdata/{pairingId}</p>
   * @param pairingId	the The unique pairing token identifier used to fetch pre-checkout data for a wallet that is paired with a merchant.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the PreCheckoutData.
   */
     public static PreCheckoutData show(String pairingId, ApiConfig apiConfig){
   
	 String path = "/masterpass/precheckoutdata/{pairingId}";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 serviceRequest.pathParam("pairingId",pairingId);
	 
	 
	 
	 
	 serviceRequest.contentType("application/json");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"GET",PreCheckoutData.class);
     
	}
 
}
