package com.mastercard.merchant.checkout.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains recipient information.
 **/
@Root(name = "RecipientInfo")
@XmlRootElement (name = "RecipientInfo")
public class RecipientInfo   {
  
  @SerializedName("recipientName")
  @Element(name = "recipientName", required = false)
  private String recipientName = null;
  
  @SerializedName("recipientPhone")
  @Element(name = "recipientPhone", required = false)
  private String recipientPhone = null;
  
  
  /**
   * Gets the recipient name.
   * 
   * @return	the recipient name.
   **/
  @XmlElement(name = "recipientName")
  public String getRecipientName() {
    return recipientName;
  }
  
  /**
  * Sets the recipient name.
  *
  * @param recipientName the recipient name.
  */
    public RecipientInfo recipientName(String recipientName) {
    this.recipientName = recipientName;
    return this;
  }
  
  
    

  
  /**
   * Gets the recipient phone.
   * 
   * @return	the recipient phone.
   **/
  @XmlElement(name = "recipientPhone")
  public String getRecipientPhone() {
    return recipientPhone;
  }
  
  /**
  * Sets the recipient phone.
  *
  * @param recipientPhone the recipient phone.
  */
    public RecipientInfo recipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RecipientInfo recipientInfo = (RecipientInfo) o;
    return Objects.equals(recipientName, recipientInfo.recipientName) &&
        Objects.equals(recipientPhone, recipientInfo.recipientPhone);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(recipientName, recipientPhone);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RecipientInfo {\n");
    
    sb.append("    recipientName: ").append(toIndentedString(recipientName)).append("\n");
    sb.append("    recipientPhone: ").append(toIndentedString(recipientPhone)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


