package com.mastercard.merchant.checkout;

import com.mastercard.merchant.checkout.model.ExpressCheckoutRequest;
import com.mastercard.merchant.checkout.model.PaymentData;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.merchant.checkout.impl.APITrackerImpl;

public class ExpressCheckoutApi {

 /**
   * ExpressCheckout Service
   * <p>Use this service to retrieve the consumer&#39;s full payment card, shipping address, and recipient personal information from Masterpass when performing an Express Checkout. If the merchant is PCI-compliant, then this API will return the complete payload. If the merchant is not PCI-compliant, then this API will only return non-PCI data. In both cases, a new pairingId will be returned to the merchant. API URL: /masterpass/expresscheckout</p>
   * @param expressCheckoutRequest	the Express Checkout Request.
   * @return 	the PaymentData.
   */
     public static PaymentData create(ExpressCheckoutRequest expressCheckoutRequest){
			return create( expressCheckoutRequest, MasterCardApiConfig.config());
            
	}
 
 
 /**
   * ExpressCheckout Service
   * <p>Use this service to retrieve the consumer&#39;s full payment card, shipping address, and recipient personal information from Masterpass when performing an Express Checkout. If the merchant is PCI-compliant, then this API will return the complete payload. If the merchant is not PCI-compliant, then this API will only return non-PCI data. In both cases, a new pairingId will be returned to the merchant. API URL: /masterpass/expresscheckout</p>
   * @param expressCheckoutRequest	the Express Checkout Request.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the PaymentData.
   */
     public static PaymentData create(ExpressCheckoutRequest expressCheckoutRequest, ApiConfig apiConfig){
   
	 String path = "/masterpass/expresscheckout";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 
	 serviceRequest.requestBody(expressCheckoutRequest);
	 
	 serviceRequest.contentType("application/json");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"POST",PaymentData.class);
     
	}
 
}
