package com.mastercard.merchant.checkout.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.merchant.checkout.model.Cryptogram;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * The tokenized card information.
 **/
@Root(name = "Tokenization")
@XmlRootElement (name = "Tokenization")
public class Tokenization   {
  
  @SerializedName("fPanSuffix")
  @Element(name = "fPanSuffix", required = false)
  @JsonProperty(value = "fPanSuffix", required = false)
  private String fPanSuffix = null;
  
  @SerializedName("tokenRequestorId")
  @Element(name = "tokenRequestorId", required = false)
  @JsonProperty(value = "tokenRequestorId", required = false)
  private String tokenRequestorId = null;
  
  @SerializedName("paymentAccountReference")
  @Element(name = "paymentAccountReference", required = false)
  @JsonProperty(value = "paymentAccountReference", required = false)
  private String paymentAccountReference = null;
  
  @SerializedName("cryptogram")
  @Element(name = "cryptogram", required = false)
  @JsonProperty(value = "cryptogram", required = false)
  private Cryptogram cryptogram = null;
  
  
  /**
   * Gets the last digits of the card number. (FPAN) Normally the suffix is the last four digits.
   * 
   * @return	the last digits of the card number. (FPAN) Normally the suffix is the last four digits.
   **/
  @XmlElement(name = "fPanSuffix")
  public String getFPanSuffix() {
    return fPanSuffix;
  }
  
  /**
  * Sets the last digits of the card number. (FPAN) Normally the suffix is the last four digits.
  *
  * @param fPanSuffix the last digits of the card number. (FPAN) Normally the suffix is the last four digits.
  */
    public Tokenization fPanSuffix(String fPanSuffix) {
    this.fPanSuffix = fPanSuffix;
    return this;
  }
  
  
    

  
  /**
   * Gets the token requestor id.
   * 
   * @return	the token requestor id.
   **/
  @XmlElement(name = "tokenRequestorId")
  public String getTokenRequestorId() {
    return tokenRequestorId;
  }
  
  /**
  * Sets the token requestor id.
  *
  * @param tokenRequestorId the token requestor id.
  */
    public Tokenization tokenRequestorId(String tokenRequestorId) {
    this.tokenRequestorId = tokenRequestorId;
    return this;
  }
  
  
    

  
  /**
   * Gets the payment account reference.
   * 
   * @return	the payment account reference.
   **/
  @XmlElement(name = "paymentAccountReference")
  public String getPaymentAccountReference() {
    return paymentAccountReference;
  }
  
  /**
  * Sets the payment account reference.
  *
  * @param paymentAccountReference the payment account reference.
  */
    public Tokenization paymentAccountReference(String paymentAccountReference) {
    this.paymentAccountReference = paymentAccountReference;
    return this;
  }
  
  
    

  
  /**
   * Gets the cryptogram generated by the consumer's Masterpass wallet.
   * 
   * @return	the cryptogram generated by the consumer's Masterpass wallet.
   **/
  @XmlElement(name = "cryptogram")
  public Cryptogram getCryptogram() {
    return cryptogram;
  }
  
  /**
  * Sets the cryptogram generated by the consumer's Masterpass wallet.
  *
  * @param cryptogram the cryptogram generated by the consumer's Masterpass wallet.
  */
    public Tokenization cryptogram(Cryptogram cryptogram) {
    this.cryptogram = cryptogram;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Tokenization tokenization = (Tokenization) o;
    return Objects.equals(fPanSuffix, tokenization.fPanSuffix) &&
        Objects.equals(tokenRequestorId, tokenization.tokenRequestorId) &&
        Objects.equals(paymentAccountReference, tokenization.paymentAccountReference) &&
        Objects.equals(cryptogram, tokenization.cryptogram);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(fPanSuffix, tokenRequestorId, paymentAccountReference, cryptogram);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Tokenization {\n");
    
    sb.append("    fPanSuffix: ").append(toIndentedString(fPanSuffix)).append("\n");
    sb.append("    tokenRequestorId: ").append(toIndentedString(tokenRequestorId)).append("\n");
    sb.append("    paymentAccountReference: ").append(toIndentedString(paymentAccountReference)).append("\n");
    sb.append("    cryptogram: ").append(toIndentedString(cryptogram)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


