package com.mastercard.merchant.checkout;

import com.mastercard.merchant.checkout.model.EncryptedPaymentDataResponse;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.merchant.checkout.impl.APITrackerImpl;

public class EncryptedPaymentDataApi {

 /**
   * EncryptedPaymentData Service
   * <p>Use this service to retrieve the encrypted consumer&#39;s payment card, and shipping details from Masterpass. API URL: /masterpass/encrypted-paymentdata/{transactionId}</p>
   * @param transactionId	the Identifies the transaction for which to return the consumer’s payment data. This is the oauth_verifier value sent by Masterpass in the callback URL after the Masterpass UI is closed.
   * @param checkoutId	the This is a unique, 32-character alphanumeric identifier generated by Masterpass, which identifies your settings during a checkout.  You can find this value in your Mastercard Developers account.
   * @param cartId	the This is a merchant Cart identifier.
   * @return 	the EncryptedPaymentDataResponse.
   */
     public static EncryptedPaymentDataResponse show(String transactionId, QueryParams queryParams){
			return show( transactionId,  queryParams, MasterCardApiConfig.config());
            
	}
 
 
 /**
   * EncryptedPaymentData Service
   * <p>Use this service to retrieve the encrypted consumer&#39;s payment card, and shipping details from Masterpass. API URL: /masterpass/encrypted-paymentdata/{transactionId}</p>
   * @param transactionId	the Identifies the transaction for which to return the consumer’s payment data. This is the oauth_verifier value sent by Masterpass in the callback URL after the Masterpass UI is closed.
   * @param checkoutId	the This is a unique, 32-character alphanumeric identifier generated by Masterpass, which identifies your settings during a checkout.  You can find this value in your Mastercard Developers account.
   * @param cartId	the This is a merchant Cart identifier.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the EncryptedPaymentDataResponse.
   */
     public static EncryptedPaymentDataResponse show(String transactionId, QueryParams queryParams, ApiConfig apiConfig){
   
	 String path = "/masterpass/encrypted-paymentdata/{transactionId}";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 serviceRequest.pathParam("transactionId",transactionId);
	 
	 
	 
	 serviceRequest.queryParams(queryParams);
	 serviceRequest.contentType("application/json");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"GET",EncryptedPaymentDataResponse.class);
     
	}
 
}
