package com.mastercard.merchant.checkout;

import com.mastercard.merchant.checkout.model.Pairing;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.merchant.checkout.impl.APITrackerImpl;

public class PairingIdApi {

 /**
   * PairingId Service
   * <p>Use this service to get a consumer’s pairing identifier from Masterpass when they choose to share the payment and shipping information from their Masterpass wallet for future use in an Express Checkout. API URL: /masterpass/pairingid</p>
   * @param pairingTransactionId	the The pairing transaction identifier. It is retrieved through the Masterpass Callback URL.
   * @param userId	the The unique consumer user identifier from the Merchant site.
   * @return 	the Pairing.
   */
     public static Pairing show(QueryParams queryParams){
			return show( queryParams, MasterCardApiConfig.config());
            
	}
 
 
 /**
   * PairingId Service
   * <p>Use this service to get a consumer’s pairing identifier from Masterpass when they choose to share the payment and shipping information from their Masterpass wallet for future use in an Express Checkout. API URL: /masterpass/pairingid</p>
   * @param pairingTransactionId	the The pairing transaction identifier. It is retrieved through the Masterpass Callback URL.
   * @param userId	the The unique consumer user identifier from the Merchant site.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the Pairing.
   */
     public static Pairing show(QueryParams queryParams, ApiConfig apiConfig){
   
	 String path = "/masterpass/pairingid";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 
	 
	 serviceRequest.queryParams(queryParams);
	 serviceRequest.contentType("application/json");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"GET",Pairing.class);
     
	}
 
}
