package com.mastercard.merchant.checkout;

import com.mastercard.merchant.checkout.model.PaymentData;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.merchant.checkout.impl.APITrackerImpl;

public class PaymentDataApi {

 /**
   * PaymentData Service
   * <p>Use this service to retrieve the consumer&#39;s payment card, and shipping details from Masterpass. New or existing Brazil merchants looking for the house number and street name as separate fields should leverage these two additional extension points in their Masterpass checkout integration. Line 4 will provide the house number and line 5 will provide the street name. Brazil merchants should first look for data in lines 4 and 5, and in the case that no data is found there, merchants should then look for data in line 1. API URL: /masterpass/paymentdata/{transactionId}</p>
   * @param transactionId	the Identifies the transaction for which to return the consumer’s payment data. This is the oauth_verifier value sent by Masterpass in the callback URL after the Masterpass UI is closed.
   * @param checkoutId	the This is a unique, 32-character alphanumeric identifier generated by Masterpass, which identifies your settings during a checkout.  You can find this value in your Mastercard Developers account.
   * @param cartId	the This is a merchant Cart identifier.
   * @param pspId	the This is the pspId passed by merchant to select PSP for pushing payment data.
   * @return 	the PaymentData.
   */
     public static PaymentData show(String transactionId, QueryParams queryParams){
			return show( transactionId,  queryParams, MasterCardApiConfig.config());
            
	}
 
 
 /**
   * PaymentData Service
   * <p>Use this service to retrieve the consumer&#39;s payment card, and shipping details from Masterpass. New or existing Brazil merchants looking for the house number and street name as separate fields should leverage these two additional extension points in their Masterpass checkout integration. Line 4 will provide the house number and line 5 will provide the street name. Brazil merchants should first look for data in lines 4 and 5, and in the case that no data is found there, merchants should then look for data in line 1. API URL: /masterpass/paymentdata/{transactionId}</p>
   * @param transactionId	the Identifies the transaction for which to return the consumer’s payment data. This is the oauth_verifier value sent by Masterpass in the callback URL after the Masterpass UI is closed.
   * @param checkoutId	the This is a unique, 32-character alphanumeric identifier generated by Masterpass, which identifies your settings during a checkout.  You can find this value in your Mastercard Developers account.
   * @param cartId	the This is a merchant Cart identifier.
   * @param pspId	the This is the pspId passed by merchant to select PSP for pushing payment data.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 	the PaymentData.
   */
     public static PaymentData show(String transactionId, QueryParams queryParams, ApiConfig apiConfig){
   
	 String path = "/masterpass/paymentdata/{transactionId}";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 serviceRequest.pathParam("transactionId",transactionId);
	 
	 
	 
	 serviceRequest.queryParams(queryParams);
	 serviceRequest.contentType("application/json");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 return apiClient.call(path,serviceRequest,"GET",PaymentData.class);
     
	}
 
}
