package com.mastercard.merchant.checkout;

import com.mastercard.merchant.checkout.model.Postback;

import com.mastercard.sdk.core.invoker.ApiClient;
import com.mastercard.sdk.core.util.ServiceRequest;
import com.mastercard.sdk.core.util.QueryParams;
import com.mastercard.sdk.core.exceptions.MasterpassErrorHandler;
import com.mastercard.sdk.core.ApiConfig;
import com.mastercard.sdk.core.MasterCardApiConfig;
import com.mastercard.merchant.checkout.impl.APITrackerImpl;

public class PostbackApi {

 /**
   * Postback Service
   * <p>This is the final step in the transaction and reports the result of their transactions to Masterpass. Postback is required for all transactions (abandoned transactions do not need to be reported). API URL: /masterpass/postback</p>
   * @param postback	the This is the merchant&#39;s transaction details.
   * @return 
   */
     public static void create(Postback postback){
			
            create( postback, MasterCardApiConfig.config());
	}
 
 
 /**
   * Postback Service
   * <p>This is the final step in the transaction and reports the result of their transactions to Masterpass. Postback is required for all transactions (abandoned transactions do not need to be reported). API URL: /masterpass/postback</p>
   * @param postback	the This is the merchant&#39;s transaction details.
   * @param apiConfig  the ApiConfig object for multiple environment configuration 
   * @return 
   */
     public static void create(Postback postback, ApiConfig apiConfig){
   
	 String path = "/masterpass/postback";
	 ServiceRequest serviceRequest = new ServiceRequest();	
	 
	 
	 serviceRequest.requestBody(postback);
	 
	 serviceRequest.contentType("application/json");
	 
	 ApiClient apiClient = new ApiClient(apiConfig);
     apiClient.setApiTracker(new APITrackerImpl());
	 apiClient.setErrorHandler(new MasterpassErrorHandler());
	 
	 
     apiClient.call(path,serviceRequest,"POST", null);
	}
 
}
