package com.mastercard.merchant.checkout.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains methods to get the consumer&#39;s address details.
 **/
@Root(name = "Address")
@XmlRootElement (name = "Address")
public class Address   {
  
  @SerializedName("city")
  @Element(name = "city", required = false)
  @JsonProperty(value = "city", required = false)
  private String city = null;
  
  @SerializedName("country")
  @Element(name = "country", required = false)
  @JsonProperty(value = "country", required = false)
  private String country = null;
  
  @SerializedName("subdivision")
  @Element(name = "subdivision", required = false)
  @JsonProperty(value = "subdivision", required = false)
  private String subdivision = null;
  
  @SerializedName("line1")
  @Element(name = "line1", required = false)
  @JsonProperty(value = "line1", required = false)
  private String line1 = null;
  
  @SerializedName("line2")
  @Element(name = "line2", required = false)
  @JsonProperty(value = "line2", required = false)
  private String line2 = null;
  
  @SerializedName("line3")
  @Element(name = "line3", required = false)
  @JsonProperty(value = "line3", required = false)
  private String line3 = null;
  
  @SerializedName("line4")
  @Element(name = "line4", required = false)
  @JsonProperty(value = "line4", required = false)
  private String line4 = null;
  
  @SerializedName("line5")
  @Element(name = "line5", required = false)
  @JsonProperty(value = "line5", required = false)
  private String line5 = null;
  
  @SerializedName("postalCode")
  @Element(name = "postalCode", required = false)
  @JsonProperty(value = "postalCode", required = false)
  private String postalCode = null;
  
  
  /**
   * Gets the cardholder's city.
   * 
   * @return	the cardholder's city.
   **/
  @XmlElement(name = "city")
  public String getCity() {
    return city;
  }
  
  /**
  * Sets the cardholder's city.
  *
  * @param city the cardholder's city.
  */
    public Address city(String city) {
    this.city = city;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's country as defined by ISO 3166-1 alpha-2 country codes.
   * 
   * @return	the cardholder's country as defined by ISO 3166-1 alpha-2 country codes.
   **/
  @XmlElement(name = "country")
  public String getCountry() {
    return country;
  }
  
  /**
  * Sets the cardholder's country as defined by ISO 3166-1 alpha-2 country codes.
  *
  * @param country the cardholder's country as defined by ISO 3166-1 alpha-2 country codes.
  */
    public Address country(String country) {
    this.country = country;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's country's subdivision as defined by ISO 3166-1 alpha-2 code for US, CA, AU, JP, and BR. All other countries use a freeform text field.
   * 
   * @return	the cardholder's country's subdivision as defined by ISO 3166-1 alpha-2 code for US, CA, AU, JP, and BR. All other countries use a freeform text field.
   **/
  @XmlElement(name = "subdivision")
  public String getSubdivision() {
    return subdivision;
  }
  
  /**
  * Sets the cardholder's country's subdivision as defined by ISO 3166-1 alpha-2 code for US, CA, AU, JP, and BR. All other countries use a freeform text field.
  *
  * @param subdivision the cardholder's country's subdivision as defined by ISO 3166-1 alpha-2 code for US, CA, AU, JP, and BR. All other countries use a freeform text field.
  */
    public Address subdivision(String subdivision) {
    this.subdivision = subdivision;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder’s house number and the street name.
   * 
   * @return	the cardholder’s house number and the street name.
   **/
  @XmlElement(name = "line1")
  public String getLine1() {
    return line1;
  }
  
  /**
  * Sets the cardholder’s house number and the street name.
  *
  * @param line1 the cardholder’s house number and the street name.
  */
    public Address line1(String line1) {
    this.line1 = line1;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder’s apartment number, suite number, etc.
   * 
   * @return	the cardholder’s apartment number, suite number, etc.
   **/
  @XmlElement(name = "line2")
  public String getLine2() {
    return line2;
  }
  
  /**
  * Sets the cardholder’s apartment number, suite number, etc.
  *
  * @param line2 the cardholder’s apartment number, suite number, etc.
  */
    public Address line2(String line2) {
    this.line2 = line2;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder’s remaining address information that does not fit in lines 1 and 2.
   * 
   * @return	the cardholder’s remaining address information that does not fit in lines 1 and 2.
   **/
  @XmlElement(name = "line3")
  public String getLine3() {
    return line3;
  }
  
  /**
  * Sets the cardholder’s remaining address information that does not fit in lines 1 and 2.
  *
  * @param line3 the cardholder’s remaining address information that does not fit in lines 1 and 2.
  */
    public Address line3(String line3) {
    this.line3 = line3;
    return this;
  }
  
  
    

  
  /**
   * Gets the line4 is only returned for addresses in Brazil, and provides the cardholder’s billing house number. If no data is returned for this field, then reference card​.billingAddress​.line1
   * 
   * @return	the line4 is only returned for addresses in Brazil, and provides the cardholder’s billing house number. If no data is returned for this field, then reference card​.billingAddress​.line1
   **/
  @XmlElement(name = "line4")
  public String getLine4() {
    return line4;
  }
  
  /**
  * Sets the line4 is only returned for addresses in Brazil, and provides the cardholder’s billing house number. If no data is returned for this field, then reference card​.billingAddress​.line1
  *
  * @param line4 the line4 is only returned for addresses in Brazil, and provides the cardholder’s billing house number. If no data is returned for this field, then reference card​.billingAddress​.line1
  */
    public Address line4(String line4) {
    this.line4 = line4;
    return this;
  }
  
  
    

  
  /**
   * Gets the line5 is only returned for addresses in Brazil, and provides the cardholder’s billing street name. If no data is returned for this field, then reference card​.billingAddress​.line1
   * 
   * @return	the line5 is only returned for addresses in Brazil, and provides the cardholder’s billing street name. If no data is returned for this field, then reference card​.billingAddress​.line1
   **/
  @XmlElement(name = "line5")
  public String getLine5() {
    return line5;
  }
  
  /**
  * Sets the line5 is only returned for addresses in Brazil, and provides the cardholder’s billing street name. If no data is returned for this field, then reference card​.billingAddress​.line1
  *
  * @param line5 the line5 is only returned for addresses in Brazil, and provides the cardholder’s billing street name. If no data is returned for this field, then reference card​.billingAddress​.line1
  */
    public Address line5(String line5) {
    this.line5 = line5;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder’s postal code or zip code.
   * 
   * @return	the cardholder’s postal code or zip code.
   **/
  @XmlElement(name = "postalCode")
  public String getPostalCode() {
    return postalCode;
  }
  
  /**
  * Sets the cardholder’s postal code or zip code.
  *
  * @param postalCode the cardholder’s postal code or zip code.
  */
    public Address postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Address address = (Address) o;
    return Objects.equals(city, address.city) &&
        Objects.equals(country, address.country) &&
        Objects.equals(subdivision, address.subdivision) &&
        Objects.equals(line1, address.line1) &&
        Objects.equals(line2, address.line2) &&
        Objects.equals(line3, address.line3) &&
        Objects.equals(line4, address.line4) &&
        Objects.equals(line5, address.line5) &&
        Objects.equals(postalCode, address.postalCode);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(city, country, subdivision, line1, line2, line3, line4, line5, postalCode);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Address {\n");
    
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    subdivision: ").append(toIndentedString(subdivision)).append("\n");
    sb.append("    line1: ").append(toIndentedString(line1)).append("\n");
    sb.append("    line2: ").append(toIndentedString(line2)).append("\n");
    sb.append("    line3: ").append(toIndentedString(line3)).append("\n");
    sb.append("    line4: ").append(toIndentedString(line4)).append("\n");
    sb.append("    line5: ").append(toIndentedString(line5)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


