package com.mastercard.merchant.checkout.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * The contact info details for the wallet user.
 **/
@Root(name = "ContactInfo")
@XmlRootElement (name = "ContactInfo")
public class ContactInfo   {
  
  @SerializedName("firstName")
  @Element(name = "firstName", required = false)
  @JsonProperty(value = "firstName", required = false)
  private String firstName = null;
  
  @SerializedName("lastName")
  @Element(name = "lastName", required = false)
  @JsonProperty(value = "lastName", required = false)
  private String lastName = null;
  
  @SerializedName("country")
  @Element(name = "country", required = false)
  @JsonProperty(value = "country", required = false)
  private String country = null;
  
  @SerializedName("emailAddress")
  @Element(name = "emailAddress", required = false)
  @JsonProperty(value = "emailAddress", required = false)
  private String emailAddress = null;
  
  @SerializedName("phoneNumber")
  @Element(name = "phoneNumber", required = false)
  @JsonProperty(value = "phoneNumber", required = false)
  private String phoneNumber = null;
  
  
  /**
   * Gets the first name associated with the wallet user.
   * 
   * @return	the first name associated with the wallet user.
   **/
  @XmlElement(name = "firstName")
  public String getFirstName() {
    return firstName;
  }
  
  /**
  * Sets the first name associated with the wallet user.
  *
  * @param firstName the first name associated with the wallet user.
  */
    public ContactInfo firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }
  
  
    

  
  /**
   * Gets the last name associated with the wallet user.
   * 
   * @return	the last name associated with the wallet user.
   **/
  @XmlElement(name = "lastName")
  public String getLastName() {
    return lastName;
  }
  
  /**
  * Sets the last name associated with the wallet user.
  *
  * @param lastName the last name associated with the wallet user.
  */
    public ContactInfo lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }
  
  
    

  
  /**
   * Gets the country associated with the wallet user.
   * 
   * @return	the country associated with the wallet user.
   **/
  @XmlElement(name = "country")
  public String getCountry() {
    return country;
  }
  
  /**
  * Sets the country associated with the wallet user.
  *
  * @param country the country associated with the wallet user.
  */
    public ContactInfo country(String country) {
    this.country = country;
    return this;
  }
  
  
    

  
  /**
   * Gets the email address associated with the wallet user.
   * 
   * @return	the email address associated with the wallet user.
   **/
  @XmlElement(name = "emailAddress")
  public String getEmailAddress() {
    return emailAddress;
  }
  
  /**
  * Sets the email address associated with the wallet user.
  *
  * @param emailAddress the email address associated with the wallet user.
  */
    public ContactInfo emailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }
  
  
    

  
  /**
   * Gets the phone number associated with the wallet user.
   * 
   * @return	the phone number associated with the wallet user.
   **/
  @XmlElement(name = "phoneNumber")
  public String getPhoneNumber() {
    return phoneNumber;
  }
  
  /**
  * Sets the phone number associated with the wallet user.
  *
  * @param phoneNumber the phone number associated with the wallet user.
  */
    public ContactInfo phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ContactInfo contactInfo = (ContactInfo) o;
    return Objects.equals(firstName, contactInfo.firstName) &&
        Objects.equals(lastName, contactInfo.lastName) &&
        Objects.equals(country, contactInfo.country) &&
        Objects.equals(emailAddress, contactInfo.emailAddress) &&
        Objects.equals(phoneNumber, contactInfo.phoneNumber);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(firstName, lastName, country, emailAddress, phoneNumber);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ContactInfo {\n");
    
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


