package com.mastercard.merchant.checkout.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains paymentData response parameters returned by EncryptedPaymentDataApi.
 **/
@Root(name = "EncryptedPaymentDataResponse")
@XmlRootElement (name = "EncryptedPaymentDataResponse")
public class EncryptedPaymentDataResponse   {
  
  @SerializedName("encryptedPaymentData")
  @Element(name = "encryptedPaymentData")
  @JsonProperty(value = "encryptedPaymentData")
  private String encryptedPaymentData = null;
  
  
  /**
   * Gets the encrypted payment details.
   * 
   * @return	the encrypted payment details.
   **/
  @XmlElement(name = "encryptedPaymentData")
  public String getEncryptedPaymentData() {
    return encryptedPaymentData;
  }
  
  /**
  * Sets the encrypted payment details.
  *
  * @param encryptedPaymentData the encrypted payment details.
  */
    public EncryptedPaymentDataResponse encryptedPaymentData(String encryptedPaymentData) {
    this.encryptedPaymentData = encryptedPaymentData;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EncryptedPaymentDataResponse encryptedPaymentDataResponse = (EncryptedPaymentDataResponse) o;
    return Objects.equals(encryptedPaymentData, encryptedPaymentDataResponse.encryptedPaymentData);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(encryptedPaymentData);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EncryptedPaymentDataResponse {\n");
    
    sb.append("    encryptedPaymentData: ").append(toIndentedString(encryptedPaymentData)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


