package com.mastercard.merchant.checkout.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mastercard.merchant.checkout.model.Address;
import com.mastercard.merchant.checkout.model.AuthenticationOptions;
import com.mastercard.merchant.checkout.model.Card;
import com.mastercard.merchant.checkout.model.PersonalInfo;
import com.mastercard.merchant.checkout.model.Tokenization;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains various methods to get paymentData response parameters returned by PaymentDataApi.
 **/
@Root(name = "PaymentData")
@XmlRootElement (name = "PaymentData")
public class PaymentData   {
  
  @SerializedName("card")
  @Element(name = "card", required = false)
  @JsonProperty(value = "card", required = false)
  private Card card = null;
  
  @SerializedName("shippingAddress")
  @Element(name = "shippingAddress", required = false)
  @JsonProperty(value = "shippingAddress", required = false)
  private Address shippingAddress = null;
  
  @SerializedName("personalInfo")
  @Element(name = "personalInfo", required = false)
  @JsonProperty(value = "personalInfo", required = false)
  private PersonalInfo personalInfo = null;
  
  @SerializedName("tokenization")
  @Element(name = "tokenization", required = false)
  @JsonProperty(value = "tokenization", required = false)
  private Tokenization tokenization = null;
  
  @SerializedName("walletId")
  @Element(name = "walletId", required = false)
  @JsonProperty(value = "walletId", required = false)
  private String walletId = null;
  
  @SerializedName("walletName")
  @Element(name = "walletName", required = false)
  @JsonProperty(value = "walletName", required = false)
  private String walletName = null;
  
  @SerializedName("authenticationOptions")
  @Element(name = "authenticationOptions", required = false)
  @JsonProperty(value = "authenticationOptions", required = false)
  private AuthenticationOptions authenticationOptions = null;
  
  @SerializedName("pairingId")
  @Element(name = "pairingId", required = false)
  @JsonProperty(value = "pairingId", required = false)
  private String pairingId = null;
  
  @SerializedName("pspTransactionId")
  @Element(name = "pspTransactionId", required = false)
  @JsonProperty(value = "pspTransactionId", required = false)
  private String pspTransactionId = null;
  
  
  /**
   * Gets the payment card details.
   * 
   * @return	the payment card details.
   **/
  @XmlElement(name = "card")
  public Card getCard() {
    return card;
  }
  
  /**
  * Sets the payment card details.
  *
  * @param card the payment card details.
  */
    public PaymentData card(Card card) {
    this.card = card;
    return this;
  }
  
  
    

  
  /**
   * Gets the shipping address details.
   * 
   * @return	the shipping address details.
   **/
  @XmlElement(name = "shippingAddress")
  public Address getShippingAddress() {
    return shippingAddress;
  }
  
  /**
  * Sets the shipping address details.
  *
  * @param shippingAddress the shipping address details.
  */
    public PaymentData shippingAddress(Address shippingAddress) {
    this.shippingAddress = shippingAddress;
    return this;
  }
  
  
    

  
  /**
   * Gets the recipient's personal information.
   * 
   * @return	the recipient's personal information.
   **/
  @XmlElement(name = "personalInfo")
  public PersonalInfo getPersonalInfo() {
    return personalInfo;
  }
  
  /**
  * Sets the recipient's personal information.
  *
  * @param personalInfo the recipient's personal information.
  */
    public PaymentData personalInfo(PersonalInfo personalInfo) {
    this.personalInfo = personalInfo;
    return this;
  }
  
  
    

  
  /**
   * Gets the tokenized card information.
   * 
   * @return	the tokenized card information.
   **/
  @XmlElement(name = "tokenization")
  public Tokenization getTokenization() {
    return tokenization;
  }
  
  /**
  * Sets the tokenized card information.
  *
  * @param tokenization the tokenized card information.
  */
    public PaymentData tokenization(Tokenization tokenization) {
    this.tokenization = tokenization;
    return this;
  }
  
  
    

  
  /**
   * Gets the unique identifier for a wallet that helps identify the origin wallet for the transaction.
   * 
   * @return	the unique identifier for a wallet that helps identify the origin wallet for the transaction.
   **/
  @XmlElement(name = "walletId")
  public String getWalletId() {
    return walletId;
  }
  
  /**
  * Sets the unique identifier for a wallet that helps identify the origin wallet for the transaction.
  *
  * @param walletId the unique identifier for a wallet that helps identify the origin wallet for the transaction.
  */
    public PaymentData walletId(String walletId) {
    this.walletId = walletId;
    return this;
  }
  
  
    

  
  /**
   * Gets the wallet name.
   * 
   * @return	the wallet name.
   **/
  @XmlElement(name = "walletName")
  public String getWalletName() {
    return walletName;
  }
  
  /**
  * Sets the wallet name.
  *
  * @param walletName the wallet name.
  */
    public PaymentData walletName(String walletName) {
    this.walletName = walletName;
    return this;
  }
  
  
    

  
  /**
   * Gets the authentication information.
   * 
   * @return	the authentication information.
   **/
  @XmlElement(name = "authenticationOptions")
  public AuthenticationOptions getAuthenticationOptions() {
    return authenticationOptions;
  }
  
  /**
  * Sets the authentication information.
  *
  * @param authenticationOptions the authentication information.
  */
    public PaymentData authenticationOptions(AuthenticationOptions authenticationOptions) {
    this.authenticationOptions = authenticationOptions;
    return this;
  }
  
  
    

  
  /**
   * Gets the new pairingId.
   * 
   * @return	the new pairingId.
   **/
  @XmlElement(name = "pairingId")
  public String getPairingId() {
    return pairingId;
  }
  
  /**
  * Sets the new pairingId.
  *
  * @param pairingId the new pairingId.
  */
    public PaymentData pairingId(String pairingId) {
    this.pairingId = pairingId;
    return this;
  }
  
  
    

  
  /**
   * Gets the new pspTransactionId.
   * 
   * @return	the new pspTransactionId.
   **/
  @XmlElement(name = "pspTransactionId")
  public String getPspTransactionId() {
    return pspTransactionId;
  }
  
  /**
  * Sets the new pspTransactionId.
  *
  * @param pspTransactionId the new pspTransactionId.
  */
    public PaymentData pspTransactionId(String pspTransactionId) {
    this.pspTransactionId = pspTransactionId;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentData paymentData = (PaymentData) o;
    return Objects.equals(card, paymentData.card) &&
        Objects.equals(shippingAddress, paymentData.shippingAddress) &&
        Objects.equals(personalInfo, paymentData.personalInfo) &&
        Objects.equals(tokenization, paymentData.tokenization) &&
        Objects.equals(walletId, paymentData.walletId) &&
        Objects.equals(walletName, paymentData.walletName) &&
        Objects.equals(authenticationOptions, paymentData.authenticationOptions) &&
        Objects.equals(pairingId, paymentData.pairingId) &&
        Objects.equals(pspTransactionId, paymentData.pspTransactionId);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(card, shippingAddress, personalInfo, tokenization, walletId, walletName, authenticationOptions, pairingId, pspTransactionId);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentData {\n");
    
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    shippingAddress: ").append(toIndentedString(shippingAddress)).append("\n");
    sb.append("    personalInfo: ").append(toIndentedString(personalInfo)).append("\n");
    sb.append("    tokenization: ").append(toIndentedString(tokenization)).append("\n");
    sb.append("    walletId: ").append(toIndentedString(walletId)).append("\n");
    sb.append("    walletName: ").append(toIndentedString(walletName)).append("\n");
    sb.append("    authenticationOptions: ").append(toIndentedString(authenticationOptions)).append("\n");
    sb.append("    pairingId: ").append(toIndentedString(pairingId)).append("\n");
    sb.append("    pspTransactionId: ").append(toIndentedString(pspTransactionId)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


