package com.mastercard.merchant.checkout.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;



/**
 * This class contains precheckout cards details.
 **/
@Root(name = "PreCheckoutCard")
@XmlRootElement (name = "PreCheckoutCard")
public class PreCheckoutCard   {
  
  @SerializedName("brandName")
  @Element(name = "brandName", required = false)
  @JsonProperty(value = "brandName", required = false)
  private String brandName = null;
  
  @SerializedName("cardHolderName")
  @Element(name = "cardHolderName", required = false)
  @JsonProperty(value = "cardHolderName", required = false)
  private String cardHolderName = null;
  
  @SerializedName("cardId")
  @Element(name = "cardId", required = false)
  @JsonProperty(value = "cardId", required = false)
  private String cardId = null;
  
  @SerializedName("default")
  @Element(name = "default", required = false)
  @JsonProperty(value = "default", required = false)
  private Boolean _default = null;
  
  @SerializedName("expiryYear")
  @Element(name = "expiryYear", required = false)
  @JsonProperty(value = "expiryYear", required = false)
  private Integer expiryYear = null;
  
  @SerializedName("expiryMonth")
  @Element(name = "expiryMonth", required = false)
  @JsonProperty(value = "expiryMonth", required = false)
  private Integer expiryMonth = null;
  
  @SerializedName("lastFour")
  @Element(name = "lastFour", required = false)
  @JsonProperty(value = "lastFour", required = false)
  private String lastFour = null;
  
  
  /**
   * Gets the card brand full name (Mastercard, American Express, Diners Club, Discover, JCB, Maestro, Visa).
   * 
   * @return	the card brand full name (Mastercard, American Express, Diners Club, Discover, JCB, Maestro, Visa).
   **/
  @XmlElement(name = "brandName")
  public String getBrandName() {
    return brandName;
  }
  
  /**
  * Sets the card brand full name (Mastercard, American Express, Diners Club, Discover, JCB, Maestro, Visa).
  *
  * @param brandName the card brand full name (Mastercard, American Express, Diners Club, Discover, JCB, Maestro, Visa).
  */
    public PreCheckoutCard brandName(String brandName) {
    this.brandName = brandName;
    return this;
  }
  
  
    

  
  /**
   * Gets the cardholder's name for a card in the wallet.
   * 
   * @return	the cardholder's name for a card in the wallet.
   **/
  @XmlElement(name = "cardHolderName")
  public String getCardHolderName() {
    return cardHolderName;
  }
  
  /**
  * Sets the cardholder's name for a card in the wallet.
  *
  * @param cardHolderName the cardholder's name for a card in the wallet.
  */
    public PreCheckoutCard cardHolderName(String cardHolderName) {
    this.cardHolderName = cardHolderName;
    return this;
  }
  
  
    

  
  /**
   * Gets the unique indenifier for a card in the wallet.
   * 
   * @return	the unique indenifier for a card in the wallet.
   **/
  @XmlElement(name = "cardId")
  public String getCardId() {
    return cardId;
  }
  
  /**
  * Sets the unique indenifier for a card in the wallet.
  *
  * @param cardId the unique indenifier for a card in the wallet.
  */
    public PreCheckoutCard cardId(String cardId) {
    this.cardId = cardId;
    return this;
  }
  
  
    

  
  /**
   * Gets the Boolean value that identifies a card as the default card for the wallet (Specified by the user).
   * 
   * @return	the Boolean value that identifies a card as the default card for the wallet (Specified by the user).
   **/
  @XmlElement(name = "default")
  public Boolean getDefault() {
    return _default;
  }
  
  /**
  * Sets the Boolean value that identifies a card as the default card for the wallet (Specified by the user).
  *
  * @param _default the Boolean value that identifies a card as the default card for the wallet (Specified by the user).
  */
    public PreCheckoutCard _default(Boolean _default) {
    this._default = _default;
    return this;
  }
  
  
    

  
  /**
   * Gets the PAN expiration year, returned as a four digit integer.
   * 
   * @return	the PAN expiration year, returned as a four digit integer.
   **/
  @XmlElement(name = "expiryYear")
  public Integer getExpiryYear() {
    return expiryYear;
  }
  
  /**
  * Sets the PAN expiration year, returned as a four digit integer.
  *
  * @param expiryYear the PAN expiration year, returned as a four digit integer.
  */
    public PreCheckoutCard expiryYear(Integer expiryYear) {
    this.expiryYear = expiryYear;
    return this;
  }
  
  
    

  
  /**
   * Gets the PAN expiration month, returned as a one or two digit integer. No leading zero is required for single digit months e.g. April is 4.
   * 
   * @return	the PAN expiration month, returned as a one or two digit integer. No leading zero is required for single digit months e.g. April is 4.
   **/
  @XmlElement(name = "expiryMonth")
  public Integer getExpiryMonth() {
    return expiryMonth;
  }
  
  /**
  * Sets the PAN expiration month, returned as a one or two digit integer. No leading zero is required for single digit months e.g. April is 4.
  *
  * @param expiryMonth the PAN expiration month, returned as a one or two digit integer. No leading zero is required for single digit months e.g. April is 4.
  */
    public PreCheckoutCard expiryMonth(Integer expiryMonth) {
    this.expiryMonth = expiryMonth;
    return this;
  }
  
  
    

  
  /**
   * Gets the last four digits of the PAN.
   * 
   * @return	the last four digits of the PAN.
   **/
  @XmlElement(name = "lastFour")
  public String getLastFour() {
    return lastFour;
  }
  
  /**
  * Sets the last four digits of the PAN.
  *
  * @param lastFour the last four digits of the PAN.
  */
    public PreCheckoutCard lastFour(String lastFour) {
    this.lastFour = lastFour;
    return this;
  }
  
  
    

  
  /**
   * Returns true if the arguments are equal to each other and false
   * otherwise. Consequently, if both arguments are null, true is returned and
   * if exactly one argument is null, false is returned. Otherwise, equality
   * is determined by using the equals method of the first argument.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PreCheckoutCard preCheckoutCard = (PreCheckoutCard) o;
    return Objects.equals(brandName, preCheckoutCard.brandName) &&
        Objects.equals(cardHolderName, preCheckoutCard.cardHolderName) &&
        Objects.equals(cardId, preCheckoutCard.cardId) &&
        Objects.equals(_default, preCheckoutCard._default) &&
        Objects.equals(expiryYear, preCheckoutCard.expiryYear) &&
        Objects.equals(expiryMonth, preCheckoutCard.expiryMonth) &&
        Objects.equals(lastFour, preCheckoutCard.lastFour);
  }
  
  /**
  *	Generates a hash code for a sequence of input values.
  */
  @Override
  public int hashCode() {
    return Objects.hash(brandName, cardHolderName, cardId, _default, expiryYear, expiryMonth, lastFour);
  }
  
  /**
  *	Returns the result of calling toString for a non-null argument and "null" for a null argument.
  */	
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PreCheckoutCard {\n");
    
    sb.append("    brandName: ").append(toIndentedString(brandName)).append("\n");
    sb.append("    cardHolderName: ").append(toIndentedString(cardHolderName)).append("\n");
    sb.append("    cardId: ").append(toIndentedString(cardId)).append("\n");
    sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
    sb.append("    expiryYear: ").append(toIndentedString(expiryYear)).append("\n");
    sb.append("    expiryMonth: ").append(toIndentedString(expiryMonth)).append("\n");
    sb.append("    lastFour: ").append(toIndentedString(lastFour)).append("\n");
    sb.append("}");
    return sb.toString();
  }
  
  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}


