/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.abstractions.list;

import com.mastfrog.abstractions.list.IndexedAsIterable;
import com.mastfrog.abstractions.list.IntAddressable;
import com.mastfrog.abstractions.list.IntSized;
import com.mastfrog.abstractions.list.LongIndexed;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntSupplier;

public interface Indexed<T>
extends IntAddressable<T>,
IntSized {
    public static <T> Indexed<T> fromList(final List<T> list) {
        return new Indexed<T>(){

            @Override
            public T forIndex(int index) {
                return list.get(index);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public Iterable<T> toIterable() {
                return list;
            }

            @Override
            public Iterator<T> toIterator() {
                return list.iterator();
            }
        };
    }

    default public Iterable<T> toIterable() {
        return new IndexedAsIterable(this, this);
    }

    default public Iterator<T> toIterator() {
        return new IndexedAsIterable(this, this);
    }

    public static <T> Indexed<T> compose(int size, IntAddressable<T> lookup) {
        return Indexed.compose(() -> size, lookup);
    }

    public static <T> Indexed<T> compose(IntAddressable<T> lookup, IntSized sizeSupplier) {
        return Indexed.compose(() -> sizeSupplier.size(), lookup);
    }

    public static <T> Indexed<T> compose(final IntSupplier sizeSupplier, final IntAddressable<T> lookup) {
        return new Indexed<T>(){

            @Override
            public T forIndex(int index) {
                return lookup.forIndex(index);
            }

            @Override
            public int size() {
                return sizeSupplier.getAsInt();
            }
        };
    }

    default public LongIndexed toLongIndexed() {
        return LongIndexed.compose(this.toLongSized(), this.toLongAddressable());
    }
}

