/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.abstractions.list;

import com.mastfrog.abstractions.list.ArrayIndexed;
import com.mastfrog.abstractions.list.Indexed;
import com.mastfrog.abstractions.list.IntAddressable;
import com.mastfrog.abstractions.list.IntResolvable;
import com.mastfrog.abstractions.list.IntSized;
import com.mastfrog.abstractions.list.ListAsIndexed;
import com.mastfrog.abstractions.list.LongIndexedResolvable;
import com.mastfrog.abstractions.list.StringArrayIndexed;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.IntSupplier;

public interface IndexedResolvable<T>
extends Indexed<T>,
IntResolvable,
IntSized {
    public static <T> IndexedResolvable<T> fromList(List<T> list) {
        return new ListAsIndexed<T>(list);
    }

    public static <T> IndexedResolvable<T> compose(IntAddressable<T> lookup, int size, IntResolvable reverseLookup) {
        return IndexedResolvable.compose(lookup, () -> size, reverseLookup);
    }

    public static <T extends Comparable<T>> IndexedResolvable<T> fromArray(T[] arr) {
        return ArrayIndexed.fromArray(arr);
    }

    public static <T> IndexedResolvable<T> fromPreSortedArray(T[] arr) {
        return new ArrayIndexed<T>(arr);
    }

    public static <T extends Comparable<? super T>> IndexedResolvable<T> fromCollection(Class<T> type, Collection<? extends T> coll) {
        return ArrayIndexed.create(type, coll);
    }

    public static <T> IndexedResolvable<T> fromCollection(Class<T> type, Collection<? extends T> coll, Comparator<? super T> comp) {
        return new ArrayIndexed<T>(type, coll, comp);
    }

    public static <T> IndexedResolvable<T> compose(final IntAddressable<T> lookup, final IntSupplier size, final IntResolvable reverseLookup) {
        return new IndexedResolvable<T>(){

            @Override
            public T forIndex(int index) {
                return lookup.forIndex(index);
            }

            @Override
            public int indexOf(Object obj) {
                return reverseLookup.indexOf(obj);
            }

            @Override
            public int size() {
                return size.getAsInt();
            }
        };
    }

    default public Iterable<T> asIterable() {
        class I
        implements Iterable<T>,
        Iterator<T> {
            int ix = -1;

            I() {
            }

            @Override
            public Iterator<T> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                return this.ix + 1 < IndexedResolvable.this.size();
            }

            @Override
            public T next() {
                return IndexedResolvable.this.forIndex(++this.ix);
            }
        }
        return new I();
    }

    default public List<T> populate(List<T> list) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            list.add(this.forIndex(i));
        }
        return list;
    }

    default public List<T> toList() {
        return this.populate(new ArrayList(this.size()));
    }

    public static IndexedResolvable<String> forSortedStringArray(String ... strings) {
        return new StringArrayIndexed(strings);
    }

    public static IndexedResolvable<String> forStringSet(Set<String> set) {
        Object[] sortedArray = new String[set.size()];
        sortedArray = set.toArray(sortedArray);
        if (!(set instanceof SortedSet)) {
            Arrays.sort(sortedArray);
        }
        return new StringArrayIndexed((String[])sortedArray);
    }

    public static IndexedResolvable<String> forStringList(List<String> set) {
        Object[] sortedArray = new String[set.size()];
        sortedArray = set.toArray(sortedArray);
        Arrays.sort(sortedArray);
        return new StringArrayIndexed((String[])sortedArray);
    }

    public static <T> IndexedResolvable<T> forList(final List<T> list) {
        if (!5.$assertionsDisabled && new HashSet<T>(list).size() != list.size()) {
            throw new AssertionError();
        }
        return new IndexedResolvable<T>(){

            @Override
            public int indexOf(Object o) {
                return list.indexOf(o);
            }

            @Override
            public T forIndex(int index) {
                return list.get(index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    default public Collection<T> asCollection() {
        return new Collection<T>(){

            @Override
            public int size() {
                return IndexedResolvable.this.size();
            }

            @Override
            public boolean isEmpty() {
                return IndexedResolvable.this.size() == 0;
            }

            @Override
            public boolean contains(Object o) {
                int sz = this.size();
                for (int i = 0; i < sz; ++i) {
                    if (!Objects.equals(o, IndexedResolvable.this.forIndex(i))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<T> iterator() {
                return IndexedResolvable.this.asIterable().iterator();
            }

            @Override
            public Object[] toArray() {
                Object[] objs = new Object[this.size()];
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = IndexedResolvable.this.forIndex(i);
                }
                return objs;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int sz = this.size();
                if (sz != a.length) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), sz);
                }
                for (int i = 0; i < sz; ++i) {
                    a[i] = IndexedResolvable.this.forIndex(i);
                }
                return a;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean add(T e) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("read-only");
            }
        };
    }

    default public LongIndexedResolvable<T> toLongIndexedResolvable() {
        return new LongIndexedResolvable<T>(){

            @Override
            public T forIndex(long index) {
                return IndexedResolvable.this.forIndex((int)index);
            }

            @Override
            public long size() {
                return IndexedResolvable.this.size();
            }

            @Override
            public long indexOf(Object obj) {
                return IndexedResolvable.this.indexOf(obj);
            }
        };
    }

    static {
        if (5.$assertionsDisabled) {
            // empty if block
        }
    }
}

