/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.abstractions.list;

import com.mastfrog.abstractions.list.LongAddressable;
import com.mastfrog.abstractions.list.LongSized;
import java.util.Iterator;

final class LongIndexedAsIterable<T>
implements Iterable<T>,
Iterator<T> {
    private final LongSized sizeProvider;
    private final LongAddressable<T> lookup;
    private long pos = -1L;

    LongIndexedAsIterable(LongSized sizeProvider, LongAddressable<T> lookup) {
        this.sizeProvider = sizeProvider;
        this.lookup = lookup;
    }

    @Override
    public Iterator<T> iterator() {
        return this.pos == -1L ? this : new LongIndexedAsIterable<T>(this.sizeProvider, this.lookup);
    }

    @Override
    public boolean hasNext() {
        return this.pos + 1L < this.sizeProvider.size();
    }

    @Override
    public T next() {
        return this.lookup.forIndex(++this.pos);
    }
}

