/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.abstractions.list;

import com.mastfrog.abstractions.list.IndexedResolvable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;

final class ArrayIndexed<T>
implements IndexedResolvable<T> {
    private final T[] sortedArray;

    ArrayIndexed(T[] sortedArray) {
        this.sortedArray = sortedArray;
    }

    ArrayIndexed(Class<T> type, Collection<? extends T> coll, Comparator<? super T> comp) {
        Object[] objs = (Object[])Array.newInstance(type, coll.size());
        this.sortedArray = coll.toArray(objs);
        if (!(coll instanceof SortedSet)) {
            Arrays.sort(objs, comp);
        }
    }

    static <T extends Comparable<T>> ArrayIndexed<T> fromCollection(Collection<? extends T> coll, Class<T> type) {
        Comparator comp = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        };
        return new ArrayIndexed<T>(type, coll, comp);
    }

    static <T extends Comparable<? super T>> ArrayIndexed<T> fromArray(T[] array) {
        if (ArrayIndexed.isSorted(array)) {
            return new ArrayIndexed<T>(array);
        }
        Comparable[] nue = (Comparable[])Arrays.copyOf(array, array.length);
        return new ArrayIndexed<Comparable>(nue);
    }

    static <T extends Comparable<? super T>> ArrayIndexed<T> create(Class<T> type, Collection<? extends T> coll) {
        return new ArrayIndexed<T>(type, coll, Comparable::compareTo);
    }

    static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        Comparable last = null;
        for (int i = 0; i < array.length; ++i) {
            int ix;
            T object = array[i];
            if (last == null || (ix = last.compareTo(object)) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public T forIndex(int index) {
        return this.sortedArray[index];
    }

    @Override
    public int size() {
        return this.sortedArray.length;
    }

    @Override
    public int indexOf(Object obj) {
        if (!this.sortedArray.getClass().getComponentType().isInstance(obj)) {
            return -1;
        }
        return Arrays.binarySearch(this.sortedArray, obj);
    }
}

