/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.abstractions.list;

import com.mastfrog.abstractions.list.IntAddressable;
import com.mastfrog.abstractions.list.IntSized;
import java.util.Iterator;

final class IndexedAsIterable<T>
implements Iterable<T>,
Iterator<T> {
    private final IntSized sizeProvider;
    private final IntAddressable<T> lookup;
    private int pos = -1;

    public IndexedAsIterable(IntSized sizeProvider, IntAddressable<T> lookup) {
        this.sizeProvider = sizeProvider;
        this.lookup = lookup;
    }

    @Override
    public Iterator<T> iterator() {
        return this.pos == -1 ? this : new IndexedAsIterable<T>(this.sizeProvider, this.lookup);
    }

    @Override
    public boolean hasNext() {
        return this.pos + 1 < this.sizeProvider.size();
    }

    @Override
    public T next() {
        return this.lookup.forIndex(++this.pos);
    }
}

