/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.abstractions.list;

import com.mastfrog.abstractions.list.LongAddressable;
import com.mastfrog.abstractions.list.LongIndexedAsIterable;
import com.mastfrog.abstractions.list.LongSized;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongSupplier;

public interface LongIndexed<T>
extends LongAddressable<T>,
LongSized {
    public static <T> LongIndexed<T> fromList(final List<T> list) {
        return new LongIndexed<T>(){

            @Override
            public T forIndex(long index) {
                if (index > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Value out of range: " + index);
                }
                return list.get((int)index);
            }

            @Override
            public long size() {
                return list.size();
            }

            @Override
            public Iterable<T> toIterable() {
                return list;
            }

            @Override
            public Iterator<T> toIterator() {
                return list.iterator();
            }
        };
    }

    default public Iterable<T> toIterable() {
        return new LongIndexedAsIterable(this, this);
    }

    default public Iterator<T> toIterator() {
        return new LongIndexedAsIterable(this, this);
    }

    public static <T> LongIndexed<T> compose(long size, LongAddressable<T> lookup) {
        return LongIndexed.compose(() -> size, lookup);
    }

    public static <T> LongIndexed<T> compose(LongAddressable<T> lookup, LongSupplier sizeSupplier) {
        return LongIndexed.compose(() -> sizeSupplier.getAsLong(), lookup);
    }

    public static <T> LongIndexed<T> compose(final LongSized sizeSupplier, final LongAddressable<T> lookup) {
        return new LongIndexed<T>(){

            @Override
            public T forIndex(long index) {
                return lookup.forIndex(index);
            }

            @Override
            public long size() {
                return sizeSupplier.size();
            }
        };
    }
}

