/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.abstractions.list;

import com.mastfrog.abstractions.list.LongAddressable;
import com.mastfrog.abstractions.list.LongIndexed;
import com.mastfrog.abstractions.list.LongListAsIndexed;
import com.mastfrog.abstractions.list.LongResolvable;
import com.mastfrog.abstractions.list.LongSized;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;

public interface LongIndexedResolvable<T>
extends LongIndexed<T>,
LongResolvable,
LongSized {
    public static <T> LongIndexedResolvable<T> fromList(List<T> list) {
        Objects.requireNonNull(list, "list null");
        return new LongListAsIndexed<T>(list);
    }

    public static <T> LongIndexedResolvable<T> compose(LongAddressable<T> lookup, int size, LongResolvable reverseLookup) {
        Objects.requireNonNull(lookup, "lookup");
        Objects.requireNonNull(lookup, "reverseLookup");
        return LongIndexedResolvable.compose(lookup, () -> size, reverseLookup);
    }

    public static <T> LongIndexedResolvable<T> compose(final LongAddressable<T> lookup, final LongSupplier size, final LongResolvable reverseLookup) {
        return new LongIndexedResolvable<T>(){

            @Override
            public T forIndex(long index) {
                return lookup.forIndex(index);
            }

            @Override
            public long indexOf(Object obj) {
                return reverseLookup.indexOf(obj);
            }

            @Override
            public long size() {
                return size.getAsLong();
            }
        };
    }

    default public Iterable<T> asIterable() {
        class I
        implements Iterable<T>,
        Iterator<T> {
            int ix = -1;

            I() {
            }

            @Override
            public Iterator<T> iterator() {
                return this;
            }

            @Override
            public boolean hasNext() {
                return (long)(this.ix + 1) < LongIndexedResolvable.this.size();
            }

            @Override
            public T next() {
                return LongIndexedResolvable.this.forIndex(++this.ix);
            }
        }
        return new I();
    }

    default public List<T> populate(List<T> list) {
        long sz = this.size();
        int i = 0;
        while ((long)i < sz) {
            list.add(this.forIndex(i));
            ++i;
        }
        return list;
    }

    default public List<T> toList() {
        if (this.size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size too large: " + this.size());
        }
        return this.populate(new ArrayList((int)this.size()));
    }

    public static <T> LongIndexedResolvable<T> forList(final List<T> list) {
        if (!4.$assertionsDisabled && new HashSet<T>(list).size() != list.size()) {
            throw new AssertionError();
        }
        return new LongIndexedResolvable<T>(){

            @Override
            public long indexOf(Object o) {
                return list.indexOf(o);
            }

            @Override
            public T forIndex(long index) {
                if (index > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Index too large: " + index);
                }
                return list.get((int)index);
            }

            @Override
            public long size() {
                return list.size();
            }
        };
    }

    default public Collection<T> asCollection() {
        return new Collection<T>(){

            @Override
            public int size() {
                if (LongIndexedResolvable.this.size() > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Size too large");
                }
                return (int)LongIndexedResolvable.this.size();
            }

            @Override
            public boolean isEmpty() {
                return LongIndexedResolvable.this.size() == 0L;
            }

            @Override
            public boolean contains(Object o) {
                int sz = this.size();
                for (int i = 0; i < sz; ++i) {
                    if (!Objects.equals(o, LongIndexedResolvable.this.forIndex(i))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<T> iterator() {
                return LongIndexedResolvable.this.asIterable().iterator();
            }

            @Override
            public Object[] toArray() {
                Object[] objs = new Object[this.size()];
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = LongIndexedResolvable.this.forIndex(i);
                }
                return objs;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int sz = this.size();
                if (sz != a.length) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), sz);
                }
                for (int i = 0; i < sz; ++i) {
                    a[i] = LongIndexedResolvable.this.forIndex(i);
                }
                return a;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean add(T e) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("read-only");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("read-only");
            }
        };
    }

    static {
        if (4.$assertionsDisabled) {
            // empty if block
        }
    }
}

