/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.abstractions.list;

import com.mastfrog.abstractions.list.LongIndexedResolvable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

final class LongListAsIndexed<T>
implements LongIndexedResolvable<T> {
    private final List<T> list;

    public LongListAsIndexed(List<T> list) {
        this.list = list;
    }

    @Override
    public T forIndex(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value out of range: " + index);
        }
        return this.list.get((int)index);
    }

    @Override
    public long size() {
        return this.list.size();
    }

    @Override
    public long indexOf(Object obj) {
        return this.list.indexOf(obj);
    }

    @Override
    public Iterable<T> toIterable() {
        return this.list;
    }

    @Override
    public Iterator<T> toIterator() {
        return this.list.iterator();
    }

    @Override
    public Iterable<T> asIterable() {
        return this.list;
    }

    @Override
    public List<T> toList() {
        return this.list;
    }

    @Override
    public Collection<T> asCollection() {
        return this.list;
    }
}

