/*
 * The MIT License
 *
 * Copyright 2018 tim.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.mastfrog.acteur.preconditions;

import com.mastfrog.acteur.headers.Method;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks endpoints that should have CORS headers associated with it. Inject a
 * CORSResponseDecorator to customize the response.
 *
 * @author Tim Boudreau
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Description("Marks this endpoint as needing "
        + "<i>cross-origin-resource-security</i> (CORS) headers set")
public @interface CORS {

    /**
     * By default, returns true. Set to false to turn OFF CORS handling in the
     * case that you have it enabled globally.
     *
     * @return
     */
    boolean value() default true;

    /**
     * Set the methods cors responses are valid for. If unset or empty, the
     * value will be derived from the registered paths in the application.
     *
     * @return A set of methods
     */
    Method[] methods() default {};

    /**
     * The added access control allowed headers.
     *
     * @return A list of header names.
     */
    String[] headers() default {};

    /**
     * The set of origins cors responses apply to.
     *
     * @return Origins
     */
    String[] origins() default {};

    /**
     * The maximum age in seconds for cors responses.
     *
     * @return
     */
    int maxAgeSeconds() default 0;
}
