/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Injector;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.DeferredComputationResult;
import com.mastfrog.acteur.DeferredComputationResultActeur;
import com.mastfrog.acteur.ErrorActeur;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.Response;
import com.mastfrog.acteur.ResponseImpl;
import com.mastfrog.acteur.ResponseWriter;
import com.mastfrog.acteur.State;
import com.mastfrog.acteur.errors.Err;
import com.mastfrog.acteur.errors.ErrorRenderer;
import com.mastfrog.acteur.errors.ErrorResponse;
import com.mastfrog.acteur.errors.ExceptionEvaluatorRegistry;
import com.mastfrog.acteur.errors.ResponseException;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.acteurbase.AbstractActeur;
import com.mastfrog.acteurbase.ActeurResponseFactory;
import com.mastfrog.acteurbase.Chain;
import com.mastfrog.acteurbase.Deferral;
import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.mime.MimeType;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.collections.ArrayUtils;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.function.EnhCompletableFuture;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;

public abstract class Acteur
extends AbstractActeur<Response, ResponseImpl, State> {
    private static final RT INSTANCE = new RT();
    private static final Object[] EMPTY = new Object[0];

    protected Acteur() {
        super((ActeurResponseFactory)INSTANCE);
    }

    protected State getState() {
        return (State)super.getState();
    }

    public Object[] getContextContribution() {
        return EMPTY;
    }

    final Throwable creationStackTrace() {
        return this.creationStackTrace;
    }

    protected <T> Acteur add(HeaderValueType<T> decorator, T value) {
        this.response().add(decorator, value);
        return this;
    }

    protected ResponseImpl getResponse() {
        if (this instanceof Delegate) {
            return ((Delegate)((Object)this)).getDelegate().getResponse();
        }
        return (ResponseImpl)super.getResponse();
    }

    protected <T> T get(HeaderValueType<T> header) {
        return this.response().get(header);
    }

    public final Acteur setResponseCode(HttpResponseStatus status) {
        this.response().status(status);
        return this;
    }

    public final Acteur setMessage(Object message) {
        this.response().content(message);
        return this;
    }

    public final Acteur setChunked(boolean chunked) {
        this.response().chunked(chunked);
        return this;
    }

    protected final Response response() {
        if (this instanceof Delegate) {
            return ((Delegate)((Object)this)).getDelegate().response();
        }
        return (Response)super.response();
    }

    static Acteur error(Acteur errSource, Page page, Throwable t, Event<?> evt, boolean log) {
        try {
            return new ErrorActeur(errSource, evt, page, t, true, log);
        }
        catch (IOException ex) {
            page.application.internalOnError(t);
            try {
                return new ErrorActeur(errSource, evt, page, t, true, log);
            }
            catch (IOException ex1) {
                return (Acteur)((Object)Exceptions.chuck((Throwable)ex1));
            }
        }
    }

    public void describeYourself(Map<String, Object> into) {
    }

    protected final Acteur noContent() {
        this.setState(new RespondWith(HttpResponseStatus.NO_CONTENT));
        return this;
    }

    protected final Acteur badRequest() {
        this.setState(new RespondWith(HttpResponseStatus.BAD_REQUEST));
        return this;
    }

    protected final Acteur badRequest(Object msg) {
        this.setState(new RespondWith(HttpResponseStatus.BAD_REQUEST, msg));
        return this;
    }

    protected final Acteur notFound() {
        this.setState(new RespondWith(HttpResponseStatus.NOT_FOUND));
        return this;
    }

    protected final Acteur notFound(Object msg) {
        this.setState(new RespondWith(HttpResponseStatus.NOT_FOUND, msg));
        return this;
    }

    protected final Acteur ok(Object msg) {
        this.setState(new RespondWith(HttpResponseStatus.OK, msg));
        return this;
    }

    protected final Acteur ok() {
        this.setState(new RespondWith(HttpResponseStatus.OK));
        return this;
    }

    protected final Acteur reply(HttpResponseStatus status) {
        this.setState(new RespondWith(status));
        return this;
    }

    protected final Acteur reply(HttpResponseStatus status, Object msg) {
        this.setState(new RespondWith(status, msg));
        return this;
    }

    protected final Acteur reply(Err err) {
        this.setState(new RespondWith(err));
        if (!err.headers().isEmpty()) {
            for (Map.Entry<CharSequence, CharSequence> e : err.headers().entrySet()) {
                this.add(Headers.header((CharSequence)e.getKey()), e.getValue());
            }
        }
        return this;
    }

    protected final Acteur reject() {
        this.setState(new RejectedState());
        return this;
    }

    protected final Acteur next(Object ... context) {
        if (context == null || context.length == 0) {
            this.setState(new ConsumedState(new Object[0]));
        } else {
            this.setState(new ConsumedLockedState(context));
        }
        return this;
    }

    protected final Acteur continueAfter(CompletionStage<?> ... stages) {
        return this.continueAfter(false, stages);
    }

    protected final <T> Acteur continueAfter(ThrowingConsumer<EnhCompletableFuture<T>> c) {
        Dependencies deps = Page.get().getApplication().getDependencies();
        Chain chain = (Chain)deps.getInstance(Chain.class);
        chain.insert(CheckThrownActeur.class);
        EnhCompletableFuture fut = new EnhCompletableFuture();
        this.logErrors((CompletionStage<?>)fut);
        this.then((ThrowingConsumer<Deferral.Resumer>)((ThrowingConsumer)res -> {
            fut.whenComplete((t, thrown) -> {
                if (thrown != null) {
                    res.resume(new Object[]{DeferredComputationResult.thrown(thrown)});
                } else if (t == null) {
                    res.resume(new Object[0]);
                } else {
                    Object[] objs = t.getClass().isArray() ? ArrayUtils.concatenate((Object[])CollectionUtils.toList((Object)t).toArray(), (Object[])new Object[]{DeferredComputationResult.empty()}) : new Object[]{t, DeferredComputationResult.empty()};
                    res.resume(objs);
                }
            });
            c.accept((Object)fut);
        }));
        return this;
    }

    protected final Acteur continueAfter(boolean unwrapArrays, CompletionStage<?> ... stages) {
        Checks.nonZero((String)"stages", (int)((CompletionStage[])Checks.noNullElements((String)"stages", (Object[])((CompletionStage[])Checks.notNull((String)"stages", stages)))).length);
        if (stages.length == 0) {
            throw new IllegalArgumentException("Stages may not be an empty array");
        }
        Dependencies deps = Page.get().getApplication().getDependencies();
        Chain chain = (Chain)deps.getInstance(Chain.class);
        chain.insert(CheckThrownActeur.class);
        CopyOnWriteArrayList l = new CopyOnWriteArrayList();
        AtomicBoolean alreadyResumed = new AtomicBoolean();
        AtomicInteger count = new AtomicInteger();
        for (CompletionStage<?> c : stages) {
            this.logErrors(c);
        }
        return this.then((ThrowingConsumer<Deferral.Resumer>)((ThrowingConsumer)resumer -> {
            for (CompletionStage c : stages) {
                c.whenComplete((o, t) -> {
                    if (t != null) {
                        if (alreadyResumed.compareAndSet(false, true)) {
                            l.add(DeferredComputationResult.thrown(t));
                            resumer.resume(l.toArray(new Object[l.size()]));
                        }
                    } else {
                        if (o != null) {
                            if (unwrapArrays && o.getClass().isArray()) {
                                l.addAll(CollectionUtils.toList((Object)o));
                            } else {
                                l.add(o);
                            }
                        }
                        if (count.incrementAndGet() == stages.length && alreadyResumed.compareAndSet(false, true)) {
                            l.add(DeferredComputationResult.empty());
                            resumer.resume(l.toArray(new Object[l.size()]));
                        }
                    }
                });
            }
        }));
    }

    private void logErrors(CompletionStage<?> stage) {
        ApplicationControl ctrl = Page.get().application.control();
        ctrl.logErrors(stage);
    }

    protected final <T> EnhCompletableFuture<T> deferThenRespond() {
        EnhCompletableFuture result = new EnhCompletableFuture();
        this.logErrors((CompletionStage<?>)result);
        this.then((CompletionStage<T>)result);
        return result;
    }

    protected final <T> EnhCompletableFuture<T> deferThenRespond(HttpResponseStatus successStatus) {
        EnhCompletableFuture result = new EnhCompletableFuture();
        this.logErrors((CompletionStage<?>)result);
        this.then((CompletionStage<T>)result, successStatus);
        return result;
    }

    protected final <T> EnhCompletableFuture<T> defer() {
        EnhCompletableFuture result = new EnhCompletableFuture();
        this.logErrors((CompletionStage<?>)result);
        this.continueAfter(new CompletionStage[]{result});
        return result;
    }

    protected final Acteur then(ThrowingConsumer<Deferral.Resumer> cons) {
        this.next(new Object[0]);
        Deferral def = (Deferral)Page.get().getApplication().getDependencies().getInstance(Deferral.class);
        def.defer(res -> cons.accept((Object)res));
        return this;
    }

    protected final <T> Acteur then(CompletionStage<T> c) {
        return this.then(c, null);
    }

    protected final <T> Acteur then(CompletionStage<T> c, HttpResponseStatus successStatus) {
        this.logErrors(c);
        Dependencies deps = Page.get().getApplication().getDependencies();
        Chain chain = (Chain)deps.getInstance(Chain.class);
        chain.add(DeferredComputationResultActeur.class);
        return this.then((ThrowingConsumer<Deferral.Resumer>)((ThrowingConsumer)r -> c.whenComplete((t, thrown) -> r.resume(new Object[]{new DeferredComputationResult(t, (Throwable)thrown, successStatus)}))));
    }

    protected final <T extends ResponseWriter> Acteur setResponseWriter(Class<T> writerType) {
        Page page = Page.get();
        Dependencies deps = page.getApplication().getDependencies();
        HttpEvent evt = (HttpEvent)deps.getInstance(HttpEvent.class);
        this.response();
        this.getResponse().setWriter(writerType, deps, evt);
        return this;
    }

    protected final <T extends ResponseWriter> Acteur setResponseWriter(T writer) {
        Page page = Page.get();
        Dependencies deps = page.getApplication().getDependencies();
        HttpEvent evt = (HttpEvent)deps.getInstance(HttpEvent.class);
        this.response();
        this.getResponse().setWriter(writer, deps, evt);
        return this;
    }

    protected final <T extends ChannelFutureListener> Acteur setResponseBodyWriter(Class<T> type) {
        this.setResponseBodyWriter(new IWrapper<T>(type, Page.get()));
        return this;
    }

    protected final Dependencies dependencies() {
        Page p = Page.get();
        Application app = p.getApplication();
        return app.getDependencies();
    }

    public final Acteur setResponseBodyWriter(ChannelFutureListener listener) {
        if (listener == ChannelFutureListener.CLOSE || listener == ChannelFutureListener.CLOSE_ON_FAILURE || listener == ResponseImpl.SEND_EMPTY_LAST_CHUNK || listener instanceof ResponseImpl.SendOneBuffer || listener instanceof IWrapper) {
            this.response();
            this.getResponse().contentWriter(listener);
            return this;
        }
        Page p = Page.get();
        Application app = p.getApplication();
        this.response().contentWriter(new ScopeWrapper(app, listener, p));
        return this;
    }

    public static Acteur wrap(Class<? extends Acteur> type, Dependencies deps) {
        Checks.notNull((String)"type", type);
        Charset charset = (Charset)deps.getInstance(Charset.class);
        return new WrapperActeur(deps, charset, type);
    }

    static class RT
    extends ActeurResponseFactory<Response, ResponseImpl> {
        RT() {
        }

        protected ResponseImpl create() {
            return new ResponseImpl();
        }

        protected boolean isFinished(ResponseImpl obj) {
            return obj != null && obj.status != null;
        }

        protected boolean isModified(ResponseImpl obj) {
            return obj != null && obj.isModified();
        }
    }

    public static interface Delegate {
        public Acteur getDelegate();
    }

    public class RespondWith
    extends BaseState {
        public RespondWith(int status) {
            this(HttpResponseStatus.valueOf((int)status));
        }

        public RespondWith(HttpResponseStatus status) {
            this(status, (Object)null);
        }

        public RespondWith(int status, Object msg) {
            this(HttpResponseStatus.valueOf((int)status), msg);
        }

        public RespondWith(ErrorResponse err) {
            super(false);
            Acteur.this.setResponseCode(err.status());
            ErrorRenderer ren = (ErrorRenderer)this.getLockedPage().getApplication().getDependencies().getInstance(ErrorRenderer.class);
            try {
                String message = ren.render(err, (Event)this.getLockedPage().getApplication().getDependencies().getInstance(HttpEvent.class));
                Acteur.this.setMessage(message);
            }
            catch (IOException ex) {
                Exceptions.chuck((Throwable)ex);
            }
        }

        public RespondWith(HttpResponseStatus status, Object msg) {
            super(false);
            if (this.page == null) {
                IllegalStateException e = new IllegalStateException("Called outside ActionsImpl.onEvent");
                e.printStackTrace();
                throw e;
            }
            Acteur.this.setResponseCode(status);
            if (msg != null) {
                Acteur.this.setMessage(msg);
            }
        }

        public String toString() {
            return "Respond with " + Acteur.this.getResponse().internalStatus() + " - " + super.toString() + " - " + Acteur.this.getResponse().getMessage();
        }
    }

    protected class RejectedState
    extends BaseState {
        public RejectedState() {
            super(true);
            if (this.page == null) {
                throw new IllegalStateException("Called outside ActionsImpl.onEvent");
            }
        }

        public RejectedState(HttpResponseStatus status) {
            super(true);
            Acteur.this.setResponseCode(status);
        }
    }

    protected class ConsumedState
    extends BaseState {
        private final Page page;
        private final Object[] context;

        public ConsumedState(Object ... context) {
            super(false);
            this.page = Page.get();
            if (this.page == null) {
                throw new IllegalStateException("Called outside ActionsImpl.onEvent");
            }
            this.context = context;
        }
    }

    protected class ConsumedLockedState
    extends BaseState {
        private final Page page;

        public ConsumedLockedState(Object ... context) {
            super(context);
            this.page = Page.get();
            if (this.page == null) {
                throw new IllegalStateException("Called outside ActionsImpl.onEvent");
            }
        }
    }

    static final class CheckThrownActeur
    extends Acteur {
        @Inject
        CheckThrownActeur(DeferredComputationResult res, ExceptionEvaluatorRegistry evals, HttpEvent evt) throws Throwable {
            if (res.thrown != null) {
                if (res.thrown instanceof ResponseException) {
                    ResponseException rex = (ResponseException)res.thrown;
                    Map<CharSequence, CharSequence> hdrs = rex.headers();
                    if (!hdrs.isEmpty()) {
                        for (Map.Entry<CharSequence, CharSequence> e : hdrs.entrySet()) {
                            this.add(Headers.header((CharSequence)e.getKey()), e.getValue());
                        }
                    }
                    throw res.thrown;
                }
                ErrorResponse resp = evals.evaluate(res.thrown, this, Page.get(), evt);
                if (resp != null && resp.status() != HttpResponseStatus.INTERNAL_SERVER_ERROR) {
                    this.reply(resp.status(), resp.message());
                    return;
                }
                this.reply(Err.of(res.thrown));
            } else {
                this.next(new Object[0]);
            }
        }
    }

    static final class IWrapper<T extends ChannelFutureListener>
    implements ChannelFutureListener,
    Callable<Void> {
        private final Callable<Void> delegate;
        private final Class<T> listenerType;
        private final Injector injector;
        private final Page page;
        private ChannelFuture future;

        IWrapper(Class<T> listenerType, Page page) {
            assert (page != null) : "Called outside request scope";
            this.page = page;
            this.listenerType = (Class)Checks.notNull((String)"listenerType", listenerType);
            Application app = page.getApplication();
            this.delegate = app.getRequestScope().wrap((Callable)this);
            this.injector = app.getDependencies().getInjector();
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            try (QuietAutoClosable cl = Page.set(this.page);){
                this.future = future;
                this.delegate.call();
            }
        }

        @Override
        public Void call() throws Exception {
            ChannelFutureListener listener = (ChannelFutureListener)this.injector.getInstance(this.listenerType);
            listener.operationComplete((Future)this.future);
            return null;
        }

        public String toString() {
            return "InstantiatingWrapper-" + this.listenerType.getName();
        }
    }

    static class ScopeWrapper
    implements ChannelFutureListener,
    Callable<Void> {
        private ChannelFuture future;
        private final Callable<Void> wrapper;
        private final ChannelFutureListener listener;
        private final Page page;

        ScopeWrapper(Application app, ChannelFutureListener listener, Page page) {
            this.listener = listener;
            this.page = page;
            this.wrapper = app.getRequestScope().wrap((Callable)this);
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            this.future = future;
            try (QuietAutoClosable cl = Page.set(this.page);){
                this.wrapper.call();
            }
        }

        @Override
        public Void call() throws Exception {
            this.listener.operationComplete((Future)this.future);
            return null;
        }

        public String toString() {
            return "ScopeWrapper-" + this.listener;
        }
    }

    static class WrapperActeur
    extends Acteur
    implements Delegate {
        private final Dependencies deps;
        private final Charset charset;
        private final Class<? extends Acteur> type;
        Acteur acteur;
        boolean inOnError;
        private State cachedState;

        WrapperActeur(Dependencies deps, Charset charset, Class<? extends Acteur> type) {
            this.deps = deps;
            this.charset = charset;
            this.type = type;
        }

        public Class<? extends Acteur> type() {
            return this.type;
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            try {
                this.delegate().describeYourself(into);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void onError(Throwable t) throws UnsupportedEncodingException {
            if (this.inOnError) {
                Exceptions.chuck((Throwable)t);
            }
            this.inOnError = true;
            try {
                if (!Dependencies.isProductionMode((Settings)((Settings)this.deps.getInstance(Settings.class)))) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    t.printStackTrace(new PrintStream(out));
                    if (this.charset == null || CharsetUtil.UTF_8.equals(this.charset)) {
                        this.add(Headers.CONTENT_TYPE, MimeType.PLAIN_TEXT_UTF_8);
                    } else {
                        this.add(Headers.CONTENT_TYPE, MimeType.PLAIN_TEXT_UTF_8.withCharset(this.charset));
                    }
                    this.setMessage(new String(out.toByteArray(), this.charset));
                }
                this.setResponseCode(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            finally {
                this.inOnError = false;
            }
        }

        Acteur delegate() {
            if (this.acteur == null) {
                try {
                    this.acteur = (Acteur)((Object)this.deps.getInstance(this.type));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        ((Application)this.deps.getInstance(Application.class)).internalOnError(e);
                        this.onError(e);
                    }
                    catch (UnsupportedEncodingException ex) {
                        Exceptions.chuck((Throwable)ex);
                    }
                }
            }
            return this.acteur;
        }

        @Override
        public State getState() {
            return this.cachedState == null ? (this.cachedState = this.delegate().getState()) : this.cachedState;
        }

        public String toString() {
            return "Wrapper [" + (this.acteur == null ? this.type + " (type)" : this.acteur) + " lastState=" + (Object)((Object)this.cachedState) + "]";
        }

        @Override
        public Acteur getDelegate() {
            return this.delegate();
        }
    }

    class BaseState
    extends State {
        protected final Page page;

        BaseState(Object ... context) {
            super(context);
            this.page = Page.get();
            if (this.page == null) {
                throw new IllegalStateException("Page not set");
            }
        }

        BaseState(boolean rejected) {
            super(rejected);
            this.page = Page.get();
            if (this.page == null) {
                throw new IllegalStateException("Page not set");
            }
        }

        @Override
        public final Acteur getActeur() {
            return Acteur.this;
        }
    }
}

