/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.CheckIfModifiedSinceHeader;
import com.mastfrog.acteur.CheckIfNoneMatchHeader;
import com.mastfrog.acteur.CheckIfUnmodifiedSinceHeader;
import com.mastfrog.acteur.ContentConverter;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.PathPatterns;
import com.mastfrog.acteur.State;
import com.mastfrog.acteur.errors.Err;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.preconditions.Description;
import com.mastfrog.acteur.server.PathFactory;
import com.mastfrog.acteur.util.HttpMethod;
import com.mastfrog.acteurbase.Chain;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.mime.MimeType;
import com.mastfrog.url.Path;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.netbeans.validation.api.InvalidInputException;
import org.netbeans.validation.api.Problem;

@Singleton
public class ActeurFactory {
    @Inject
    private Dependencies deps;
    @Inject
    private Charset charset;
    @Inject
    private PathPatterns cache;
    @Inject
    private Provider<HttpEvent> event;

    @Inject
    public ActeurFactory() {
    }

    @Deprecated
    public Acteur matchMethods(Method ... methods) {
        return this.matchMethods(false, methods);
    }

    public Acteur matchMethods(boolean notSupp, Method ... methods) {
        if (methods.length == 1) {
            return new MatchMethod(this.event, notSupp, this.charset, methods[0]);
        }
        return new MatchMethods(this.event, notSupp, this.charset, methods);
    }

    public Acteur exactPathLength(final int length) {
        Checks.nonNegative((String)"length", (int)length);
        return new Acteur(){

            @Override
            public State getState() {
                HttpEvent event = (HttpEvent)ActeurFactory.this.event.get();
                if (event.path().getElements().length == length) {
                    return new Acteur.RejectedState();
                }
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }

            @Override
            public void describeYourself(Map<String, Object> into) {
                into.put("Path-element-count", length);
            }
        };
    }

    public Acteur minimumPathLength(final int length) {
        Checks.nonZero((String)"length", (int)length);
        Checks.nonNegative((String)"length", (int)length);
        return new Acteur(){

            @Override
            public State getState() {
                HttpEvent event = (HttpEvent)ActeurFactory.this.event.get();
                if (event.path().getElements().length < length) {
                    return new Acteur.RejectedState();
                }
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }

            @Override
            public void describeYourself(Map<String, Object> into) {
                into.put("Minimum Path Length", length);
            }
        };
    }

    public Acteur maximumPathLength(final int length) {
        Checks.nonZero((String)"length", (int)length);
        Checks.nonNegative((String)"length", (int)length);
        return new Acteur(){

            @Override
            public State getState() {
                HttpEvent event = (HttpEvent)ActeurFactory.this.event.get();
                if (event.path().getElements().length > length) {
                    return new Acteur.RejectedState();
                }
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }

            @Override
            public void describeYourself(Map<String, Object> into) {
                into.put("Maximum Path Length", length);
            }
        };
    }

    public Acteur redirect(String location) throws URISyntaxException {
        return this.redirect(location, HttpResponseStatus.SEE_OTHER);
    }

    public Acteur redirect(String location, HttpResponseStatus status) throws URISyntaxException {
        Checks.notNull((String)"location", (Object)location);
        Checks.notNull((String)"status", (Object)status);
        switch (status.code()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 305: 
            case 307: {
                break;
            }
            default: {
                throw new IllegalArgumentException(status + " is not a redirect");
            }
        }
        return new Redirect(location, status);
    }

    public <T> Acteur injectRequestBodyAsJSON(Class<T> type) {
        return new InjectBody<T>(this.deps, type);
    }

    private static String stackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        t.printStackTrace(ps);
        return new String(baos.toByteArray());
    }

    public <T> Acteur injectRequestParametersAs(Class<T> type) {
        return new InjectParams<T>(this.deps, type);
    }

    public Acteur responseCode(final HttpResponseStatus status) {
        @Description(value="Send a response code")
        class SendResponseCode
        extends Acteur {
            SendResponseCode() {
            }

            @Override
            public State getState() {
                return (Acteur)this.new Acteur.RespondWith(status);
            }

            @Override
            public void describeYourself(Map<String, Object> into) {
                into.put("Responds With", status);
            }
        }
        return new SendResponseCode();
    }

    public Acteur requireParameters(String ... names) {
        return new RequireParameters(this.event, this.charset, names);
    }

    public Acteur parametersMayNotBeCombined(final String ... names) {
        @Description(value="Requires that parameters not appear together in the URL")
        class RequireParametersNotBeCombined
        extends Acteur {
            RequireParametersNotBeCombined() {
            }

            @Override
            public State getState() {
                HttpEvent event = (HttpEvent)ActeurFactory.this.event.get();
                String first = null;
                for (String nm : names) {
                    String val = event.urlParameter(nm);
                    if (val == null) continue;
                    if (first == null) {
                        first = nm;
                        continue;
                    }
                    this.add(Headers.CONTENT_TYPE, MimeType.PLAIN_TEXT_UTF_8.withCharset(ActeurFactory.this.charset));
                    return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Parameters may not contain both '" + first + "' and '" + nm + "'\n"));
                }
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }

            public String toString() {
                return "Parameters may not be combined: " + Strings.toString(Arrays.asList(names));
            }

            @Override
            public void describeYourself(Map<String, Object> into) {
                into.put("requiredParameters", names);
            }
        }
        return new RequireParametersNotBeCombined();
    }

    public Acteur parametersMustBeNumbersIfTheyArePresent(final boolean allowDecimal, final boolean allowNegative, final String ... names) {
        @Description(value="Requires that parameters be numbers if they are present")
        class NumberParameters
        extends Acteur {
            NumberParameters() {
            }

            @Override
            public void describeYourself(Map<String, Object> into) {
                String qualifier;
                String string = qualifier = allowDecimal ? "decimal or integral numbers" : "integral numbers";
                if (!allowDecimal) {
                    qualifier = "positive " + qualifier;
                }
                into.put("These URL parameters must be " + qualifier + " if present", names);
            }

            public String toString() {
                return "Query Param Number Constraints";
            }

            @Override
            public State getState() {
                HttpEvent evt = (HttpEvent)ActeurFactory.this.event.get();
                for (String name : names) {
                    String p = evt.urlParameter(name);
                    if (p == null) continue;
                    boolean decimalSeen = false;
                    block6: for (int i = 0; i < p.length(); ++i) {
                        switch (p.charAt(i)) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                continue block6;
                            }
                            case '-': {
                                if (i == 0 && allowNegative) continue block6;
                            }
                            case '.': {
                                if (!decimalSeen && allowDecimal) {
                                    decimalSeen = true;
                                    continue block6;
                                }
                            }
                            default: {
                                return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Parameter " + name + " is not a legal number here: '" + p + "'\n"));
                            }
                        }
                    }
                }
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }
        }
        return new NumberParameters();
    }

    public Acteur banParameters(final String ... names) {
        Arrays.sort(names);
        @Description(value="Requires that parameters not be present")
        class BanParameters
        extends Acteur {
            BanParameters() {
            }

            @Override
            public State getState() {
                HttpEvent evt = (HttpEvent)ActeurFactory.this.event.get();
                for (Map.Entry<String, String> e : evt.urlParametersAsMap().entrySet()) {
                    if (Arrays.binarySearch(names, e.getKey()) < 0) continue;
                    return (Acteur)this.new Acteur.RespondWith(Err.badRequest(e.getKey() + " not allowed in parameters\n"));
                }
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }

            @Override
            public void describeYourself(Map<String, Object> into) {
                into.put("Illegal Parameters", names);
            }
        }
        return new BanParameters();
    }

    public Acteur requireAtLeastOneParameter(final String ... names) {
        @Description(value="Requires that at least one specified parameter be present")
        class RequireAtLeastOneParameter
        extends Acteur {
            RequireAtLeastOneParameter() {
            }

            @Override
            public State getState() {
                HttpEvent event = (HttpEvent)ActeurFactory.this.event.get();
                for (String nm : names) {
                    String val = event.urlParameter(nm);
                    if (val == null) continue;
                    return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < names.length; ++i) {
                    sb.append("'").append(names[i]).append("'");
                    if (i == names.length - 1) continue;
                    sb.append(", ");
                }
                return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Must have at least one of " + sb + " as parameters\n"));
            }

            @Override
            public void describeYourself(Map<String, Object> into) {
                into.put("At least one parameter required", names);
            }

            public String toString() {
                return "Require Parameters " + Arrays.asList(names);
            }
        }
        return new RequireAtLeastOneParameter();
    }

    @Deprecated
    public Acteur matchPath(String ... regexen) {
        return this.matchPath(false, regexen);
    }

    @Deprecated
    public Acteur matchPath(boolean decode, String ... regexen) {
        String exactPath;
        if (regexen.length == 1 && (exactPath = this.cache.exactPathForRegex(regexen[0])) != null) {
            return new ExactMatchPath(this.event, exactPath, decode);
        }
        return new MatchPath(this.event, this.cache, decode, regexen);
    }

    public Acteur sendNotModifiedIfETagHeaderMatches() {
        return Acteur.wrap(CheckIfNoneMatchHeader.class, this.deps);
    }

    public Class<? extends Acteur> sendNotModifiedIfETagHeaderMatchesType() {
        return CheckIfNoneMatchHeader.class;
    }

    public Acteur globPathMatch(String ... patterns) {
        return this.globPathMatch(false, patterns);
    }

    public Acteur globPathMatch(boolean decode, String ... patterns) {
        if (patterns.length == 1 && this.cache.isExactGlob(patterns[0])) {
            String pattern = patterns[0];
            if (pattern.length() > 0 && pattern.charAt(0) == '/') {
                pattern = pattern.substring(1);
            }
            return new ExactMatchPath(this.event, patterns[0], decode);
        }
        String[] rexen = new String[patterns.length];
        for (int i = 0; i < rexen.length; ++i) {
            rexen[i] = PathPatterns.patternFromGlob(patterns[i]);
        }
        return this.matchPath(decode, rexen);
    }

    public Acteur sendNotModifiedIfIfModifiedSinceHeaderMatches() {
        return Acteur.wrap(CheckIfModifiedSinceHeader.class, this.deps);
    }

    public Class<? extends Acteur> sendNotModifiedIfIfModifiedSinceHeaderMatchesType() {
        return CheckIfModifiedSinceHeader.class;
    }

    public Acteur preconditionFailedIfUnmodifiedSinceMatches() {
        return Acteur.wrap(CheckIfUnmodifiedSinceHeader.class, this.deps);
    }

    public Class<? extends Acteur> preconditionFailedIfUnmodifiedSinceMatchesType() {
        return CheckIfUnmodifiedSinceHeader.class;
    }

    public Acteur respondWith(int status) {
        return new ResponseCode(status);
    }

    public Acteur respondWith(int status, String msg) {
        return new ResponseCode(status, msg);
    }

    public Acteur respondWith(HttpResponseStatus status, String msg) {
        return new ResponseCode(status, msg);
    }

    public Acteur respondWith(HttpResponseStatus status) {
        return new ResponseCode(status);
    }

    public Acteur minimumBodyLength(final int length) {
        return new Acteur(){

            @Override
            public State getState() {
                try {
                    int val = ((HttpEvent)ActeurFactory.this.event.get()).content().readableBytes();
                    if (val < length) {
                        return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Request body must be > " + length + " characters"));
                    }
                    return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
                }
                catch (IOException ex) {
                    return (State)((Object)Exceptions.chuck((Throwable)ex));
                }
            }
        };
    }

    public Acteur maximumBodyLength(final int length) {
        return new Acteur(){

            @Override
            public State getState() {
                try {
                    int val = ((HttpEvent)ActeurFactory.this.event.get()).content().readableBytes();
                    if (val > length) {
                        return (Acteur)this.new Acteur.RespondWith(new Err(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, "Request body must be < " + length + " characters"));
                    }
                    return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
                }
                catch (IOException ex) {
                    return (State)((Object)Exceptions.chuck((Throwable)ex));
                }
            }
        };
    }

    public Acteur requireParametersIfMethodMatches(final Method method, final String ... params) {
        Checks.notNull((String)"method", (Object)method);
        Checks.notNull((String)"params", (Object)params);
        Checks.notEmpty((String)"params", Arrays.asList(params));
        class RequireParametersIfMethodMatches
        extends Acteur {
            RequireParametersIfMethodMatches() {
            }

            @Override
            public State getState() {
                HttpEvent evt = (HttpEvent)ActeurFactory.this.event.get();
                if (method.equals((Object)evt.method()) && !evt.urlParametersAsMap().keySet().containsAll(Arrays.asList(params))) {
                    return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Required parameters: " + Arrays.asList(params)));
                }
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }
        }
        return new RequireParametersIfMethodMatches();
    }

    public Acteur redirectEmptyPath(String to) throws URISyntaxException {
        return this.redirectEmptyPath(Path.parse((String)to));
    }

    public Acteur redirectEmptyPath(final Path to) throws URISyntaxException {
        Checks.notNull((String)"to", (Object)to);
        class MatchNothing
        extends Acteur {
            MatchNothing() {
            }

            @Override
            public State getState() {
                HttpEvent evt = (HttpEvent)ActeurFactory.this.event.get();
                if (evt.path().toString().isEmpty()) {
                    PathFactory pf = (PathFactory)ActeurFactory.this.deps.getInstance(PathFactory.class);
                    this.add(Headers.LOCATION, pf.toExternalPath(to).toURI());
                    return (Acteur)this.new Acteur.RespondWith(HttpResponseStatus.SEE_OTHER);
                }
                return new Acteur.RejectedState();
            }
        }
        return new MatchNothing();
    }

    public Acteur branch(final Class<? extends Acteur> ifTrue, final Class<? extends Acteur> ifFalse, final Test test) {
        class Brancher
        extends Acteur {
            Brancher() {
            }

            @Override
            public State getState() {
                boolean result = test.test((HttpEvent)ActeurFactory.this.event.get());
                Chain chain = (Chain)ActeurFactory.this.deps.getInstance(Chain.class);
                if (result) {
                    chain.add(ifTrue);
                } else {
                    chain.add(ifFalse);
                }
                return (Acteur)this.new Acteur.ConsumedLockedState(new Object[0]);
            }
        }
        return new Brancher();
    }

    private static class MatchMethod
    extends Acteur {
        private final Provider<HttpEvent> deps;
        private final boolean notSupp;
        private final Charset charset;
        private final Method[] method;

        MatchMethod(Provider<HttpEvent> deps, boolean notSupp, Charset charset, Method ... method) {
            this.deps = deps;
            this.notSupp = notSupp;
            this.charset = charset;
            this.method = method;
        }

        @Override
        public State getState() {
            HttpEvent event = (HttpEvent)this.deps.get();
            HttpMethod mth = event.method();
            boolean hasMethod = mth == this.method[0] || this.method[0].equals((Object)event.method());
            this.add(Headers.ALLOW, this.method);
            if (this.notSupp && !hasMethod) {
                this.add(Headers.CONTENT_TYPE, MimeType.PLAIN_TEXT_UTF_8.withCharset(this.charset));
                return (Acteur)this.new Acteur.RespondWith(new Err(HttpResponseStatus.METHOD_NOT_ALLOWED, "405 Method " + event.method() + " not allowed.  Accepted methods are " + Headers.ALLOW.toCharSequence((Object)this.method) + "\n"));
            }
            Acteur.BaseState result = hasMethod ? (Acteur)this.new Acteur.ConsumedState(new Object[0]) : new Acteur.RejectedState();
            return result;
        }

        public String toString() {
            return "Match Method";
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("Method", this.method);
        }
    }

    static class MatchMethods
    extends Acteur {
        private final Provider<HttpEvent> deps;
        private final boolean notSupp;
        private final Charset charset;
        private final Method[] methods;

        MatchMethods(Provider<HttpEvent> deps, boolean notSupp, Charset charset, Method ... methods) {
            this.deps = deps;
            this.notSupp = notSupp;
            this.charset = charset;
            this.methods = methods;
        }

        Method[] methods() {
            return this.methods;
        }

        private boolean hasMethod(HttpMethod m) {
            for (Method mm : this.methods) {
                if (mm != m && !mm.equals((Object)m)) continue;
                return true;
            }
            return false;
        }

        @Override
        public State getState() {
            HttpEvent event = (HttpEvent)this.deps.get();
            boolean hasMethod = this.hasMethod(event.method());
            this.add(Headers.ALLOW, this.methods);
            if (this.notSupp && !hasMethod) {
                this.add(Headers.CONTENT_TYPE, MimeType.PLAIN_TEXT_UTF_8.withCharset(this.charset));
                return (Acteur)this.new Acteur.RespondWith(new Err(HttpResponseStatus.METHOD_NOT_ALLOWED, "405 Method " + event.method() + " not allowed.  Accepted methods are " + Headers.ALLOW.toCharSequence((Object)this.methods) + "\n"));
            }
            Acteur.BaseState result = hasMethod ? (Acteur)this.new Acteur.ConsumedState(new Object[0]) : new Acteur.RejectedState();
            return result;
        }

        public String toString() {
            return "Match Methods";
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("Methods", this.methods);
        }
    }

    private static final class Redirect
    extends Acteur {
        private final URI location;
        private final HttpResponseStatus status;

        private Redirect(String location, HttpResponseStatus status) throws URISyntaxException {
            this.location = new URI(location);
            this.status = status;
        }

        @Override
        public State getState() {
            this.add(Headers.LOCATION, this.location);
            return (Acteur)this.new Acteur.RespondWith(this.status, (Object)("Redirecting to " + this.location));
        }
    }

    @Description(value="Injects the body as a specific type")
    private static final class InjectBody<T>
    extends Acteur {
        private final Dependencies deps;
        private final Class<T> type;

        InjectBody(Dependencies deps, Class<T> type) {
            this.deps = deps;
            this.type = type;
        }

        public String toString() {
            return "Deserialize and inject the request body as a " + this.type.getSimpleName();
        }

        @Override
        public State getState() {
            ContentConverter converter = (ContentConverter)this.deps.getInstance(ContentConverter.class);
            Event event = (Event)this.deps.getInstance(Event.class);
            if (event.request() instanceof WebSocketFrame) {
                WebSocketFrame frame = (WebSocketFrame)event.request();
                try {
                    T obj = converter.readObject(frame.content(), MimeType.JSON_UTF_8, this.type);
                    return (Acteur)this.new Acteur.ConsumedLockedState(obj);
                }
                catch (IOException | InvalidInputException ex) {
                    CharSequence seq = "";
                    frame.content().resetReaderIndex();
                    if (frame.content().readableBytes() > 0) {
                        seq = frame.content().readCharSequence(frame.content().readableBytes(), CharsetUtil.UTF_8);
                    }
                    return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Bad or no JSON in '" + seq + "'"));
                }
                catch (Exception e) {
                    return (State)((Object)Exceptions.chuck((Throwable)e));
                }
            }
            HttpEvent evt = (HttpEvent)this.deps.getInstance(HttpEvent.class);
            MimeType mt = (MimeType)evt.header(Headers.CONTENT_TYPE);
            if (mt == null) {
                mt = MimeType.ANY_TYPE;
            }
            try {
                T obj = converter.readObject(evt.content(), mt, this.type);
                return (Acteur)this.new Acteur.ConsumedLockedState(obj);
            }
            catch (InvalidInputException e) {
                LinkedList<String> pblms = new LinkedList<String>();
                for (Problem p : e.getProblems()) {
                    pblms.add(p.getMessage());
                }
                return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Invalid data").put("problems", pblms));
            }
            catch (IOException ex) {
                return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Bad or no JSON\n" + ActeurFactory.stackTrace(ex)));
            }
            catch (Exception ex) {
                return (State)((Object)Exceptions.chuck((Throwable)ex));
            }
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("Expects JSON Request Body", this.toString());
        }
    }

    @Description(value="Inject request parameters as a type")
    static class InjectParams<T>
    extends Acteur {
        private final Dependencies deps;
        private final Class<T> type;

        InjectParams(Dependencies deps, Class<T> type) {
            this.deps = deps;
            this.type = type;
        }

        @Override
        public State getState() {
            HttpEvent evt = (HttpEvent)this.deps.getInstance(HttpEvent.class);
            ContentConverter converter = (ContentConverter)this.deps.getInstance(ContentConverter.class);
            try {
                T obj = converter.createObjectFor(evt.urlParametersAsMap(), this.type);
                if (obj != null) {
                    return (Acteur)this.new Acteur.ConsumedLockedState(obj);
                }
            }
            catch (InvalidInputException ex) {
                this.setState((Acteur)this.new Acteur.RespondWith(Err.badRequest(ex.getProblems().toString())));
            }
            return new Acteur.RejectedState();
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("type", this.type.getName());
        }

        public String toString() {
            return "Inject request parameters as " + this.type.getName();
        }
    }

    static class RequireParameters
    extends Acteur {
        private final Provider<HttpEvent> deps;
        private final Charset charset;
        private final String[] names;

        RequireParameters(Provider<HttpEvent> deps, Charset charset, String ... names) {
            this.deps = deps;
            this.charset = charset;
            this.names = names;
        }

        @Override
        public State getState() {
            HttpEvent event = (HttpEvent)this.deps.get();
            for (String nm : this.names) {
                String val = event.urlParameter(nm);
                if (val != null) continue;
                this.add(Headers.CONTENT_TYPE, MimeType.PLAIN_TEXT_UTF_8.withCharset(this.charset));
                return (Acteur)this.new Acteur.RespondWith(Err.badRequest("Missing URL parameter '" + nm + "'\n"));
            }
            return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
        }

        public String toString() {
            return "Require Parameters " + Arrays.asList(this.names);
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("requiredParameters", this.names);
        }
    }

    static class ExactMatchPath
    extends Acteur {
        final String path;
        private final Provider<HttpEvent> deps;
        final boolean decode;

        ExactMatchPath(Provider<HttpEvent> deps, String path, boolean decode) {
            this.path = path.length() > 1 && path.charAt(0) == '/' ? path.substring(1) : path;
            this.deps = deps;
            this.decode = decode;
        }

        @Override
        public State getState() {
            HttpEvent event = (HttpEvent)this.deps.get();
            String pth = event.path().toString();
            if (this.decode) {
                pth = Strings.urlDecode((String)pth);
            }
            if (this.path.equals(pth)) {
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }
            return new Acteur.RejectedState();
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("Match Path (exact)", this.path);
        }

        public String toString() {
            return "Match Path (exact)";
        }
    }

    static final class MatchPath
    extends Acteur {
        private final Provider<HttpEvent> deps;
        private final PathPatterns cache;
        final boolean decode;
        final String[] regexen;

        MatchPath(Provider<HttpEvent> deps, PathPatterns cache, boolean decode, String ... regexen) {
            if (regexen.length == 0) {
                throw new IllegalArgumentException("No regular expressions provided");
            }
            this.deps = deps;
            this.cache = cache;
            this.decode = decode;
            this.regexen = regexen;
        }

        @Override
        public State getState() {
            HttpEvent event = (HttpEvent)this.deps.get();
            String pth = event.path().toString();
            if (this.decode) {
                pth = Strings.urlDecode((String)pth);
            }
            for (String regex : this.regexen) {
                Pattern p = this.cache.getPattern(regex);
                boolean matches = p.matcher(pth).matches();
                if (!matches) continue;
                return (Acteur)this.new Acteur.ConsumedState(new Object[0]);
            }
            return new Acteur.RejectedState();
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("URL Patterns", this.regexen);
        }

        public String toString() {
            return "Match Path (regex)";
        }
    }

    private static final class ResponseCode
    extends Acteur {
        private final HttpResponseStatus code;
        private final String msg;

        ResponseCode(int code) {
            this(code, null);
        }

        ResponseCode(int code, String msg) {
            this(HttpResponseStatus.valueOf((int)code), msg);
        }

        ResponseCode(HttpResponseStatus code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        ResponseCode(HttpResponseStatus code) {
            this(code, null);
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("Always responds with", this.code.code() + " " + this.code.reasonPhrase());
        }

        @Override
        public State getState() {
            return this.msg == null ? (Acteur)this.new Acteur.RespondWith(this.code) : (Acteur)this.new Acteur.RespondWith(this.code, (Object)this.msg);
        }
    }

    public static interface Test {
        public boolean test(HttpEvent var1);
    }
}

