/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.name.Named;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.CORSResource;
import com.mastfrog.acteur.CORSResponseDecorator;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.FailureResponseFactory;
import com.mastfrog.acteur.Help;
import com.mastfrog.acteur.HelpGenerator;
import com.mastfrog.acteur.HelpPage;
import com.mastfrog.acteur.HttpCallOrOrderedComparator;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.OnBeforeEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.PagePathAndMethodFilter;
import com.mastfrog.acteur.PagesImpl2;
import com.mastfrog.acteur.PathFilters;
import com.mastfrog.acteur.RequestLogger;
import com.mastfrog.acteur.Response;
import com.mastfrog.acteur.ResponseDecorator;
import com.mastfrog.acteur.ResponseWriter;
import com.mastfrog.acteur.State;
import com.mastfrog.acteur.annotations.Early;
import com.mastfrog.acteur.debug.Probe;
import com.mastfrog.acteur.header.entities.CacheControl;
import com.mastfrog.acteur.header.entities.CacheControlTypes;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.server.ServerModule;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.acteur.util.ErrorHandlers;
import com.mastfrog.acteur.util.ErrorInterceptor;
import com.mastfrog.acteur.util.RequestID;
import com.mastfrog.acteurbase.InstantiatingIterators;
import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.giulius.scope.ReentrantScope;
import com.mastfrog.mime.MimeType;
import com.mastfrog.settings.Settings;
import com.mastfrog.settings.SettingsBuilder;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.ConfigurationError;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class Application
implements Iterable<Page> {
    private static final Set<String> checkedTypes = Collections.synchronizedSet(new HashSet());
    private final List<Object> pages = new ArrayList<Object>();
    @Inject
    private Dependencies deps;
    @Inject
    private RequestLogger logger;
    @Inject
    private ReentrantScope scope;
    private final Exception stackTrace = new Exception();
    @Inject
    private PagesImpl2 runner;
    @Inject(optional=true)
    private ErrorInterceptor errorHandler;
    @Inject
    private ErrorHandlers errorHandlers;
    @Inject
    Charset charset;
    @Inject
    CORSResponseDecorator corsDecorator;
    @Inject(optional=true)
    private ResponseDecorator responseDecorator;
    @Inject(optional=true)
    @Named(value="application.name")
    String name;
    private boolean debug = Boolean.getBoolean("acteur.debug");
    @Inject(optional=true)
    @Named(value="default.context.objects")
    private Object[] defaultContextObjects;
    @Inject
    Probe probe;
    @Inject(optional=true)
    OnBeforeEvent onBeforeEvent;
    @Inject
    private InstantiatingIterators iterators;
    private boolean checkedEarlyHelp;
    private List<Object> earlyPages = new ArrayList<Object>(10);
    private final PathFilters filters = PathFilters.create(this::dependenciesUnsafe);
    private final RequestID.Factory ids = new RequestID.Factory();
    final ChannelFutureListener errorLoggingListener = future -> {
        if (!future.isSuccess() && future.cause() != null) {
            this.internalOnError(future.cause());
        }
    };
    private boolean corsEnabled;
    private final ApplicationControl control = new ApplicationControl(){

        @Override
        public void enableDefaultCorsHandling() {
            Application.this.enableDefaultCorsHandling();
        }

        @Override
        public CountDownLatch onEvent(Event<?> event, Channel channel) {
            return Application.this.onEvent(event, channel);
        }

        @Override
        public void internalOnError(Throwable err) {
            if (err != null) {
                Application.this.internalOnError(err);
            }
        }

        @Override
        public ChannelFuture logFailure(ChannelFuture future) {
            ((ChannelFuture)Checks.notNull((String)"future", (Object)future)).addListener((GenericFutureListener)Application.this.errorLoggingListener);
            return future;
        }
    };
    @Inject
    private HelpGenerator helpGenerator;
    private static final HeaderValueType<CharSequence> X_REQ_PATH = Headers.header((CharSequence)new AsciiString((CharSequence)"X-Req-Path"));
    private static final HeaderValueType<CharSequence> X_ACTEUR = Headers.header((CharSequence)new AsciiString((CharSequence)"X-Acteur"));
    private static final HeaderValueType<CharSequence> X_PAGE = Headers.header((CharSequence)new AsciiString((CharSequence)"X-Page"));
    private static final HeaderValueType<CharSequence> X_REQ_ID = Headers.header((CharSequence)new AsciiString((CharSequence)"X-Req-ID"));
    @Inject(optional=true)
    FailureResponseFactory failureResponses;

    protected Application(Class<?> ... types) {
        this();
        for (Class<?> type : types) {
            this.add(type);
        }
    }

    protected Application() {
        Help help = this.getClass().getAnnotation(Help.class);
        if (help != null) {
            this.add(Application.helpPageType());
        }
    }

    public boolean hasEarlyPages() {
        return !this.earlyPages.isEmpty();
    }

    public boolean isEarlyPageMatch(HttpRequest req) {
        boolean result = this.filters.isEarlyPageMatch(req);
        return result;
    }

    List<Object> rawPages() {
        return this.pages;
    }

    public static Class<? extends Page> helpPageType() {
        return HelpPage.class;
    }

    public final boolean isDefaultCorsHandlingEnabled() {
        return this.corsEnabled;
    }

    protected final void enableDefaultCorsHandling() {
        if (!this.corsEnabled) {
            this.corsEnabled = true;
            if (!this.earlyPages.isEmpty()) {
                this.earlyPages.add(CORSResource.class);
            }
            this.pages.add(0, CORSResource.class);
            this.filters.addNormalPage(CORSResource.class);
        }
    }

    ApplicationControl control() {
        return this.control;
    }

    public static Application create(Class<?> ... types) {
        return new Application(types);
    }

    public ReentrantScope getRequestScope() {
        return this.scope;
    }

    Map<String, Object> describeYourself() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        ArrayList<Object> allPagesAndPageTypes = new ArrayList<Object>(this.earlyPages);
        allPagesAndPageTypes.addAll(this.pages);
        this.helpGenerator.generate(this, allPagesAndPageTypes, m);
        return m;
    }

    protected final void add(Class<? extends Page> page) {
        if ((page.getModifiers() & 0x400) != 0) {
            throw new ConfigurationError(page + " is abstract");
        }
        if (page.isLocalClass()) {
            throw new ConfigurationError(page + " is not a top-level class");
        }
        if (!Page.class.isAssignableFrom(page)) {
            throw new ConfigurationError(page + " is not a subclass of " + Page.class.getName());
        }
        assert (Application.checkConstructor(page));
        if (page.getAnnotation(Early.class) != null) {
            this.filters.addEarlyPage(page);
            this.earlyPages.add(page);
        } else {
            this.filters.addNormalPage(page);
            this.pages.add(page);
        }
    }

    protected final void add(Page page) {
        if (page.getClass().getAnnotation(Early.class) != null) {
            this.filters.addEarlyPage(page);
            this.earlyPages.add(page);
        } else {
            this.filters.addNormalPage(page);
            this.pages.add(page);
        }
    }

    static boolean checkConstructor(Class<?> type) {
        Checks.notNull((String)"type", type);
        if (checkedTypes.contains(type.getName())) {
            return true;
        }
        boolean found = true;
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            Inject inj;
            if (c.getParameterTypes() == null || c.getParameterTypes().length == 0) {
                found = true;
            }
            if ((inj = c.getAnnotation(Inject.class)) == null) continue;
            found = true;
        }
        if (!found) {
            throw new ConfigurationError(type + " does not have an injectable constructor");
        }
        checkedTypes.add(type.getName());
        return true;
    }

    public String getName() {
        return this.name == null ? this.getClass().getSimpleName() : this.name;
    }

    @Deprecated
    protected HttpResponse decorateResponse(Event<?> event, Page page, Acteur action, HttpResponse response) {
        return response;
    }

    HttpResponse _decorateResponse(RequestID id, Event<?> event, Page page, Acteur action, HttpResponse response) {
        Headers.write((HeaderValueType)Headers.SERVER, (Object)this.getName(), (HttpMessage)response);
        Headers.write((HeaderValueType)Headers.DATE, (Object)ZonedDateTime.now(), (HttpMessage)response);
        if (this.debug) {
            String pth;
            String string = pth = event instanceof HttpEvent ? ((HttpEvent)event).path().toString() : "-";
            if (pth.isEmpty()) {
                pth = "/";
            }
            Headers.write(X_REQ_PATH, (Object)pth, (HttpMessage)response);
            Headers.write(X_ACTEUR, (Object)((Object)((Object)action)).getClass().getName(), (HttpMessage)response);
            Headers.write(X_PAGE, (Object)page.getClass().getName(), (HttpMessage)response);
        }
        Headers.write(X_REQ_ID, (Object)id.stringValue(), (HttpMessage)response);
        if (this.corsEnabled) {
            this.corsDecorator.decorateApplicationResponse(response, page);
        }
        return this.decorateResponse(event, page, action, response);
    }

    protected HttpResponse createNotFoundResponse(Event<?> event) {
        if (this.failureResponses != null) {
            return this.failureResponses.createNotFoundResponse(event);
        }
        String msg = "<html><head><title>Not Found</title></head><body><h1>Not Found</h1>" + event + " was not found\n<body></html>\n";
        ByteBuf buf = event.channel().alloc().ioBuffer(msg.length());
        buf.touch((Object)"application-create-not-found-response");
        buf.writeBytes(msg.getBytes(this.charset));
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, buf);
        Headers.write((HeaderValueType)Headers.CONTENT_TYPE, (Object)MimeType.HTML_UTF_8.withCharset(this.charset), (HttpMessage)resp);
        Headers.write((HeaderValueType)Headers.CONTENT_LENGTH, (Object)buf.writerIndex(), (HttpMessage)resp);
        Headers.write((HeaderValueType)Headers.CONTENT_LANGUAGE, (Object)Locale.ENGLISH, (HttpMessage)resp);
        Headers.write((HeaderValueType)Headers.CACHE_CONTROL, (Object)new CacheControl(new CacheControlTypes[]{CacheControlTypes.no_cache}), (HttpMessage)resp);
        Headers.write((HeaderValueType)Headers.DATE, (Object)ZonedDateTime.now(), (HttpMessage)resp);
        if (this.debug) {
            String pth = event instanceof HttpEvent ? ((HttpEvent)event).path().toString() : "";
            Headers.write(X_REQ_PATH, (Object)pth, (HttpMessage)resp);
        }
        return resp;
    }

    protected void onAfterRespond(RequestID id, Event<?> event, Acteur acteur, Page page, State state, HttpResponseStatus status, HttpResponse resp) {
    }

    protected void onBeforeRespond(RequestID id, Event<?> event, HttpResponseStatus status) {
        this.logger.onRespond(id, event, status);
    }

    protected void onBeforeEvent(RequestID id, Event<?> event) {
        this.logger.onBeforeEvent(id, event);
    }

    final void internalOnError(Throwable err) {
        Checks.notNull((String)"err", (Object)err);
        try {
            this.errorHandlers.onError(err);
        }
        finally {
            if (this.errorHandler != null) {
                this.errorHandler.onError(err);
            }
            this.onError(err);
        }
    }

    public void onError(Throwable err) {
    }

    private CountDownLatch onEvent(Event<?> event, Channel channel) {
        CountDownLatch countDownLatch;
        block11: {
            Object[] objectArray;
            assert (this.scope != null) : "Scope is null - Application members not injected?";
            RequestID id = this.ids.next();
            this.probe.onBeforeProcessRequest(id, event);
            if (this.onBeforeEvent == null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = event;
                objectArray = objectArray2;
                objectArray2[1] = id;
            } else {
                objectArray = this.onBeforeEvent.onBeforeEvent(event, channel, id);
            }
            Object[] scopeContents = objectArray;
            QuietAutoClosable cl = this.scope.enter(scopeContents);
            try {
                this.onBeforeEvent(id, event);
                countDownLatch = this.runner.onEvent(id, event, channel, this.defaultContextObjects);
                if (cl == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (cl != null) {
                        try {
                            cl.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.internalOnError(e);
                    CountDownLatch latch = new CountDownLatch(1);
                    latch.countDown();
                    return latch;
                }
            }
            cl.close();
        }
        return countDownLatch;
    }

    Dependencies dependenciesUnsafe() {
        return this.deps;
    }

    Dependencies getDependencies() {
        if (this.deps == null) {
            try {
                new IllegalArgumentException("Initializing dependencies backwards.  This instance was not created by Guice? " + this, this.stackTrace).printStackTrace();
                this.deps = new Dependencies((Settings)SettingsBuilder.createDefault().buildMutableSettings(), new Module[]{new ServerModule(this.getClass())});
                this.deps.getInjector().getMembersInjector(Application.class).injectMembers((Object)this);
            }
            catch (IOException ex) {
                throw new ConfigurationError((Throwable)ex);
            }
        }
        return this.deps;
    }

    private List<Object> filter(PagePathAndMethodFilter filter, HttpEvent evt) {
        HttpRequest req = (HttpRequest)evt.request();
        ArrayList<Object> filtered = new ArrayList<Object>(filter.listFor(req));
        filtered.sort(HttpCallOrOrderedComparator.INSTANCE);
        return filtered;
    }

    Iterator<Page> iterator(HttpEvent evt) {
        List<Object> all = this.filter(this.filters.normalPages(), evt);
        return all.isEmpty() ? Collections.emptyIterator() : this.iterators.iterable(all, Page.class).iterator();
    }

    Iterator<Page> earlyPagesIterator(HttpEvent evt) {
        List<Object> all;
        if (!this.checkedEarlyHelp && ((Settings)this.deps.getInstance(Settings.class)).getBoolean("help.early", false)) {
            this.checkedEarlyHelp = true;
            this.earlyPages.add(HelpPage.class);
            this.filters.earlyPages().addHelp(((Settings)this.deps.getInstance(Settings.class)).getString("helpUrlPattern", "^help$"));
        }
        return (all = this.filter(this.filters.earlyPages(), evt)).isEmpty() ? Collections.emptyIterator() : this.iterators.iterable(all, Page.class).iterator();
    }

    @Override
    public Iterator<Page> iterator() {
        return this.iterators.iterable(this.pages, Page.class).iterator();
    }

    Iterator<Page> earlyPagesIterator() {
        if (!this.checkedEarlyHelp && ((Settings)this.deps.getInstance(Settings.class)).getBoolean("help.early", false)) {
            this.checkedEarlyHelp = true;
            this.earlyPages.add(HelpPage.class);
            this.filters.earlyPages().addHelp(((Settings)this.deps.getInstance(Settings.class)).getString("helpUrlPattern", "^help$"));
        }
        return this.iterators.iterable(this.earlyPages, Page.class).iterator();
    }

    protected void send404(RequestID id, Event<?> event, Channel channel) {
        boolean keepAlive;
        HttpResponse response = this.createNotFoundResponse(event);
        this.onBeforeRespond(id, event, response.status());
        if (this.responseDecorator != null) {
            try (QuietAutoClosable cl = Page.set(DummyNotFoundPage.INSTANCE);){
                this._onBeforeSendResponse(HttpResponseStatus.NOT_FOUND, event, new NotFoundResponseWrapper(response), DummyNotFoundActeur.INSTANCE, DummyNotFoundPage.INSTANCE);
            }
            catch (Throwable tt) {
                tt.printStackTrace();
            }
        }
        this.probe.onFallthrough(id, event);
        ChannelFuture fut = channel.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, response.headers()));
        fut = response instanceof FullHttpResponse ? channel.writeAndFlush((Object)new DefaultLastHttpContent(((FullHttpResponse)response).content())) : channel.writeAndFlush((Object)DefaultLastHttpContent.EMPTY_LAST_CONTENT);
        boolean bl = keepAlive = event instanceof HttpEvent ? ((HttpEvent)event).requestsConnectionStayOpen() : false;
        if (!keepAlive) {
            fut.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    void _onBeforeSendResponse(HttpResponseStatus status, Event<?> event, Response response, Acteur acteur, Page page) {
        try {
            if (this.responseDecorator != null) {
                this.responseDecorator.onBeforeSendResponse(this, status, event, response, acteur, page);
            }
            this.onBeforeSendResponse(status, event, response, acteur, page);
        }
        catch (Throwable e) {
            this.internalOnError(e);
        }
    }

    protected void onBeforeSendResponse(HttpResponseStatus status, Event<?> event, Response response, Acteur acteur, Page page) {
    }

    private static final class DummyNotFoundPage
    extends Page {
        private static final DummyNotFoundPage INSTANCE = new DummyNotFoundPage();

        DummyNotFoundPage() {
            this.add(DummyNotFoundActeur.class);
        }
    }

    private static final class NotFoundResponseWrapper
    extends Response {
        private final HttpResponse resp;

        public NotFoundResponseWrapper(HttpResponse resp) {
            this.resp = resp;
        }

        @Override
        public <T> Response add(HeaderValueType<T> headerType, T value) {
            this.resp.headers().add(headerType.name(), (Object)headerType.toCharSequence(value));
            return this;
        }

        @Override
        public Response content(Object message) {
            throw new UnsupportedOperationException("Decorator cannot set content on not found response.");
        }

        @Override
        public Response status(HttpResponseStatus status) {
            this.resp.setStatus(status);
            return this;
        }

        @Override
        public Response contentWriter(ChannelFutureListener listener) {
            throw new UnsupportedOperationException("Decorator cannot set content on not found response.");
        }

        @Override
        public Response contentWriter(ResponseWriter writer) {
            throw new UnsupportedOperationException("Decorator cannot set content on not found response.");
        }

        @Override
        public Response chunked(boolean chunked) {
            throw new UnsupportedOperationException("Decorator cannot set chunked on not found response.");
        }

        @Override
        public Response delayedBy(Duration delay) {
            throw new UnsupportedOperationException("Decorator cannot set delay on not found response.");
        }

        @Override
        protected <T> T get(HeaderValueType<T> header) {
            String s = this.resp.headers().get(header.name());
            if (s != null) {
                return (T)header.convert((CharSequence)s);
            }
            return null;
        }
    }

    private static final class DummyNotFoundActeur
    extends Acteur {
        private static final DummyNotFoundActeur INSTANCE = new DummyNotFoundActeur();

        DummyNotFoundActeur() {
            this.notFound();
        }
    }
}

