/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.ActeurFactory;
import com.mastfrog.acteur.CORSResource;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.auth.AuthenticationActeur;
import com.mastfrog.acteur.preconditions.Authenticated;
import com.mastfrog.acteur.preconditions.AuthenticatedIf;
import com.mastfrog.acteur.preconditions.BannedUrlParameters;
import com.mastfrog.acteur.preconditions.BasicAuth;
import com.mastfrog.acteur.preconditions.CORS;
import com.mastfrog.acteur.preconditions.InjectRequestBodyAs;
import com.mastfrog.acteur.preconditions.InjectUrlParametersAs;
import com.mastfrog.acteur.preconditions.MaximumPathLength;
import com.mastfrog.acteur.preconditions.MaximumRequestBodyLength;
import com.mastfrog.acteur.preconditions.Methods;
import com.mastfrog.acteur.preconditions.MinimumRequestBodyLength;
import com.mastfrog.acteur.preconditions.PageAnnotationHandler;
import com.mastfrog.acteur.preconditions.ParametersMustBeNumbersIfPresent;
import com.mastfrog.acteur.preconditions.Path;
import com.mastfrog.acteur.preconditions.PathRegex;
import com.mastfrog.acteur.preconditions.RequireAtLeastOneUrlParameterFrom;
import com.mastfrog.acteur.preconditions.RequireParametersIfMethodMatches;
import com.mastfrog.acteur.preconditions.RequiredUrlParameters;
import com.mastfrog.acteur.preconditions.UrlParametersMayNotBeCombined;
import com.mastfrog.acteur.preconditions.UrlParametersMayNotBeCombinedSets;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.giulius.Ordered;
import com.mastfrog.settings.Settings;
import java.util.List;
import javax.inject.Inject;

@Ordered(value=0)
public final class BuiltInPageAnnotationHandler
extends PageAnnotationHandler {
    private final Dependencies deps;
    private final ActeurFactory af;
    private final Settings settings;
    private static final Class<?>[] TYPES = new Class[]{Authenticated.class, AuthenticatedIf.class, Path.class, Methods.class, MaximumPathLength.class, BannedUrlParameters.class, RequireAtLeastOneUrlParameterFrom.class, RequiredUrlParameters.class, RequireParametersIfMethodMatches.class, ParametersMustBeNumbersIfPresent.class, MinimumRequestBodyLength.class, MaximumRequestBodyLength.class, UrlParametersMayNotBeCombined.class, UrlParametersMayNotBeCombinedSets.class, CORS.class, InjectUrlParametersAs.class, BasicAuth.class, InjectRequestBodyAs.class};

    @Inject
    BuiltInPageAnnotationHandler(PageAnnotationHandler.Registry registry, Dependencies deps, ActeurFactory af, Settings settings) {
        super(registry, TYPES);
        this.deps = deps;
        this.af = af;
        this.settings = settings;
    }

    @Override
    public <T extends Page> boolean processAnnotations(T page, List<? super Acteur> acteurs) {
        InjectRequestBodyAs as;
        CORS cors;
        InjectUrlParametersAs paramsIface;
        UrlParametersMayNotBeCombinedSets comboSet;
        UrlParametersMayNotBeCombined combos;
        MaximumRequestBodyLength maxLength;
        MinimumRequestBodyLength minLength;
        ParametersMustBeNumbersIfPresent nums;
        RequireParametersIfMethodMatches methodParams;
        RequiredUrlParameters params;
        RequireAtLeastOneUrlParameterFrom atLeastOneOf;
        BannedUrlParameters banned;
        MaximumPathLength len;
        Methods m;
        Path path;
        Class<?> c = page.getClass();
        PathRegex regex = c.getAnnotation(PathRegex.class);
        int oldSize = acteurs.size();
        if (regex != null) {
            acteurs.add(this.af.matchPath(regex.decode(), regex.value()));
        }
        if ((path = c.getAnnotation(Path.class)) != null) {
            acteurs.add(this.af.globPathMatch(path.value()));
        }
        if ((m = c.getAnnotation(Methods.class)) != null) {
            acteurs.add(this.af.matchMethods(m.value()));
        }
        if ((len = c.getAnnotation(MaximumPathLength.class)) != null) {
            acteurs.add(this.af.maximumPathLength(len.value()));
        }
        if ((banned = c.getAnnotation(BannedUrlParameters.class)) != null) {
            acteurs.add(this.af.banParameters(banned.value()));
        }
        if ((atLeastOneOf = c.getAnnotation(RequireAtLeastOneUrlParameterFrom.class)) != null) {
            acteurs.add(this.af.requireAtLeastOneParameter(atLeastOneOf.value()));
        }
        if ((params = c.getAnnotation(RequiredUrlParameters.class)) != null) {
            switch (params.combination()) {
                case ALL: {
                    acteurs.add(this.af.requireParameters(params.value()));
                    break;
                }
                case AT_LEAST_ONE: {
                    acteurs.add(this.af.requireAtLeastOneParameter(params.value()));
                    break;
                }
                default: {
                    throw new AssertionError((Object)params.combination());
                }
            }
        }
        if ((methodParams = c.getAnnotation(RequireParametersIfMethodMatches.class)) != null) {
            acteurs.add(this.af.requireParametersIfMethodMatches(methodParams.method(), methodParams.value()));
        }
        if ((nums = c.getAnnotation(ParametersMustBeNumbersIfPresent.class)) != null) {
            acteurs.add(this.af.parametersMustBeNumbersIfTheyArePresent(nums.allowDecimal(), nums.allowNegative(), nums.value()));
        }
        if ((minLength = c.getAnnotation(MinimumRequestBodyLength.class)) != null) {
            acteurs.add(this.af.minimumBodyLength(minLength.value()));
        }
        if ((maxLength = c.getAnnotation(MaximumRequestBodyLength.class)) != null) {
            acteurs.add(this.af.maximumBodyLength(maxLength.value()));
        }
        if ((combos = c.getAnnotation(UrlParametersMayNotBeCombined.class)) != null) {
            acteurs.add(this.af.parametersMayNotBeCombined(combos.value()));
        }
        if ((comboSet = c.getAnnotation(UrlParametersMayNotBeCombinedSets.class)) != null) {
            for (UrlParametersMayNotBeCombined c1 : comboSet.value()) {
                acteurs.add(this.af.parametersMayNotBeCombined(c1.value()));
            }
        }
        if ((paramsIface = c.getAnnotation(InjectUrlParametersAs.class)) != null) {
            Class<?> type = paramsIface.value();
            acteurs.add(this.af.injectRequestParametersAs(type));
        }
        if ((cors = c.getAnnotation(CORS.class)) != null) {
            acteurs.add(Acteur.wrap(CORSResource.CorsHeaders.class, this.deps));
        }
        boolean hasAuth = false;
        BasicAuth auth = c.getAnnotation(BasicAuth.class);
        if (auth != null) {
            acteurs.add(Acteur.wrap(AuthenticationActeur.class, this.deps));
        }
        Authenticated auth2 = c.getAnnotation(Authenticated.class);
        if (!hasAuth && auth2 != null) {
            acteurs.add(Acteur.wrap(AuthenticationActeur.class, this.deps));
        }
        AuthenticatedIf authIf = c.getAnnotation(AuthenticatedIf.class);
        if (!hasAuth && authIf != null && this.settings.getBoolean(authIf.setting(), false)) {
            acteurs.add(Acteur.wrap(AuthenticationActeur.class, this.deps));
        }
        if ((as = c.getAnnotation(InjectRequestBodyAs.class)) != null) {
            acteurs.add(this.af.injectRequestBodyAsJSON(as.value()));
        }
        return oldSize != acteurs.size();
    }
}

