/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Singleton;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.CORSResponseDecorator;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.header.entities.CacheControl;
import com.mastfrog.acteur.header.entities.CacheControlTypes;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.preconditions.Description;
import com.mastfrog.acteur.preconditions.Methods;
import com.mastfrog.settings.Settings;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.Duration;
import javax.inject.Inject;

@Description(category="Info", value="Answers CORS preflight HTTP OPTIONS requests - see the ajax spec")
@Methods(value={Method.OPTIONS})
final class CORSResource
extends Page {
    @Inject
    CORSResource() {
        this.add(CorsHeaders.class);
        this.add(CorsResponse.class);
    }

    static final class CorsHeaders
    extends Acteur {
        @Inject
        CorsHeaders(CORSResponseDecorator corsDecorator, HttpEvent evt, Page page) {
            corsDecorator.decorateCorsPreflight(evt, this.response(), page);
            this.next(new Object[0]);
        }
    }

    private static final class CorsResponse
    extends Acteur {
        @Inject
        CorsResponse(CacheControlDuration dur) {
            this.response().addIfUnset(Headers.CACHE_CONTROL, dur.cacheControl);
            this.reply(HttpResponseStatus.NO_CONTENT);
        }
    }

    @Singleton
    static final class CacheControlDuration {
        final CacheControl cacheControl;

        @Inject
        CacheControlDuration(Settings settings) {
            Duration corsCacheControlMaxAge = Duration.ofDays(settings.getLong("cors.cache.control.max.age.days", 365L));
            this.cacheControl = CacheControl.$((CacheControlTypes)CacheControlTypes.Public).add(CacheControlTypes.max_age, corsCacheControlMaxAge);
        }
    }
}

