/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Singleton;
import com.mastfrog.acteur.CORSResponseDecorator;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.Response;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.preconditions.CORS;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

@Singleton
final class CORSResponseDecoratorImpl
implements CORSResponseDecorator {
    private static final Method[] methods = new Method[]{Method.GET, Method.POST, Method.PUT, Method.DELETE, Method.OPTIONS};
    static final HeaderValueType<CharSequence> ALLOW_ORIGIN_STRING = Headers.ACCESS_CONTROL_ALLOW_ORIGIN.toStringHeader();
    static final HeaderValueType<CharSequence> ALLOW_HEADERS_STRING = Headers.ACCESS_CONTROL_ALLOW_HEADERS.toStringHeader();
    static final HeaderValueType<CharSequence> ALLOW_CREDENTIALS_STRING = Headers.ACCESS_CONTROL_ALLOW_CREDENTIALS.toStringHeader();
    final CharSequence hdrs;
    final Duration corsMaxAge;
    private final String allowOrigin;
    private final boolean allowCredentials;
    private static final AsciiString TRUE = new AsciiString((CharSequence)"true");
    private static final AsciiString FALSE = new AsciiString((CharSequence)"false");

    @Inject
    CORSResponseDecoratorImpl(Settings settings) {
        String replace;
        HashSet<HeaderValueType> defaultHeaders = new HashSet<HeaderValueType>(CollectionUtils.setOf((Object[])new HeaderValueType[]{Headers.CONTENT_TYPE, Headers.ACCEPT, Headers.X_REQUESTED_WITH, Headers.AUTHORIZATION}));
        String addtl = settings.getString("cors.allow.headers");
        if (addtl != null) {
            Set seqs = Strings.splitUniqueNoEmpty((char)',', (CharSequence)addtl);
            for (CharSequence s : seqs) {
                defaultHeaders.add(Headers.header((CharSequence)s));
            }
        }
        if ((replace = settings.getString("cors.replace.allow.headers")) != null) {
            this.hdrs = replace;
        } else {
            ArrayList headerNames = new ArrayList(CollectionUtils.transform(defaultHeaders, h -> h.name()));
            Collections.sort(headerNames, Strings.charSequenceComparator((boolean)true));
            this.hdrs = new AsciiString((CharSequence)Strings.join((char)',', headerNames));
        }
        this.allowCredentials = settings.getBoolean("cors.allow.credentials", true);
        this.corsMaxAge = Duration.of(settings.getLong("cors.max.age.minutes", 5L), ChronoUnit.MINUTES);
        this.allowOrigin = settings.getString("cors.allow.origin", "*");
    }

    @Override
    public void decorateCorsPreflight(HttpEvent evt, Response resp, Page page) {
        Duration maxAge;
        String ao;
        Method[] methods = CORSResponseDecoratorImpl.methods;
        CORS cors = page.getClass().getAnnotation(CORS.class);
        CharSequence headers = this.hdrs;
        if (cors != null) {
            if (!cors.value()) {
                return;
            }
            if (cors.methods().length > 0) {
                methods = cors.methods();
            }
            if (cors.headers().length > 0) {
                headers = Strings.join((char)',', (String[])cors.headers());
            }
            ao = this.corsOrigin(cors);
            maxAge = cors.maxAgeSeconds() > 0 ? Duration.ofSeconds(cors.maxAgeSeconds()) : this.corsMaxAge;
        } else {
            ao = this.allowOrigin;
            maxAge = this.corsMaxAge;
        }
        resp.addIfUnset(ALLOW_ORIGIN_STRING, ao);
        resp.addIfUnset(ALLOW_CREDENTIALS_STRING, this.allowCredentials ? TRUE : FALSE);
        resp.addIfUnset(ALLOW_HEADERS_STRING, headers);
        resp.addIfUnset(Headers.ACCESS_CONTROL_ALLOW, methods);
        resp.addIfUnset(Headers.ACCESS_CONTROL_MAX_AGE, maxAge);
    }

    private String corsOrigin(CORS cors) {
        String ao;
        switch (cors.origins().length) {
            case 0: {
                ao = this.allowOrigin;
                break;
            }
            case 1: {
                ao = cors.origins()[0];
                break;
            }
            default: {
                ao = Strings.join((char)',', (String[])cors.origins());
            }
        }
        return ao;
    }

    @Override
    public void decorateApplicationResponse(HttpResponse response) {
        if (!response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN)) {
            Headers.write((HeaderValueType)Headers.ACCESS_CONTROL_ALLOW_ORIGIN.toStringHeader(), (Object)this.allowOrigin, (HttpMessage)response);
        }
        if (!response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE)) {
            Headers.write((HeaderValueType)Headers.ACCESS_CONTROL_MAX_AGE, (Object)this.corsMaxAge, (HttpMessage)response);
        }
    }

    @Override
    public void decorateApplicationResponse(HttpResponse response, Page page) {
        CORS cors = page.getClass().getAnnotation(CORS.class);
        if (cors != null) {
            int ma;
            if (!response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN)) {
                Headers.write((HeaderValueType)Headers.ACCESS_CONTROL_ALLOW_ORIGIN.toStringHeader(), (Object)this.corsOrigin(cors), (HttpMessage)response);
            }
            Duration maxAge = (ma = cors.maxAgeSeconds()) > 0 ? Duration.ofSeconds(ma) : this.corsMaxAge;
            if (!response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE)) {
                Headers.write((HeaderValueType)Headers.ACCESS_CONTROL_MAX_AGE, (Object)maxAge, (HttpMessage)response);
            }
        } else {
            this.decorateApplicationResponse(response);
        }
    }
}

