/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.util.time.TimeUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.inject.Inject;

public final class CheckIfModifiedSinceHeader
extends Acteur {
    @Inject
    CheckIfModifiedSinceHeader(HttpEvent event, Page page) {
        ZonedDateTime pageLastModified;
        ZonedDateTime lastModifiedMustBeNewerThan = (ZonedDateTime)event.header(Headers.IF_MODIFIED_SINCE);
        if (lastModifiedMustBeNewerThan != null && (pageLastModified = (ZonedDateTime)this.response().get(Headers.LAST_MODIFIED)) != null && TimeUtil.isBeforeEqualOrNullSecondsResolution((ZonedDateTime)lastModifiedMustBeNewerThan, (ZonedDateTime)pageLastModified)) {
            this.reply(HttpResponseStatus.NOT_MODIFIED);
            return;
        }
        this.next(new Object[0]);
    }

    @Override
    public void describeYourself(Map<String, Object> into) {
        into.put("Check if the Last-Modified header of the current page is older than the date in the If-Modified-Since header (if any) in the current request", true);
    }
}

