/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.preconditions.Description;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import javax.inject.Inject;

@Description(value="Replies with a 304 Not-Modified if the If-None-Match header in the current request matches the ETag header already set on the current response")
public final class CheckIfNoneMatchHeader
extends Acteur {
    @Inject
    CheckIfNoneMatchHeader(HttpEvent event, Page page) throws Exception {
        Checks.notNull((String)"event", (Object)event);
        Checks.notNull((String)"page", (Object)page);
        CharSequence etag = (CharSequence)event.header(Headers.IF_NONE_MATCH);
        CharSequence pageEtag = (CharSequence)this.response().get(Headers.ETAG);
        if (etag != null && pageEtag != null && Strings.charSequencesEqual((CharSequence)etag, (CharSequence)pageEtag)) {
            this.reply(HttpResponseStatus.NOT_MODIFIED);
            return;
        }
        this.next(new Object[0]);
    }

    @Override
    public void describeYourself(Map<String, Object> into) {
        into.put("Replies with a 304 Not-Modified if the If-None-Match header in the current request matches the ETag header already set on the current response", true);
    }
}

