/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.preconditions.Description;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Map;
import javax.inject.Inject;

@Description(value="Replies with a 304 Not-Modified status if the If-Modified-Since header in the current request matches the Last-Modified header already set on the current response")
public final class CheckIfUnmodifiedSinceHeader
extends Acteur {
    @Inject
    CheckIfUnmodifiedSinceHeader(HttpEvent event, Page page) {
        ZonedDateTime pageLastModified;
        ZonedDateTime headerValue = (ZonedDateTime)event.header(Headers.IF_UNMODIFIED_SINCE);
        if (headerValue != null && (pageLastModified = (ZonedDateTime)this.response().get(Headers.LAST_MODIFIED)) != null && (headerValue.equals(pageLastModified = pageLastModified.with(ChronoField.MILLI_OF_SECOND, 0L)) || headerValue.isBefore(pageLastModified))) {
            this.reply(HttpResponseStatus.PRECONDITION_FAILED);
        }
        this.next(new Object[0]);
    }

    @Override
    public void describeYourself(Map<String, Object> into) {
        into.put("Replies with a 304 Not-Modified status if the If-Modified-Since header in the current request matches the Last-Modified header already set on the current response", true);
    }
}

