/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteurbase.Deferral;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;

public abstract class ChunkHandler
extends SimpleChannelInboundHandler<Object> {
    private boolean resumed;
    private Deferral.Resumer resumer;
    private Object[] context = new Object[0];

    public synchronized void setResumer(Deferral.Resumer resumer) {
        this.resumer = resumer;
        if (this.resumed) {
            resumer.resume(this.context);
        }
    }

    protected final synchronized void resume(Object ... ctx) {
        this.resumed = true;
        if (this.resumer != null) {
            this.resumer.resume(this.context);
        } else {
            this.context = ctx;
        }
    }

    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            HttpHeaders headers = content instanceof LastHttpContent ? ((LastHttpContent)content).trailingHeaders() : null;
            this.onContent(ctx, content.content(), headers, content instanceof LastHttpContent);
        } else if (msg instanceof FullHttpRequest) {
            FullHttpRequest full = (FullHttpRequest)msg;
            this.onContent(ctx, full.content(), full.headers(), true);
        }
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof HttpContent || msg instanceof FullHttpRequest;
    }

    protected abstract void onContent(ChannelHandlerContext var1, ByteBuf var2, HttpHeaders var3, boolean var4) throws Exception;
}

