/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.strings.Strings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Closables {
    private final List<AutoCloseable> closeables = new CopyOnWriteArrayList<AutoCloseable>();
    private final List<Timer> timers = new CopyOnWriteArrayList<Timer>();
    private final CloseWhenChannelCloses closeListener;
    private final ApplicationControl application;
    private volatile boolean closed;

    Closables(Channel channel, ApplicationControl application) {
        this.closeListener = new CloseWhenChannelCloses(channel);
        channel.closeFuture().addListener((GenericFutureListener)this.closeListener);
        this.application = application;
    }

    public String toString() {
        return Strings.join((char)',', this.closeables) + "/" + Strings.join((char)',', this.timers);
    }

    public final <T, R extends CompletionStage<T>> R add(R fut) {
        if (fut instanceof CompletableFuture) {
            this.add(new AutoClosableWrapper(fut));
        }
        return fut;
    }

    private void checkClosed() {
        if (this.closed) {
            try {
                this.close();
            }
            catch (Exception ex) {
                Exceptions.chuck((Throwable)ex);
            }
        }
    }

    public final <T extends AutoCloseable> T add(T closable) {
        Checks.notNull((String)"closeable", closable);
        if (!this.closeables.contains(closable)) {
            this.closeables.add(closable);
        }
        this.checkClosed();
        return closable;
    }

    public final <T extends Timer> T add(T timer) {
        Checks.notNull((String)"timer", timer);
        if (!this.timers.contains(timer)) {
            this.timers.add(timer);
        }
        this.checkClosed();
        return timer;
    }

    public final Closables add(Runnable run) {
        Checks.notNull((String)"run", (Object)run);
        for (AutoCloseable clos : this.closeables) {
            RunnableWrapper w;
            if (!(clos instanceof RunnableWrapper) || (w = (RunnableWrapper)clos).run != w.run) continue;
            return this;
        }
        this.add(new RunnableWrapper(run));
        this.checkClosed();
        return this;
    }

    void forceClose() throws Exception {
        this.closeListener.earlyClose();
    }

    void closeOn(ChannelFuture future) {
        future.addListener((GenericFutureListener)this.closeListener);
        this.closeListener.detach();
    }

    public boolean isClosed() {
        return this.closed;
    }

    void close() throws Exception {
        this.closed = true;
        for (AutoCloseable ac : this.closeables) {
            try {
                ac.close();
            }
            catch (Exception e1) {
                this.application.internalOnError(e1);
            }
        }
        for (Timer t : this.timers) {
            try {
                t.cancel();
            }
            catch (Exception e2) {
                this.application.internalOnError(e2);
            }
        }
    }

    final class CloseWhenChannelCloses
    implements ChannelFutureListener {
        private final Channel channel;

        public CloseWhenChannelCloses(Channel channel) {
            this.channel = channel;
            channel.closeFuture().addListener((GenericFutureListener)this);
        }

        void detach() {
            this.channel.closeFuture().removeListener((GenericFutureListener)this);
        }

        void earlyClose() throws Exception {
            this.detach();
            Closables.this.close();
        }

        public void operationComplete(ChannelFuture f) throws Exception {
            Closables.this.close();
        }

        public String toString() {
            return "channel:" + this.channel.id();
        }
    }

    static final class AutoClosableWrapper
    implements QuietAutoClosable {
        private final Reference<CompletionStage<?>> fut;

        AutoClosableWrapper(CompletionStage<?> fut) {
            this.fut = new WeakReference(fut);
        }

        public void close() {
            CompletableFuture future;
            CompletionStage<?> c = this.fut.get();
            CompletableFuture completableFuture = future = c instanceof CompletableFuture ? (CompletableFuture)this.fut.get() : null;
            if (future != null && !future.isDone()) {
                future.cancel(true);
            }
        }

        public String toString() {
            CompletionStage<?> c = this.fut.get();
            CompletableFuture f = c instanceof CompletableFuture ? (CompletableFuture)this.fut.get() : null;
            return f != null ? f.toString() : "<already-gcd>";
        }
    }

    static class RunnableWrapper
    implements AutoCloseable {
        private final Runnable run;

        RunnableWrapper(Runnable run) {
            this.run = run;
        }

        @Override
        public void close() throws Exception {
            this.run.run();
        }

        public String toString() {
            return this.run.toString();
        }
    }
}

