/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.mime.MimeType;
import com.mastfrog.util.codec.Codec;
import com.mastfrog.util.time.TimeUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.netbeans.validation.api.InvalidInputException;

@Singleton
public class ContentConverter {
    protected final Codec codec;
    private final Provider<Charset> charset;
    private final Dependencies deps;
    private final Map<Class<?>, ContentValidationPlugin> plugins = new HashMap();

    @Inject
    public ContentConverter(Codec codec, Provider<Charset> charset, Dependencies deps) {
        this.codec = codec;
        this.charset = charset;
        this.deps = deps;
    }

    public String toString(ByteBuf content, Charset encoding) throws IOException {
        content.resetReaderIndex();
        CharSequence cs = content.readCharSequence(content.readableBytes(), encoding);
        if (cs == null) {
            return null;
        }
        String result = cs.toString();
        content.resetReaderIndex();
        if (result.length() > 0 && result.charAt(0) == '\"') {
            result = result.substring(1);
        }
        if (result.length() > 1 && result.charAt(result.length() - 1) == '\"') {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    private Charset findCharset(MimeType mt) {
        if (mt == null) {
            return (Charset)this.charset.get();
        }
        if (mt.charset().isPresent()) {
            return (Charset)mt.charset().get();
        }
        return (Charset)this.charset.get();
    }

    public <T> T toObject(ByteBuf content, MimeType mimeType, Class<T> type) throws Exception {
        if (mimeType == null) {
            mimeType = MimeType.ANY_TYPE;
        }
        if (type == String.class || type == CharSequence.class) {
            return type.cast(this.toString(content, this.findCharset(mimeType)));
        }
        if (type.isInterface()) {
            Map m;
            try (ByteBufInputStream in = new ByteBufInputStream(content);){
                m = (Map)this.codec.readValue((InputStream)in, Map.class);
            }
            return this.toObject(m, type);
        }
        return this.readObject(content, mimeType, type);
    }

    private <T> void register(ContentValidationPlugin plugin, Class<T> type) {
        this.plugins.put(type, plugin);
    }

    protected <T> T readObject(ByteBuf buf, MimeType mimeType, Class<T> type) throws Exception {
        if (type == String.class || type == CharSequence.class) {
            return type.cast(this.toString(buf, this.findCharset(mimeType)));
        }
        ContentValidationPlugin plugin = this.plugins.get(type);
        if (plugin != null) {
            plugin.validate(buf, mimeType, type, this.codec);
        }
        buf.resetReaderIndex();
        try {
            Object object;
            ByteBufInputStream in = new ByteBufInputStream(buf);
            try {
                Object result;
                object = result = this.codec.readValue((InputStream)in, type);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw ioe;
                }
            }
            in.close();
            return (T)object;
        }
        finally {
            buf.resetReaderIndex();
        }
    }

    public <T> T toObject(Map<String, ?> m, Class<T> type) throws InvalidInputException {
        if (type.isInterface()) {
            return this.createProxyFor(m, type);
        }
        return this.createObjectFor(m, type);
    }

    protected <T> T createObjectFor(Map<String, ?> m, Class<T> type) {
        ContentValidationPlugin plugin = this.plugins.get(type);
        if (plugin != null) {
            plugin.validate(type, m);
        }
        return (T)this.deps.getInstance(type);
    }

    protected <T> T createProxyFor(Map<String, ?> m, Class<T> type) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + type);
        }
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, (InvocationHandler)new IH(type, m));
    }

    private static long parseDate(String result) {
        long when;
        try {
            when = Long.parseLong(result);
        }
        catch (NumberFormatException nfe) {
            when = Date.parse(result);
        }
        return when;
    }

    public static abstract class ContentValidationPlugin {
        private final ContentConverter converter;

        protected ContentValidationPlugin(ContentConverter converter, Class<?> ... types) {
            this.converter = converter;
            for (Class<?> t : types) {
                this.register(t);
            }
        }

        protected ContentValidationPlugin(ContentConverter converter, Iterable<Class<?>> types) {
            this.converter = converter;
            for (Class<?> t : types) {
                this.register(t);
            }
        }

        protected ContentValidationPlugin(ContentConverter converter, String ... types) throws ClassNotFoundException {
            this.converter = converter;
            for (String t : types) {
                this.register(Class.forName(t));
            }
        }

        protected ContentValidationPlugin(ContentConverter converter, Set<String> types) throws ClassNotFoundException {
            this.converter = converter;
            for (String t : types) {
                this.register(Class.forName(t));
            }
        }

        protected final <T> ContentValidationPlugin register(Class<T> type) {
            this.converter.register(this, type);
            return this;
        }

        protected abstract <T> void validate(ByteBuf var1, MimeType var2, Class<T> var3, Codec var4) throws Exception;

        protected abstract <T> void validate(Class<T> var1, Map<String, ?> var2);
    }

    static class IH
    implements InvocationHandler {
        private final Class<?> iface;
        private final Map<String, ?> map;

        IH(Class<?> iface, Map<String, ?> map) {
            this.iface = iface;
            this.map = map;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("equals".equals(method.getName())) {
                return false;
            }
            if ("hashCode".equals(method.getName())) {
                return this.map.hashCode();
            }
            if ("toString".equals(method.getName())) {
                return "Proxy " + this.iface.getSimpleName() + " over parameters " + this.map;
            }
            String nm = method.getName();
            String result = this.map.get(nm) instanceof String ? (String)this.map.get(nm) : (this.map.containsKey(nm) ? this.map.get(nm) + "" : null);
            Class<?> ret = method.getReturnType();
            if (result == null) {
                return null;
            }
            if (ret == Long.TYPE || ret == Long.class) {
                if (ret == Long.class && result == null) {
                    return null;
                }
                return Long.parseLong(result);
            }
            if (ret == String.class || ret == CharSequence.class) {
                return result;
            }
            if (ret == Integer.TYPE || ret == Integer.class) {
                if (ret == Integer.class && result == null) {
                    return null;
                }
                return Integer.parseInt(result);
            }
            if (ret == Double.TYPE || ret == Double.class || ret == Number.class) {
                if (ret == Double.class && result == null) {
                    return null;
                }
                return Double.parseDouble(result);
            }
            if (ret == Float.TYPE || ret == Float.class) {
                if (ret == Float.class && result == null) {
                    return null;
                }
                return Float.valueOf(Float.parseFloat(result));
            }
            if (ret == char[].class) {
                return result.toCharArray();
            }
            if (Byte.TYPE == ret || Byte.class == ret) {
                if (ret == Byte.class && result == null) {
                    return null;
                }
                return Byte.parseByte(result);
            }
            if (Short.class == ret || Short.TYPE == ret) {
                if (ret == Short.class && result == null) {
                    return null;
                }
                return Short.parseShort(result);
            }
            if (ret == Boolean.TYPE || ret == Boolean.class) {
                switch (result) {
                    case "0": {
                        return false;
                    }
                    case "1": {
                        return true;
                    }
                }
                return result == null ? false : Boolean.parseBoolean(result);
            }
            if (method.getReturnType() == String.class) {
                return result.split(",");
            }
            if (method.getReturnType() == Date.class) {
                long when = ContentConverter.parseDate(result);
                if (when != Long.MIN_VALUE) {
                    return ContentConverter.parseDate(result);
                }
                return null;
            }
            if (method.getReturnType() == ZonedDateTime.class) {
                long when = ContentConverter.parseDate(result);
                if (when == Long.MIN_VALUE) {
                    return null;
                }
                return TimeUtil.fromUnixTimestamp((long)ContentConverter.parseDate(result));
            }
            if (method.getReturnType() == Duration.class) {
                long amt;
                try {
                    amt = Long.parseLong(result);
                }
                catch (NumberFormatException nfe) {
                    return Duration.ZERO;
                }
                return TimeUtil.millis((long)amt);
            }
            throw new IllegalArgumentException("Unsupported type " + method.getReturnType());
        }
    }
}

