/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Singleton;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.RequestLogger;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.util.RequestID;
import com.mastfrog.util.time.TimeUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.Duration;
import javax.inject.Inject;

@Singleton
class DefaultRequestLogger
implements RequestLogger {
    @Inject
    DefaultRequestLogger() {
    }

    @Override
    public void onBeforeEvent(RequestID rid, Event<?> event) {
    }

    @Override
    public void onRespond(RequestID rid, Event<?> event, HttpResponseStatus status) {
        int reqNum = rid == null ? -1 : rid.getIndex();
        StringBuilder sb = new StringBuilder(120).append(reqNum).append('\t').append(rid == null ? TimeUtil.format((Duration)Duration.ZERO) : TimeUtil.format((Duration)rid.getDuration())).append('\t').append(event.remoteAddress()).append("\t").append(status).append("\t").append(event);
        if (event instanceof HttpEvent) {
            CharSequence userAgent;
            CharSequence referrer = (CharSequence)((HttpEvent)event).header(Headers.REFERRER);
            if (referrer != null) {
                sb.append('\t').append(referrer);
            }
            if ((userAgent = (CharSequence)((HttpEvent)event).header(Headers.USER_AGENT)) != null) {
                sb.append('\t').append(userAgent);
            }
        }
        System.out.println(sb);
    }
}

