/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.DeferredComputationResult;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.errors.Err;
import com.mastfrog.acteur.errors.ErrorResponse;
import com.mastfrog.acteur.errors.ExceptionEvaluatorRegistry;
import com.mastfrog.acteur.errors.ResponseException;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.mime.MimeType;
import io.netty.handler.codec.http.HttpResponseStatus;
import javax.inject.Inject;

public class DeferredComputationResultActeur
extends Acteur {
    @Inject
    DeferredComputationResultActeur(HttpEvent evt, DeferredComputationResult res, ExceptionEvaluatorRegistry evals) throws Throwable {
        if (res.thrown != null) {
            this.add(Headers.CONTENT_TYPE, MimeType.JSON_UTF_8);
            if (res.thrown instanceof ResponseException) {
                throw res.thrown;
            }
            ErrorResponse resp = evals.evaluate(res.thrown, this, Page.get(), evt);
            if (resp != null && resp.status() != HttpResponseStatus.INTERNAL_SERVER_ERROR) {
                this.reply(resp.status(), resp.message());
                return;
            }
            this.reply(Err.of(res.thrown));
        } else if (res.what == null) {
            if (res.onSuccess == null) {
                this.ok();
            } else {
                this.reply(res.onSuccess);
            }
        } else if (res.onSuccess == null) {
            this.ok(res.what);
        } else {
            this.reply(res.onSuccess, res.what);
        }
    }
}

