/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.ProvisionException;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.errors.Err;
import com.mastfrog.acteur.errors.ErrorRenderer;
import com.mastfrog.acteur.errors.ErrorResponse;
import com.mastfrog.acteur.errors.ExceptionEvaluatorRegistry;
import com.mastfrog.acteur.errors.ResponseException;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.giulius.Dependencies;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;

final class ErrorActeur
extends Acteur {
    ErrorActeur(Acteur errSource, Event<?> evt, Page page, Throwable t, boolean tryErrResponse, boolean log) throws IOException {
        Throwable orig = t;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof ResponseException) {
            ResponseException rt = (ResponseException)t;
            this.setState((Acteur)this.new Acteur.RespondWith(new Err(rt.status(), rt.getMessage())));
            if (!rt.headers().isEmpty()) {
                for (Map.Entry<CharSequence, CharSequence> e : rt.headers().entrySet()) {
                    this.add(Headers.header((CharSequence)e.getKey()), e.getValue());
                }
            }
            return;
        }
        if (tryErrResponse) {
            Dependencies deps = page.application.getDependencies();
            if (t instanceof ProvisionException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t == null) {
                t = orig;
            }
            ExceptionEvaluatorRegistry reg = (ExceptionEvaluatorRegistry)deps.getInstance(ExceptionEvaluatorRegistry.class);
            ErrorResponse resp = reg.evaluate(t, errSource, page, evt);
            if (log && resp instanceof Err && ((Err)resp).unhandled) {
                page.application.control().internalOnError(t);
            }
            if (resp != null) {
                ErrorRenderer ren = (ErrorRenderer)deps.getInstance(ErrorRenderer.class);
                ren.render(resp, this.response(), evt);
                if (!resp.headers().isEmpty()) {
                    for (Map.Entry<CharSequence, CharSequence> e : resp.headers().entrySet()) {
                        this.add(Headers.header((CharSequence)e.getKey()), e.getValue());
                    }
                }
                this.setState((Acteur)this.new Acteur.RespondWith(resp.status()));
                return;
            }
        }
        StringBuilder sb = new StringBuilder("Page " + page + " (" + page.getClass().getName() + ") threw " + t.getMessage() + '\n');
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            t.printStackTrace(new PrintStream(out));
            sb.append(new String(out.toByteArray()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setState((Acteur)this.new Acteur.RespondWith(HttpResponseStatus.INTERNAL_SERVER_ERROR, (Object)sb.toString()));
    }
}

