/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.Singleton;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.annotations.Concluders;
import com.mastfrog.acteur.annotations.GeneratedFrom;
import com.mastfrog.acteur.annotations.HttpCall;
import com.mastfrog.acteur.annotations.Precursors;
import com.mastfrog.acteur.preconditions.Description;
import com.mastfrog.acteur.preconditions.Example;
import com.mastfrog.acteur.preconditions.Examples;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.strings.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;

@Singleton
public final class HelpGenerator {
    private final Set<AnnotationDescriptionPlugin<?>> plugins = new HashSet();

    @Inject
    HelpGenerator() {
    }

    private <T extends Annotation> void register(AnnotationDescriptionPlugin<T> plugin) {
        this.plugins.add(plugin);
    }

    <T extends Annotation> boolean write(Application application, Map<String, Object> into, T annotation) {
        boolean result = false;
        for (AnnotationDescriptionPlugin<?> p : this.plugins) {
            if (result |= p.doWrite(application, into, annotation)) break;
        }
        return result;
    }

    void generate(Application application, List<Object> pagesAndPageTypes, Map<String, Object> m) {
        for (Object o : pagesAndPageTypes) {
            if (o instanceof Class) {
                Annotation[] l;
                Class type = (Class)o;
                LinkedHashMap<String, Object> pageDescription = new LinkedHashMap<String, Object>();
                String typeName = type.getName();
                if (typeName.endsWith("__GenPage")) {
                    typeName = typeName.substring(0, typeName.length() - "__GenPage".length());
                }
                pageDescription.put("type", type.getName());
                String className = type.getSimpleName();
                if (className.endsWith("__GenPage")) {
                    className = className.substring(0, className.length() - "__GenPage".length());
                }
                m.put(className, pageDescription);
                for (Annotation a : l = type.getAnnotations()) {
                    if (a instanceof HttpCall) continue;
                    if (a instanceof Example) {
                        Example ex = (Example)a;
                        if (!ex.value().isEmpty()) {
                            pageDescription.put("Sample URL", ex.value());
                        }
                        if (ex.inputType() != Object.class) {
                            pageDescription.put("Sample Input", this.reflectAndJsonify(application, ex.inputField(), ex.inputType()));
                        }
                        if (ex.outputType() == Object.class) continue;
                        pageDescription.put("Sample Output", this.reflectAndJsonify(application, ex.outputField(), ex.outputType()));
                        continue;
                    }
                    LinkedHashMap<String, Object> annoDescription = new LinkedHashMap<String, Object>();
                    pageDescription.put(a.annotationType().getSimpleName(), annoDescription);
                    try {
                        this.introspectAnnotation(application, a, annoDescription);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    if (annoDescription.size() != 1 || !"value".equals(annoDescription.keySet().iterator().next())) continue;
                    pageDescription.put(a.annotationType().getSimpleName(), annoDescription.values().iterator().next());
                }
                try {
                    Page p = (Page)application.getDependencies().getInstance(type);
                    p.application = application;
                    for (Object acteur : p.acteurs(application.isDefaultCorsHandlingEnabled())) {
                        HashMap<String, Object> callFlow;
                        Class at = null;
                        if (acteur instanceof Acteur.WrapperActeur) {
                            at = ((Acteur.WrapperActeur)acteur).type();
                        } else if (acteur instanceof Class) {
                            at = (Class)acteur;
                        }
                        if (at != null) {
                            callFlow = new HashMap<String, Object>();
                            for (Annotation a1 : at.getAnnotations()) {
                                this.introspectAnnotation(application, a1, callFlow);
                            }
                            if (!className.equals(at.getSimpleName())) {
                                for (Annotation a2 : at.getAnnotations()) {
                                    this.introspectAnnotation(application, a2, callFlow);
                                }
                            }
                            if (callFlow.isEmpty()) continue;
                            pageDescription.put(at.getSimpleName(), callFlow);
                            continue;
                        }
                        if (!(acteur instanceof Acteur)) continue;
                        callFlow = new HashMap();
                        for (Annotation a1 : acteur.getClass().getAnnotations()) {
                            this.introspectAnnotation(application, a1, callFlow);
                        }
                        ((Acteur)((Object)acteur)).describeYourself(callFlow);
                        if (callFlow.isEmpty()) continue;
                        pageDescription.put(acteur.toString(), callFlow);
                    }
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (!(o instanceof Page)) continue;
            ((Page)o).describeYourself(m);
        }
    }

    private static String deConstantNameify(String name) {
        StringBuilder sb = new StringBuilder();
        boolean capitalize = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                sb.append(' ');
                continue;
            }
            if (capitalize) {
                c = Character.toUpperCase(c);
                capitalize = false;
            } else {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void introspectAnnotation(Application application, Annotation a, Map<String, Object> into) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.write(application, into, a)) {
            return;
        }
        if (a instanceof HttpCall) {
            return;
        }
        if (a instanceof Precursors) {
            Precursors p = (Precursors)a;
            for (Class<? extends Acteur> t : p.value()) {
                for (Annotation anno : t.getAnnotations()) {
                    this.introspectAnnotation(application, anno, into);
                }
            }
        } else if (a instanceof Concluders) {
            Concluders c = (Concluders)a;
            for (Class<? extends Acteur> t : c.value()) {
                for (Annotation anno : t.getAnnotations()) {
                    this.introspectAnnotation(application, anno, into);
                }
            }
        } else if (a instanceof Examples) {
            Examples e = (Examples)a;
            int ix = 1;
            for (Examples.Case kase : e.value()) {
                TreeMap<String, String> m = new TreeMap<String, String>();
                if (!kase.title().isEmpty()) {
                    m.put("title", kase.title());
                }
                if (!kase.description().isEmpty()) {
                    m.put("description", kase.description());
                }
                Example ex = kase.value();
                m.put("Sample URL", ex.value());
                if (ex.inputType() != Object.class) {
                    String inp = this.reflectAndJsonify(application, ex.inputField(), ex.inputType());
                    m.put("Sample Input", inp);
                }
                if (ex.outputType() != Object.class) {
                    String out = this.reflectAndJsonify(application, ex.outputField(), ex.outputType());
                    m.put("Sample Output", out);
                }
                into.put("example-" + ix++, m);
            }
        } else if (a instanceof GeneratedFrom) {
            GeneratedFrom gf = (GeneratedFrom)a;
            Class from = gf.value();
            into.put("name", from.getName());
            Description desc = from.getAnnotation(Description.class);
            if (desc != null) {
                into.put("description", desc.value());
            }
        } else if (a != null) {
            Class<? extends Annotation> type = a.annotationType();
            block13: for (Method m : type.getMethods()) {
                switch (m.getName()) {
                    case "annotationType": 
                    case "toString": 
                    case "hashCode": {
                        continue block13;
                    }
                    default: {
                        if (m.getParameterTypes().length != 0 || m.getReturnType() == null) continue block13;
                        Object mr = m.invoke((Object)a, new Object[0]);
                        if (mr.getClass().isArray()) {
                            mr = CollectionUtils.toList((Object)mr);
                        }
                        into.put(m.getName(), mr);
                    }
                }
            }
            if (type.getAnnotation(Description.class) != null) {
                Description d = type.getAnnotation(Description.class);
                into.put("Description", d.value());
            }
        }
    }

    private String reflectAndJsonify(Application application, String field, Class<?> type) {
        try {
            Field f = type.getDeclaredField(field);
            f.setAccessible(true);
            if (f.getType() == String.class) {
                String res = (String)f.get(null);
                if (res != null) {
                    res = res.replaceAll("\\&", "&amp;");
                    res = Strings.literalReplaceAll((String)"\"", (String)"&quot;", (String)res);
                    res = Strings.literalReplaceAll((String)">", (String)"&gt;", (String)res);
                    res = Strings.literalReplaceAll((String)"<", (String)"&lt;", (String)res);
                }
                return "\n<pre>" + res + "</pre>\n";
            }
            Object o = f.get(null);
            ObjectMapper mapper = ((ObjectMapper)application.getDependencies().getInstance(ObjectMapper.class)).copy().enable(SerializationFeature.INDENT_OUTPUT).enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
            return "<pre>" + mapper.writeValueAsString(o).replace("\"", "&quot;") + "</pre>";
        }
        catch (Exception e) {
            return "Could not lookup and generate JSON from " + type.getName() + "." + field + ": " + e;
        }
    }

    public static abstract class AnnotationDescriptionPlugin<T extends Annotation> {
        final Class<T> annotationType;
        final HelpGenerator gen;

        protected AnnotationDescriptionPlugin(Class<T> annotationType, HelpGenerator gen) {
            this.annotationType = (Class)Checks.notNull((String)"annotationType", annotationType);
            this.gen = gen;
            gen.register(this);
        }

        boolean doWrite(Application application, Map<String, Object> addTo, Annotation a) {
            boolean result = this.annotationType.isInstance(a);
            int oldSize = addTo.size();
            if (result) {
                this.write(application, addTo, (Annotation)this.annotationType.cast(a));
            }
            return result && oldSize != addTo.size();
        }

        protected final String deConstantNameify(String s) {
            return HelpGenerator.deConstantNameify(s);
        }

        protected final void introspectAnnotation(Application application, Annotation a, Map<String, Object> into) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.annotationType.isInstance(a)) {
                throw new IllegalArgumentException("Already introspecting " + a + " - use this method for  annotations found indirectly when examining it.  Here this would just result in an endless loop.");
            }
            this.gen.introspectAnnotation(application, a, into);
        }

        protected final String reflectAndJsonify(Application application, String field, Class<?> type) {
            return this.gen.reflectAndJsonify(application, field, type);
        }

        protected abstract void write(Application var1, Map<String, Object> var2, T var3);
    }
}

