/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.ActeurFactory;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.ResponseWriter;
import com.mastfrog.acteur.header.entities.CacheControl;
import com.mastfrog.acteur.header.entities.Connection;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.preconditions.Description;
import com.mastfrog.acteur.preconditions.Methods;
import com.mastfrog.mime.MimeType;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.strings.Strings;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;

@Description(category="Info", value="Generates this API documentation, using the internals of the code to generate documentation.")
@Methods(value={Method.GET})
final class HelpPage
extends Page {
    @Inject
    HelpPage(ActeurFactory af, Settings settings) {
        String pattern = settings.getString("helpUrlPattern", "^help$");
        String pattern2 = settings.getString("helpHtmlUrlPattern", "^help\\.html$");
        this.add(af.matchPath(false, pattern, pattern2));
        this.add(af.sendNotModifiedIfIfModifiedSinceHeaderMatches());
        this.add(HelpActeur.class);
    }

    private static class HelpActeur
    extends Acteur {
        private final boolean html;

        @Inject
        HelpActeur(Application app, HttpEvent evt, Charset charset, ZonedDateTime serverStartTime) {
            boolean bl = this.html = "true".equals(evt.urlParameter("html")) || evt.path().lastElement().extensionEquals("html");
            if (this.html) {
                this.add(Headers.CONTENT_TYPE, MimeType.HTML_UTF_8.withCharset(charset));
            } else {
                this.add(Headers.CONTENT_TYPE, MimeType.JSON_UTF_8);
            }
            this.setChunked(true);
            this.setResponseWriter(new HelpWriter(this.html, app));
            this.add(Headers.CONNECTION, Connection.close);
            this.add(Headers.CACHE_CONTROL, CacheControl.PUBLIC_MUST_REVALIDATE);
            this.add(Headers.LAST_MODIFIED, serverStartTime);
        }

        @Override
        public void describeYourself(Map<String, Object> into) {
            into.put("Collects help info", true);
        }

        @Override
        public Acteur.BaseState getState() {
            return (Acteur)this.new Acteur.RespondWith(200);
        }

        public static final class HelpWriter
        extends ResponseWriter {
            private final boolean html;
            private final Application app;
            private int counter = 0;
            private final String valueClass = " singleValue";

            @Inject
            HelpWriter(boolean html, Application app) {
                this.html = html;
                this.app = app;
            }

            private String stripNamingConventions(String item) {
                for (String suffix : new String[]{"Resource", "Helper", "Endpoint", "Page", "Acteur"}) {
                    if (!item.endsWith(suffix)) continue;
                    return item.substring(0, item.length() - suffix.length());
                }
                return item;
            }

            private String namify(String s) {
                return s.toLowerCase().replace("\\s", "-");
            }

            private String findCategory(Object o) {
                Map desc;
                Map m;
                Object description;
                if (o instanceof Map && (description = (m = (Map)o).get("Description")) instanceof Map && (desc = (Map)description).get("category") instanceof String) {
                    return (String)desc.get("category");
                }
                return "Web-API";
            }

            private void findPaths(Object path, List<String> result) {
                Map m1;
                if (path instanceof Map && (m1 = (Map)path).containsKey("value")) {
                    Object val = m1.get("value");
                    if (val.getClass().isArray()) {
                        val = CollectionUtils.toList(val);
                    }
                    if (val instanceof List) {
                        List l = (List)val;
                        for (Object o1 : l) {
                            if (o1 instanceof String) {
                                result.add((String)o1);
                                continue;
                            }
                            if (!(o1 instanceof Pattern)) continue;
                            result.add(((Pattern)o1).pattern());
                        }
                    } else if (val instanceof String) {
                        result.add(val.toString());
                    } else if (val instanceof Pattern) {
                        result.add(((Pattern)val).pattern());
                    }
                }
            }

            private String humanizeRegex(String regex) {
                regex = Strings.literalReplaceAll((String)"[^\\/]*?", (String)"*", (String)regex);
                regex = Strings.literalReplaceAll((String)"[^\\/]+", (String)"*", (String)regex);
                regex = Strings.literalReplaceAll((String)"[^\\/]+?", (String)"*", (String)regex);
                if ((regex = Strings.literalReplaceAll((String)"[^\\/]*", (String)"*", (String)regex)).startsWith("^\\/")) {
                    regex = regex.substring(3);
                }
                if (regex.startsWith("^") && regex.length() > 1) {
                    regex = "/" + regex.substring(1);
                }
                if ((regex = Strings.literalReplaceAll((String)"[a-fA-F0-9]{24}", (String)("308139abd9ec0c8a650e83" + Strings.toPaddedHex((byte[])new byte[]{(byte)this.counter++})), (String)regex)).endsWith("$")) {
                    regex = regex.substring(0, regex.length() - 1);
                }
                regex = Strings.literalReplaceAll((String)".*?", (String)"*", (String)regex);
                regex = Strings.literalReplaceAll((String)".*", (String)"*", (String)regex);
                regex = Strings.literalReplaceAll((String)".+", (String)"*", (String)regex);
                regex = Strings.literalReplaceAll((String)".+?", (String)"*", (String)regex);
                regex = Strings.literalReplaceAll((String)"\\/", (String)"/", (String)regex);
                return regex;
            }

            private List<String> findPaths(Object o) {
                ArrayList<String> result = new ArrayList<String>(4);
                if (o instanceof Map) {
                    Map m = (Map)o;
                    Object path = m.get("Path");
                    if (path != null) {
                        this.findPaths(path, result);
                    }
                    if (result.isEmpty()) {
                        path = m.get("PathRegex");
                        if (path != null) {
                            this.findPaths(path, result);
                        }
                        if (!result.isEmpty()) {
                            for (int i = 0; i < result.size(); ++i) {
                                result.set(i, this.humanizeRegex((String)result.get(i)) + "&nbsp;&nbsp;<i>(generated from regular expression)</i>");
                            }
                        }
                    }
                }
                Collections.sort(result, (a, b) -> 0);
                return result;
            }

            @Override
            public ResponseWriter.Status write(Event<?> evt, ResponseWriter.Output out, int iteration) throws Exception {
                try {
                    Map<String, Object> help = this.app.describeYourself();
                    if (this.html) {
                        IndexBuilder index = new IndexBuilder();
                        StringBuilder sb = new StringBuilder("<!doctype html>\n<html>\n\t<head>\n\t\t<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n<link href=\"https://fonts.googleapis.com/css?family=Mukta+Malar\" rel=\"stylesheet\">\n\t\t<style>\n\t\t\tbody {\n\t\t\t\tfont-family: 'Mukta Malar'; color:#4e4e5e; margin: 2em;\n\t\t\t}\n .arrayElement { border-right: 2px solid #ccc; font-size: 0.9em;}.arrayElement:last-of-type { border-right: none; }\ntable { font-size: 0.875em; border-spacing: 0; padding: 0; margin: 0; }\ntable table { border-spacing: 0; padding: 0; margin: 0; }\n.singleValue { background-color: #ffe; border-bottom: 1px #bbb solid; border-right: 1px #bbb solid; }\ntd { border: none; padding-left: 1em; padding-right: 1em; }\nth { border: none; padding-left: 1em; padding-right: 1em; }\n.maptitle { background-color: #ccd; border-bottom: 1px #bbb; padding-left: 1em; }\n.mapvalue { border-bottom: 1px #bbb; padding: 0; }\n.title { min-width: 12rem; background-color: #dde; padding-left: 1em; padding-right: 1em; text-transform: capitalize}\n.title,.maptitle { min-width: 12rem; border-bottom: 1px #bbb solid; color: black; }\n.sample { display: block; max-width: 80%; overflow: auto; word-wrap: break-word; overflow-wrap: break-word }\n.sample pre { word-wrap: break-word; overflow-wrap: break-word; white-space: pre-wrap; }\n.value { padding-bottom: 1em;\n    display: inline-block;\n    min-height: 100%;\n    vertical-align: middle;\n    height: 100%;\n    line-height: 1em;\n    padding-top: 1em; }</style>\n\t\t<title>").append(this.app.getName()).append(" API Help</title>\n\t\t</head>\n<body>\n\t\t<h1><a name='top'>").append(this.app.getName()).append(" API Help</a></h1>\n");
                        Description des = this.app.getClass().getAnnotation(Description.class);
                        int offset = sb.length();
                        if (des != null) {
                            sb.append("<p>").append(des.value()).append("</p>\n");
                        }
                        sb.append("\t\t<p><i style='font-size: 0.85em;'>Note that URL matching expressions are relative to the application base path, which can be set by passing <code>--basepath $PATH</code> on the command-line or set in a properties file.</i></p>\n");
                        ArrayList<Map.Entry<String, Object>> sorted = new ArrayList<Map.Entry<String, Object>>(help.entrySet());
                        Collections.sort(sorted, (a, b) -> {
                            String bcat;
                            String acat = this.findCategory(a.getValue());
                            int result = acat.compareTo(bcat = this.findCategory(b.getValue()));
                            if (result == 0) {
                                result = ((String)a.getKey()).compareTo((String)b.getKey());
                            }
                            return result;
                        });
                        String topLink = "<a style='display: inline-block; margin-left: 2em; line-height: 0.9rem; vertical-align: middle; text-align: right; font-size: 0.9rem;' href='#top'>[Top]</a>";
                        String lastCategory = "";
                        Iterator it = sorted.iterator();
                        while (it.hasNext()) {
                            Map.Entry e = (Map.Entry)it.next();
                            String category = this.findCategory(e.getValue());
                            index.add(category, (String)e.getKey());
                            if (!lastCategory.equals(category)) {
                                sb.append("<h1><a name='cat-").append(this.namify(category)).append("'>").append(category).append(" Category</a>").append("</h1>\n");
                            }
                            lastCategory = category;
                            sb.append("<a name='").append(this.namify((String)e.getKey())).append("'>");
                            sb.append("<h2>").append(this.deBicapitalize((String)e.getKey())).append(topLink).append("</h2>").append("</a>\n");
                            if (e.getValue() instanceof Map) {
                                Object sampleOutput;
                                String wd;
                                Object sampleUrl;
                                Object examples;
                                List<String> paths;
                                Map m = (Map)e.getValue();
                                Object methods = m.get("Methods");
                                if (methods != null && methods instanceof Map) {
                                    Object val = ((Map)methods).get("value");
                                    if (val != null) {
                                        methods = val.getClass().isArray() ? Strings.join((String)"/", (Iterable)CollectionUtils.toList(val)) : val.toString();
                                    }
                                    m.remove("Match Method");
                                }
                                if (!(paths = this.findPaths(e.getValue())).isEmpty()) {
                                    m.remove("Match Path (exact)");
                                    m.remove("Match Path (regex)");
                                }
                                Object description = m.get("Description");
                                Map desc = null;
                                sb.append("<p><i style='font-size:0.85em'>").append(category).append(" category</i></p>\n");
                                if (description != null && description instanceof Map) {
                                    desc = (Map)description;
                                    Object val = desc.get("value");
                                    if (val != null) {
                                        sb.append("<p>").append(val).append("</p>\n");
                                    }
                                    m.remove("Description");
                                }
                                if ((examples = m.get("Examples")) != null && examples instanceof Map) {
                                    Map exs = (Map)examples;
                                    ArrayList keys = new ArrayList(exs.keySet());
                                    Collections.sort(keys);
                                    int ix = 1;
                                    for (String key : keys) {
                                        String su;
                                        String so;
                                        String si;
                                        String d;
                                        Object o = exs.get(key);
                                        if (!(o instanceof Map)) continue;
                                        Map ex = (Map)o;
                                        String title = (String)ex.get("title");
                                        if (title != null && !title.isEmpty()) {
                                            sb.append("<h3>").append("Use-Case ").append(ix++).append(": ").append(title).append("</h3>\n");
                                        }
                                        if ((d = (String)ex.get("description")) != null) {
                                            sb.append("<p>").append(d).append("</p>\n");
                                        }
                                        if ((si = (String)ex.get("Sample Input")) != null) {
                                            sb.append("<b>Sample Input</b>:\n<div class='sample'>\n").append(si).append("</div>\n");
                                        }
                                        if ((so = (String)ex.get("Sample Output")) != null) {
                                            sb.append("<b>Sample Output</b>:\n<div class='sample'>\n").append(so).append("\n</div>\n");
                                        }
                                        if ((su = (String)ex.get("Sample URL")) == null) continue;
                                        sb.append("<p><b>Example:</b><code>");
                                        if (methods != null) {
                                            sb.append(methods).append(' ');
                                        }
                                        sb.append(su).append("</code></p>");
                                    }
                                    m.remove("Examples");
                                }
                                if ((sampleUrl = m.get("Sample URL")) != null) {
                                    sb.append("<p><b>Example:</b> <code>");
                                    if (methods != null) {
                                        sb.append(methods).append(' ');
                                    }
                                    sb.append(sampleUrl).append("</code></p>");
                                    m.remove("Sample URL");
                                } else if (methods != null) {
                                    if (!paths.isEmpty()) {
                                        wd = paths.size() == 1 ? "<p><b>Example:</b> " : "<p><b>Examples:</b><br><ul>";
                                        sb.append(wd);
                                        for (String pth : paths) {
                                            sb.append("<li><code>").append(methods).append(" ").append(pth).append("</code></li>\n");
                                        }
                                        if (paths.size() > 1) {
                                            sb.append("</ul>");
                                        }
                                        sb.append("</p>");
                                    } else {
                                        sb.append("<p><b>Methods:</b><code> ").append(methods).append("</code></p>");
                                    }
                                } else if (!paths.isEmpty()) {
                                    wd = paths.size() == 1 ? "<p><b>Example:</b> " : "<p><b>Examples:</b><br>";
                                    sb.append(wd);
                                    for (String pth : paths) {
                                        sb.append("&nbsp;").append("<code>").append(pth).append("</code>\n");
                                    }
                                    sb.append("</p>");
                                }
                                Object sampleInput = m.get("Sample Input");
                                if (sampleInput != null) {
                                    sb.append("<h4>Sample Input</h4>\n<blockquote class='sample'>\n");
                                    sb.append(sampleInput);
                                    sb.append("\n</blockquote>\n");
                                    m.remove("Sample Input");
                                }
                                if ((sampleOutput = m.get("Sample Output")) != null) {
                                    sb.append("<h4>Sample Output</h4>\n<blockquote class='sample'>\n");
                                    sb.append(sampleOutput);
                                    sb.append("\n</blockquote>\n");
                                    m.remove("Sample Output");
                                }
                            }
                            sb.append("<h4>Request Processing Steps</h4>\n");
                            this.writeOut(null, e.getValue(), sb, null, 1);
                            if (!it.hasNext()) continue;
                            sb.append("\n<hr/>\n");
                        }
                        sb.append("</body></html>\n");
                        sb.insert(offset, index.toString());
                        out.write(sb.toString());
                        return ResponseWriter.Status.DONE;
                    }
                    out.writeObject(help);
                    return ResponseWriter.Status.DONE;
                }
                catch (Exception ex) {
                    this.app.control().internalOnError(ex);
                    return ResponseWriter.Status.DONE;
                }
            }

            private String deBicapitalize(String s) {
                if (s == null) {
                    return null;
                }
                s = this.stripNamingConventions(s);
                StringBuilder sb = new StringBuilder();
                boolean lastWasCaps = true;
                for (char c : s.toCharArray()) {
                    if (Character.isUpperCase(c)) {
                        if (!lastWasCaps) {
                            sb.append(' ');
                        }
                        lastWasCaps = true;
                    } else {
                        lastWasCaps = false;
                    }
                    sb.append(c);
                }
                return sb.toString();
            }

            private boolean isIgnorable(String key, Object object) {
                if (key != null && key.equals(object)) {
                    return true;
                }
                if ("Category".equalsIgnoreCase(key) && "Web-API".equals(object)) {
                    return true;
                }
                if ("AuthenticationActeur".equalsIgnoreCase(key)) {
                    return true;
                }
                return "value".equalsIgnoreCase(key) && "default".equals(object);
            }

            private Object filterObject(Object object) {
                Map m;
                Set s;
                if (object instanceof Map && (s = CollectionUtils.transform((m = (Map)object).entrySet(), e -> {
                    if (this.isIgnorable((String)e.getKey(), e.getValue())) {
                        return null;
                    }
                    return e;
                })).size() == 1) {
                    return ((Map.Entry)s.iterator().next()).getValue();
                }
                return object;
            }

            StringBuilder maybeAppendValueClass(boolean yes, StringBuilder sb) {
                if (yes) {
                    sb.append(" singleValue");
                }
                return sb;
            }

            private StringBuilder writeOut(String key, Object object, StringBuilder sb, String parentKey, int depth) {
                boolean code;
                boolean bl = code = ("PathRegex".equals(parentKey) || "Path".equals(parentKey) || "Methods".equals(parentKey)) && "value".equals(key) || object instanceof Class || "type".equalsIgnoreCase(parentKey);
                if (this.isIgnorable(key, object)) {
                    return sb;
                }
                object = this.filterObject(object);
                boolean isValue = "Value".equalsIgnoreCase(key);
                String codeOpen = code ? "<code>" : "";
                String codeClose = code ? "</code>" : "";
                String humanized = this.deBicapitalize(key);
                if (key == null || object instanceof Map) {
                    Map<String, Object> m = Collections.checkedMap((Map)object, String.class, Object.class);
                    if (key != null) {
                        sb.append("\n<tr class='maprow r").append(depth).append("'>\n<th valign=\"left\" class='maptitle title" + depth + "'>\n").append(humanized).append("\n</th>\n<td class='mapvalue val").append(depth).append("'>\n");
                    }
                    sb.append("\n<table class='map t").append(depth).append("'>\n");
                    LinkedList<String> sortedKeys = new LinkedList<String>(m.keySet());
                    Collections.sort(sortedKeys);
                    for (String k : sortedKeys) {
                        Object val = m.get(k);
                        sb.append(codeOpen);
                        this.writeOut(k, val, sb, key, depth + 1);
                        sb.append(codeClose);
                    }
                    sb.append("\n</table>\n");
                    if (key != null) {
                        sb.append("\n</td>\n</tr>\n");
                    }
                } else if (object instanceof CharSequence || object instanceof Boolean || object instanceof Number || object instanceof Enum) {
                    sb.append("\n<tr>\n");
                    if (!isValue) {
                        sb.append("\n<th class='title title").append(depth).append("'>\n").append(humanized).append("\n</th>\n");
                    }
                    sb.append("<td class='value val").append(depth);
                    this.maybeAppendValueClass(isValue, sb).append("'>\n").append(codeOpen).append(object).append(codeClose).append("\n</td>\n</tr>\n");
                } else if (object != null && (object.getClass().isArray() || object instanceof List)) {
                    List l;
                    List list = l = object instanceof List ? (List)object : CollectionUtils.toList((Object)object);
                    if (l.size() == 1) {
                        sb.append("\n<tr>\n");
                        if (!isValue) {
                            sb.append("<th class='title title").append(depth).append("'>\n").append(humanized).append("\n</th>\n");
                        }
                        sb.append("\n<td class='value val").append(depth);
                        this.maybeAppendValueClass(isValue, sb).append("'>\n").append(codeOpen).append(this.toString(l.get(0))).append(codeClose).append("\n</td>\n</tr>\n");
                    } else {
                        StringBuilder elems = new StringBuilder("\n<table class='ta tad" + depth + "'>\n<tr>\n");
                        for (Object o : l) {
                            elems.append("\n<td class='arrayElement value val").append(depth).append("'>\n").append(codeOpen).append(this.toString(o)).append(codeClose).append("\n</td>\n");
                        }
                        elems.append("</table>");
                        sb.append("\n<tr>\n");
                        if (!isValue) {
                            sb.append("<th class='title title").append(depth);
                            this.maybeAppendValueClass(isValue, sb).append("'>\n").append(humanized).append("\n</th>");
                        }
                        sb.append("\n<td class='value val").append(depth);
                        this.maybeAppendValueClass(isValue, sb).append("'>\n").append((CharSequence)elems).append("\n</td>\n</tr>\n");
                    }
                } else if (object instanceof Class) {
                    String nm = ((Class)object).getSimpleName();
                    if (((Class)object).isArray()) {
                        nm = nm + "[]";
                    }
                    sb.append("\n<tr>\n");
                    if (!isValue) {
                        sb.append("<th class='title title").append(depth).append("'>\n").append(humanized).append("\n</th>\n");
                    }
                    sb.append("<td class='value val").append(depth);
                    this.maybeAppendValueClass(isValue, sb).append("'>\n").append(codeOpen).append(nm).append(codeClose).append("\n</td>\n</tr>\n");
                } else {
                    sb.append("\n<tr>\n");
                    if (!isValue) {
                        sb.append("<th class='title title").append(depth).append("'>\n").append(humanized).append("\n</th>");
                    }
                    sb.append("\n<td class='value val").append(depth);
                    this.maybeAppendValueClass(isValue, sb).append("'>\n").append(codeOpen).append(object).append(codeClose).append("\n</td>\n</tr>\n");
                }
                return sb;
            }

            private String toString(Object o) {
                if (o.getClass().isArray()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.toString(Array.get(o, i)));
                    }
                    return sb.toString();
                }
                return Objects.toString(o);
            }

            final class IndexBuilder {
                private final Map<String, LinkedList<String>> itemsForCategory = CollectionUtils.supplierMap(LinkedList::new);

                IndexBuilder() {
                }

                void add(String category, String name) {
                    this.itemsForCategory.get(category).add(name);
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    ArrayList<String> categories = new ArrayList<String>(this.itemsForCategory.keySet());
                    Collections.sort(categories);
                    for (String category : categories) {
                        List items = this.itemsForCategory.get(category);
                        Collections.sort(items);
                        sb.append("<h3><a style='text-decoration: none' href='#").append("cat-").append(HelpWriter.this.namify(category)).append("'>").append(category).append("</a></h3>\n");
                        sb.append("<ol>\n");
                        for (String item : items) {
                            String nm = HelpWriter.this.stripNamingConventions(item);
                            sb.append("<li><a style='text-decoration: none' href='#").append(HelpWriter.this.namify(item)).append("'>").append(HelpWriter.this.deBicapitalize(nm)).append("</a></li>\n");
                        }
                        sb.append("</ol>\n");
                    }
                    return sb.toString();
                }
            }
        }
    }
}

