/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.request.HttpProtocolRequest;
import com.mastfrog.acteur.util.HttpMethod;
import com.mastfrog.url.Path;
import com.mastfrog.util.preconditions.Exceptions;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface HttpEvent
extends Event<HttpRequest>,
HttpProtocolRequest {
    public HttpMethod method();

    public String header(CharSequence var1);

    public String urlParameter(String var1);

    public Path path();

    public <T> T header(HeaderValueType<T> var1);

    public <T> List<T> headers(HeaderValueType<T> var1);

    public Map<CharSequence, CharSequence> headersAsMap();

    public Map<String, String> urlParametersAsMap();

    public <T> T urlParametersAs(Class<T> var1);

    @Deprecated
    public Optional<Integer> intUrlParameter(String var1);

    @Deprecated
    public Optional<Long> longUrlParameter(String var1);

    public String stringContent() throws IOException;

    public boolean requestsConnectionStayOpen();

    public boolean isSsl();

    public String getRequestURL(boolean var1);

    default public boolean isPreContent() {
        return false;
    }

    default public String decodedUrlParameter(String name) {
        return this.urlParameter(name, true);
    }

    default public String urlParameter(String name, boolean decode) {
        String result = this.urlParameter(name);
        if (decode && result != null) {
            try {
                result = URLDecoder.decode(result, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                return (String)Exceptions.chuck((Throwable)ex);
            }
        }
        return result;
    }

    @Deprecated
    default public HttpMethod getMethod() {
        return this.method();
    }

    @Deprecated
    default public String getHeader(CharSequence nm) {
        return this.header(nm);
    }

    @Deprecated
    default public String getParameter(String param) {
        return this.urlParameter(param);
    }

    @Deprecated
    default public Path getPath() {
        return this.path();
    }

    @Deprecated
    default public <T> T getHeader(HeaderValueType<T> value) {
        return this.header(value);
    }

    @Deprecated
    default public <T> List<T> getHeaders(HeaderValueType<T> headerType) {
        return this.headers(headerType);
    }

    @Deprecated
    default public Map<CharSequence, CharSequence> getHeadersAsMap() {
        return this.headersAsMap();
    }

    @Deprecated
    default public Map<String, String> getParametersAsMap() {
        return this.urlParametersAsMap();
    }

    @Deprecated
    default public <T> T getParametersAs(Class<T> type) {
        return this.urlParametersAs(type);
    }

    @Deprecated
    default public Optional<Integer> getIntParameter(String name) {
        return this.intUrlParameter(name);
    }

    @Deprecated
    default public Optional<Long> getLongParameter(String name) {
        return this.longUrlParameter(name);
    }

    @Deprecated
    default public String getContentAsString() throws IOException {
        return this.stringContent();
    }

    @Deprecated
    default public boolean isKeepAlive() {
        return this.requestsConnectionStayOpen();
    }
}

