/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.common.collect.Sets;
import com.google.inject.ImplementedBy;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.ActeurFactory;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.CORSResource;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.preconditions.Description;
import com.mastfrog.acteur.preconditions.PageAnnotationHandler;
import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.function.threadlocal.ThreadLocalValue;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Page {
    private static final ThreadLocalValue<Page> CURRENT_PAGE = ThreadLocalValue.create();
    private final List<Object> acteurs = new ArrayList<Object>(10);
    volatile Application application;
    private static final Set<Class<?>> CHECKED = Sets.newIdentityHashSet();
    private static final Set<Class<?>> FAILED = Sets.newIdentityHashSet();

    protected Page() {
    }

    public final void add(Acteur action) {
        this.acteurs.add((Object)action);
    }

    protected String getDescription() {
        Description desc = this.getClass().getAnnotation(Description.class);
        return desc != null ? desc.value() : this.getClass().getSimpleName();
    }

    Set<PathPatternInfo> findPathPatterns() {
        HashSet<PathPatternInfo> result = null;
        for (Object o : this.acteurs) {
            boolean decode;
            if (o instanceof ActeurFactory.ExactMatchPath) {
                String path = ((ActeurFactory.ExactMatchPath)((Object)o)).path;
                decode = ((ActeurFactory.ExactMatchPath)((Object)o)).decode;
                if (result == null) {
                    result = new HashSet<PathPatternInfo>();
                }
                result.add(new PathPatternInfo(decode, false, Collections.singleton(path), true));
                continue;
            }
            if (!(o instanceof ActeurFactory.MatchPath)) continue;
            Set patterns = CollectionUtils.setOf((Object[])((ActeurFactory.MatchPath)((Object)o)).regexen);
            decode = ((ActeurFactory.MatchPath)((Object)o)).decode;
            if (result == null) {
                result = new HashSet();
            }
            result.add(new PathPatternInfo(decode, false, patterns, false));
        }
        return result;
    }

    Set<Method> findMethods() {
        for (Object o : this.acteurs) {
            if (!(o instanceof ActeurFactory.MatchMethods)) continue;
            return CollectionUtils.setOf((Object[])((ActeurFactory.MatchMethods)((Object)o)).methods());
        }
        return null;
    }

    void describeYourself(Map<String, Object> into) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (this.getClass().getAnnotation(Description.class) != null) {
            m.put("description", this.getClass().getAnnotation(Description.class).value());
        }
        List<Object> acteurs = this.acteurs(this.application.isDefaultCorsHandlingEnabled());
        for (Object o : acteurs) {
            try {
                Acteur a = o instanceof Acteur ? (Acteur)((Object)o) : (Acteur)((Object)this.application.getDependencies().getInstance((Class)o));
                a.describeYourself(m);
            }
            catch (Exception exception) {}
        }
        if (!m.isEmpty()) {
            into.put(this.getClass().getSimpleName(), m);
        }
    }

    static QuietAutoClosable set(Page page) {
        Checks.notNull((String)"page", (Object)page);
        QuietAutoClosable result = CURRENT_PAGE.setTo((Object)page);
        assert (CURRENT_PAGE.get() != null);
        return result;
    }

    static Page get() {
        return (Page)CURRENT_PAGE.get();
    }

    static void clear() {
        CURRENT_PAGE.clear();
    }

    protected final void add(Class<? extends Acteur> action) {
        if (!CHECKED.contains(Checks.notNull((String)"acteur", action))) {
            CHECKED.add(action);
            if ((action.getModifiers() & 0x400) != 0 && action.getAnnotation(ImplementedBy.class) == null) {
                FAILED.add(action);
                throw new IllegalArgumentException(action + " is abstract");
            }
            if (action.isLocalClass()) {
                FAILED.add(action);
                throw new IllegalArgumentException(action + " is not a top-level class");
            }
            if (!Acteur.class.isAssignableFrom(action)) {
                FAILED.add(action);
                throw new IllegalArgumentException(action + " is not a subclass of " + Acteur.class.getName());
            }
            assert (Application.checkConstructor(action));
        }
        if (FAILED.contains(action)) {
            throw new IllegalArgumentException("Not a usable acteur class - " + action + " see previous error");
        }
        this.acteurs.add(action);
    }

    final Application getApplication() {
        return this.application;
    }

    final void setApplication(Application app) {
        this.application = app;
    }

    final int countActeurs() {
        return this.acteurs.size();
    }

    List<Object> acteurs(boolean corsByDefault) {
        List<Acteur> annos = this.annotations();
        ArrayList<Object> l = new ArrayList<Object>(annos.size() + this.acteurs.size() + (corsByDefault ? 1 : 0));
        l.addAll(this.annotations());
        if (corsByDefault) {
            l.add(CORSResource.CorsHeaders.class);
        }
        l.addAll(this.acteurs);
        return l;
    }

    private List<Acteur> annotations() {
        PageAnnotationHandler.Registry handler = (PageAnnotationHandler.Registry)this.getApplication().getDependencies().getInstance(PageAnnotationHandler.Registry.class);
        LinkedList<Acteur> results = new LinkedList<Acteur>();
        handler.processAnnotations(this, results);
        return results;
    }

    static class PathPatternInfo {
        final boolean decode;
        final boolean regex;
        final boolean knownExact;
        final Set<String> patterns;

        public PathPatternInfo(boolean decode, boolean regex, Set<String> patterns, boolean knownExact) {
            this.decode = decode;
            this.regex = regex;
            this.patterns = patterns;
            this.knownExact = knownExact;
        }
    }
}

