/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.common.collect.Sets;
import com.mastfrog.acteur.HelpPage;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.PathPatterns;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.preconditions.Methods;
import com.mastfrog.acteur.preconditions.Path;
import com.mastfrog.acteur.preconditions.PathRegex;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.strings.AlignedText;
import com.mastfrog.util.strings.Strings;
import io.netty.handler.codec.http.HttpRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

final class PagePathAndMethodFilter {
    private final PathPatterns pp = new PathPatterns();
    private final Map<Method, ByMethod> all = new EnumMap<Method, ByMethod>(Method.class);
    private final Set<MethodPath> matchesCache = Sets.newConcurrentHashSet();
    private final Set<MethodPath> nonMatchesCache = Sets.newConcurrentHashSet();
    private final List<Object> unknowns = new ArrayList<Object>(5);
    static final boolean DEBUG = Boolean.getBoolean("path.cache.debug");
    private final Function<String, String> basePathFilter;

    PagePathAndMethodFilter(Function<String, String> basePathFilter) {
        this.basePathFilter = basePathFilter;
    }

    PagePathAndMethodFilter() {
        this.basePathFilter = new IdentityFunction();
    }

    PagePathAndMethodFilter(String basePath) {
        this(PagePathAndMethodFilter.filterForBasePath(basePath));
    }

    private static final Function<String, String> filterForBasePath(String basePath) {
        if (basePath == null || basePath.isEmpty() || "/".equals(basePath.trim())) {
            return new IdentityFunction();
        }
        return DEBUG ? new DebugBasePathFilterFunction(new BasePathFilterFunction(basePath)) : new BasePathFilterFunction(basePath);
    }

    boolean isEmpty() {
        return this.all.isEmpty() && this.unknowns.isEmpty();
    }

    public String toString() {
        ArrayList<Method> mths = new ArrayList<Method>(this.all.keySet());
        Collections.sort(mths, (o1, o2) -> o1.name().compareTo(o2.name()));
        StringBuilder sb = new StringBuilder();
        for (Method m : mths) {
            String s;
            ByMethod by = this.all.get(m);
            for (Map.Entry e : by.pageForExacts.entrySet()) {
                sb.append('\n').append(m.name()).append('\t');
                sb.append((String)e.getKey()).append('\t');
                sb.append(by.decodeExacts.contains(e.getKey())).append('\t');
                for (Object o : (List)e.getValue()) {
                    if (o instanceof Class) {
                        sb.append(((Class)o).getSimpleName()).append('\n');
                        continue;
                    }
                    s = o.getClass().getSimpleName();
                    sb.append(s).append('\t');
                }
            }
            for (Map.Entry e : by.pagePatterns.entrySet()) {
                sb.append('\n').append(m.name()).append('\t');
                sb.append(((Pattern)e.getKey()).pattern()).append('\t');
                sb.append(by.decodePatterns.contains(e.getKey())).append('\t');
                for (Object o : (List)e.getValue()) {
                    if (o instanceof Class) {
                        sb.append(((Class)o).getSimpleName()).append('\n');
                        continue;
                    }
                    s = o.getClass().getSimpleName();
                    sb.append(s).append('\t');
                }
            }
        }
        for (Object o : this.unknowns) {
            sb.append('\n').append('*').append('\t').append('*').append('\t').append('?').append('\t');
            sb.append(o instanceof Class ? ((Class)o).getSimpleName() : o.getClass().getSimpleName());
        }
        sb.append('\n');
        return AlignedText.formatTabbed((CharSequence)sb);
    }

    public boolean match(HttpRequest req) {
        String path = this.basePathFilter.apply(req.uri());
        if (path == null) {
            return false;
        }
        path = PagePathAndMethodFilter.trimLeadingAndTrailingSlashes(PagePathAndMethodFilter.trimQuery(path));
        Method method = Method.get((HttpRequest)req);
        MethodPath mp = new MethodPath(method, path);
        if (this.nonMatchesCache.contains(mp)) {
            return false;
        }
        if (this.matchesCache.contains(mp)) {
            return true;
        }
        ByMethod bm = this.all.get(mp.method);
        if (bm == null) {
            this.nonMatchesCache.add(mp);
            return false;
        }
        if (bm.match(mp.path)) {
            this.matchesCache.add(mp);
            return true;
        }
        this.nonMatchesCache.add(mp);
        return false;
    }

    void addHelp(String helpPattern) {
        ByMethod by = this.all.get(Method.GET);
        if (by == null) {
            by = new ByMethod();
            this.all.put(Method.GET, by);
        }
        by.add(HelpPage.class, helpPattern);
    }

    public List<Object> listFor(HttpRequest req) {
        String path = this.basePathFilter.apply(req.uri());
        if (path == null) {
            if (DEBUG) {
                System.out.println("  did not match base path: " + req.method() + " of '" + req.uri() + "' as '" + path + "'");
            }
            return Collections.emptyList();
        }
        path = PagePathAndMethodFilter.trimLeadingAndTrailingSlashes(PagePathAndMethodFilter.trimQuery(path));
        Method method = Method.get((HttpRequest)req);
        MethodPath mp = new MethodPath(method, path);
        List<Object> checkFirst = this.unknowns;
        if (this.nonMatchesCache.contains(mp)) {
            return checkFirst;
        }
        ByMethod bm = this.all.get(mp.method);
        if (bm == null) {
            if (DEBUG) {
                System.out.println("  no ByMethod for " + req.method() + " of '" + req.uri() + "' as '" + path + "'");
            }
            return checkFirst;
        }
        List matches = bm.matchingLists(path);
        matches.add(0, checkFirst);
        List result = CollectionUtils.combinedList((List)matches);
        if (DEBUG) {
            System.out.println("  possible matches for " + req.method() + " of '" + req.uri() + "' as '" + path + "': " + result);
        }
        return result;
    }

    void add(Page page) {
        Class<?> type = page.getClass();
        Methods methods = type.getAnnotation(Methods.class);
        Iterable<Object> mths = null;
        mths = methods != null ? CollectionUtils.toIterable((Object[])methods.value()) : page.findMethods();
        boolean added = false;
        if (mths != null) {
            for (Method method : mths) {
                ByMethod by = this.all.get(method);
                if (by == null) {
                    by = new ByMethod();
                    this.all.put(method, by);
                }
                added |= by.add(type, page);
            }
        }
        if (!added && !this.unknowns.contains(page)) {
            this.unknowns.add(page);
        }
    }

    void add(Class<? extends Page> type) {
        Methods methods = type.getAnnotation(Methods.class);
        boolean added = false;
        if (methods != null) {
            for (Method mth : methods.value()) {
                ByMethod by = this.all.get(mth);
                if (by == null) {
                    by = new ByMethod();
                    this.all.put(mth, by);
                }
                added |= by.add(type);
            }
        }
        if (!added && !this.unknowns.contains(type)) {
            this.unknowns.add(type);
        }
    }

    void addUnknown(Page pg) {
        this.unknowns.add(pg);
    }

    private static String trimLeadingAndTrailingSlashes(String pat) {
        if (pat.length() > 1) {
            if (pat.charAt(0) == '/') {
                pat = pat.substring(1);
            }
            if (pat.length() > 1 && pat.charAt(pat.length() - 1) == '/') {
                pat = pat.substring(0, pat.length() - 1);
            }
        }
        return pat;
    }

    private static String trimQuery(String uri) {
        int ix = uri.indexOf(63);
        if (ix >= 0) {
            uri = uri.substring(0, ix);
        }
        return uri;
    }

    static final class IdentityFunction
    implements Function<String, String> {
        IdentityFunction() {
        }

        @Override
        public String apply(String t) {
            return t;
        }
    }

    static final class DebugBasePathFilterFunction
    implements Function<String, String> {
        private final BasePathFilterFunction f;

        public DebugBasePathFilterFunction(BasePathFilterFunction f) {
            this.f = f;
        }

        @Override
        public String apply(String t) {
            String result = this.f.apply(t);
            System.out.println("URI for '" + t + "' with base path '" + this.f.basePath + "' stripped to: '" + (result == null ? "<null>" : result) + "'");
            return result;
        }
    }

    static final class BasePathFilterFunction
    implements Function<String, String> {
        final String basePath;

        public BasePathFilterFunction(String basePath) {
            this.basePath = '/' + PagePathAndMethodFilter.trimLeadingAndTrailingSlashes(basePath);
        }

        @Override
        public String apply(String t) {
            if (this.basePath.equals(t) || t.length() == this.basePath.length() + 1 && t.charAt(t.length() - 1) == '/') {
                return "";
            }
            if (t.startsWith(this.basePath) && t.charAt(this.basePath.length()) == '/') {
                return t.substring(this.basePath.length() + 1);
            }
            return null;
        }
    }

    private final class ByMethod {
        private final Set<Pattern> patterns = new HashSet<Pattern>();
        private final Set<String> exacts = new HashSet<String>();
        private final Map<String, List<Object>> pageForExacts = new HashMap<String, List<Object>>();
        private final Map<Pattern, List<Object>> pagePatterns = new HashMap<Pattern, List<Object>>();
        private final Set<Pattern> decodePatterns = new HashSet<Pattern>();
        private final Set<String> decodeExacts = new HashSet<String>();

        private ByMethod() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("  exact: ").append(Strings.join((String)", ", this.exacts));
            ArrayList<String> l = new ArrayList<String>();
            for (Pattern p : this.patterns) {
                l.add(p.pattern());
            }
            sb.append("  patns: ").append(Strings.join((String)", ", l));
            return sb.append('\n').toString();
        }

        List<Object> matches(String trimmedUri) {
            return CollectionUtils.combinedList(this.matchingLists(trimmedUri));
        }

        private List<List<Object>> matchingLists(String trimmedUri) {
            ArrayList<List<Object>> res = new ArrayList<List<Object>>(4);
            List<Object> a = this.pageForExacts.get(trimmedUri);
            String decodedUri = null;
            if (a != null) {
                res.add(a);
            } else if (Strings.contains((char)'%', (CharSequence)trimmedUri)) {
                try {
                    decodedUri = URLDecoder.decode(trimmedUri, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    return (List)Exceptions.chuck((Throwable)ex);
                }
                a = this.pageForExacts.get(decodedUri);
                if (a != null) {
                    res.add(a);
                }
            }
            for (Pattern p : this.patterns) {
                List<Object> l;
                boolean isMatch;
                String toTest = trimmedUri;
                if (this.decodePatterns.contains(p)) {
                    if (decodedUri == null) {
                        try {
                            decodedUri = URLDecoder.decode(trimmedUri, "UTF-8");
                        }
                        catch (UnsupportedEncodingException ex) {
                            return (List)Exceptions.chuck((Throwable)ex);
                        }
                    }
                    toTest = decodedUri;
                }
                if (!(isMatch = p.matcher(toTest).matches()) || (l = this.pagePatterns.get(p)) == null) continue;
                res.add(l);
            }
            return res;
        }

        Iterator<Object> allMatching(String trimmedUri) {
            List<List<Object>> res = this.matchingLists(trimmedUri);
            return CollectionUtils.combine((Collection)CollectionUtils.transform(res, l -> l.iterator()));
        }

        boolean match(String trimmedUri) {
            if (this.exacts.contains(trimmedUri)) {
                return true;
            }
            String decodedUri = null;
            if (Strings.contains((char)'%', (CharSequence)trimmedUri) || Strings.contains((char)'+', (CharSequence)trimmedUri)) {
                try {
                    decodedUri = URLDecoder.decode(trimmedUri, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    return (Boolean)Exceptions.chuck((Throwable)ex);
                }
                if (this.exacts.contains(decodedUri)) {
                    return true;
                }
            }
            for (Pattern p : this.patterns) {
                boolean isMatch = p.matcher(trimmedUri).matches();
                if (isMatch) {
                    return true;
                }
                if (decodedUri == null || !(isMatch = p.matcher(decodedUri).matches())) continue;
                return true;
            }
            return false;
        }

        void add(Class<? extends Page> page, String regex) {
            String exact = PagePathAndMethodFilter.this.pp.exactPathForRegex(regex);
            if (exact != null) {
                this.exacts.add(exact);
            } else {
                this.patterns.add(PagePathAndMethodFilter.this.pp.getPattern(regex));
            }
        }

        boolean add(Class<? extends Page> page) {
            return this.add(page, (Page)null);
        }

        boolean add(Class<? extends Page> page, Page instance) {
            PathRegex rx;
            List<Object> l;
            boolean pathFound = false;
            Path pth = page.getAnnotation(Path.class);
            if (pth != null) {
                pathFound = true;
                for (String pat : pth.value()) {
                    List<Object> l2;
                    String pt = PagePathAndMethodFilter.trimLeadingAndTrailingSlashes(pat);
                    if (this.exacts.contains(pt)) {
                        l2 = this.pageForExacts.get(pt);
                        l2.add(page);
                        if (pth.decode()) {
                            this.decodeExacts.add(pt);
                        }
                    }
                    if (PagePathAndMethodFilter.this.pp.isExactGlob(pat)) {
                        this.exacts.add(pt);
                        if (pth.decode()) {
                            this.decodeExacts.add(pt);
                        }
                        if ((l2 = this.pageForExacts.get(pt)) == null) {
                            l2 = new ArrayList<Object>(5);
                            this.pageForExacts.put(pt, l2);
                        }
                        l2.add(instance == null ? page : instance);
                        continue;
                    }
                    Pattern pattern = PagePathAndMethodFilter.this.pp.getPattern(PathPatterns.patternFromGlob(pat));
                    this.patterns.add(pattern);
                    if (pth.decode()) {
                        this.decodePatterns.add(pattern);
                    }
                    if ((l = this.pagePatterns.get(pattern)) == null) {
                        l = new ArrayList<Object>();
                        this.pagePatterns.put(pattern, l);
                    }
                    l.add(instance == null ? page : instance);
                }
            }
            if ((rx = page.getAnnotation(PathRegex.class)) != null) {
                pathFound = true;
                for (String regex : rx.value()) {
                    String exact = PagePathAndMethodFilter.this.pp.exactPathForRegex(regex);
                    if (exact != null) {
                        this.exacts.add(exact);
                        if (rx.decode()) {
                            this.decodeExacts.add(exact);
                        }
                        if ((l = this.pageForExacts.get(exact)) == null) {
                            l = new ArrayList<Object>(5);
                            this.pageForExacts.put(exact, l);
                        }
                        l.add(instance == null ? page : instance);
                        continue;
                    }
                    Pattern pattern = PagePathAndMethodFilter.this.pp.getPattern(regex);
                    this.addPattern(pattern, instance == null ? page : instance, rx.decode());
                }
            }
            if (!pathFound && instance != null) {
                Set<Page.PathPatternInfo> pths = instance.findPathPatterns();
                for (Page.PathPatternInfo ppi : pths) {
                    boolean decode = ppi.decode;
                    if (ppi.knownExact) {
                        for (String pat : ppi.patterns) {
                            this.addExact(pat, instance, decode);
                            pathFound = true;
                        }
                        continue;
                    }
                    for (String pat : ppi.patterns) {
                        String exact = PagePathAndMethodFilter.this.pp.exactPathForRegex(pat);
                        if (exact != null) {
                            pathFound = true;
                            this.addExact(exact, instance, decode);
                            continue;
                        }
                        Pattern pattern = PagePathAndMethodFilter.this.pp.getPattern(pat);
                        this.addPattern(pattern, instance, decode);
                        pathFound = true;
                    }
                }
            }
            return pathFound;
        }

        void addPattern(Pattern pattern, Object instance, boolean decode) {
            List<Object> l;
            this.patterns.add(pattern);
            if (decode) {
                this.decodePatterns.add(pattern);
            }
            if ((l = this.pagePatterns.get(pattern)) == null) {
                l = new ArrayList<Object>();
                this.pagePatterns.put(pattern, l);
            }
            l.add(instance);
        }

        void addExact(String pat, Object instance, boolean decode) {
            List<Object> l;
            this.exacts.add(pat);
            if (decode) {
                this.decodeExacts.add(pat);
            }
            if ((l = this.pageForExacts.get(pat)) == null) {
                l = new ArrayList<Object>(5);
                this.pageForExacts.put(pat, l);
            }
            l.add(instance);
        }
    }

    private static final class MethodPath {
        private final Method method;
        private final String path;
        private int hash;

        MethodPath(Method method, String path) {
            this.method = method;
            this.path = path;
        }

        public int hashCode() {
            if (this.hash != 0) {
                return this.hash;
            }
            this.hash = this.path.hashCode() + 71 * this.method.ordinal();
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof MethodPath && ((MethodPath)obj).method == this.method && ((MethodPath)obj).path.equals(this.path);
        }

        public String toString() {
            return this.method.name() + ":" + this.path;
        }
    }
}

