/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.name.Named;
import com.mastfrog.abstractions.instantiate.Instantiator;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.Closables;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.Response;
import com.mastfrog.acteur.ResponseImpl;
import com.mastfrog.acteur.ResponseSender;
import com.mastfrog.acteur.State;
import com.mastfrog.acteur.errors.ResponseException;
import com.mastfrog.acteur.header.entities.CacheControl;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.server.ServerModule;
import com.mastfrog.acteur.util.RequestID;
import com.mastfrog.acteur.websocket.WebSocketUpgradeActeur;
import com.mastfrog.acteurbase.ActeurState;
import com.mastfrog.acteurbase.ArrayChain;
import com.mastfrog.acteurbase.ChainCallback;
import com.mastfrog.acteurbase.ChainRunner;
import com.mastfrog.acteurbase.ChainsRunner;
import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.giulius.DeploymentMode;
import com.mastfrog.giulius.scope.ReentrantScope;
import com.mastfrog.mime.MimeType;
import com.mastfrog.settings.Settings;
import com.mastfrog.url.Path;
import com.mastfrog.util.collections.ArrayUtils;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.collections.Converter;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.strings.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.AsciiString;
import io.netty.util.Attribute;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.netbeans.validation.api.InvalidInputException;

class PagesImpl2 {
    private static final String SETTINGS_KEY_DISABLE_FILTER = "disable.filter";
    private final Application application;
    private final ScheduledExecutorService scheduler;
    private final ChainsRunner ch;
    private final boolean debug;
    private final boolean disableFilterPathsAndMethods;
    private final boolean renderStackTraces;
    private final boolean httpCompressorEnabled;
    static final HeaderValueType<CharSequence> X_BODY_GENERATOR = Headers.header((CharSequence)new AsciiString((CharSequence)"X-Body-Generator"));

    @Inject
    PagesImpl2(Application application, Settings settings, @Named(value="delayExecutor") ScheduledExecutorService scheduler, DeploymentMode mode, ReentrantScope scope, @Named(value="background") ExecutorService exe) {
        this.application = application;
        this.scheduler = scheduler;
        this.disableFilterPathsAndMethods = settings.getBoolean(SETTINGS_KEY_DISABLE_FILTER, false);
        this.renderStackTraces = settings.getBoolean("render.stack.traces", !mode.isProduction());
        this.debug = settings.getBoolean("acteur.debug", false);
        this.httpCompressorEnabled = settings.getBoolean("httpCompression", true);
        ChainRunner chr = new ChainRunner(exe, scope);
        this.ch = new ChainsRunner(exe, scope, chr);
    }

    private boolean canPostponeFlush(Event<?> evt, ResponseImpl response) {
        if (response.hasNoPayload()) {
            return false;
        }
        if (!(evt instanceof HttpEvent)) {
            return false;
        }
        HttpEvent httpEvent = (HttpEvent)evt;
        if (response.get(ServerModule.X_INTERNAL_COMPRESS_HEADER) != null) {
            return true;
        }
        if (this.httpCompressorEnabled) {
            CharSequence contentEncoding = (CharSequence)response.get(Headers.CONTENT_ENCODING);
            if (contentEncoding != null && (HttpHeaderValues.IDENTITY == contentEncoding || HttpHeaderValues.IDENTITY.contentEquals(contentEncoding))) {
                return true;
            }
            CharSequence seq = (CharSequence)httpEvent.header(Headers.ACCEPT_ENCODING);
            if (seq != null) {
                if (seq == HttpHeaderValues.GZIP_DEFLATE || seq == HttpHeaderValues.GZIP || seq == HttpHeaderValues.DEFLATE) {
                    return false;
                }
                if (Strings.charSequenceContains((CharSequence)seq, (CharSequence)HttpHeaderValues.GZIP, (boolean)this.debug)) {
                    return false;
                }
                if (Strings.charSequenceContains((CharSequence)seq, (CharSequence)HttpHeaderValues.DEFLATE, (boolean)this.debug)) {
                    return false;
                }
            }
        }
        return true;
    }

    public CountDownLatch onEvent(RequestID id, Event<?> event, Channel channel, Object[] defaultContext) {
        Set<PageChain> pagesIterable;
        CountDownLatch latch = new CountDownLatch(1);
        Closables clos = null;
        if (event.request() instanceof WebSocketFrame) {
            Attribute s = channel.attr(WebSocketUpgradeActeur.CHAIN_KEY);
            Supplier chainSupplier = (Supplier)s.get();
            if (chainSupplier == null) {
                throw new IllegalStateException("Got a WebSocketFrame on a channel with no websocket chain set up");
            }
            PageChain pageChain = (PageChain)((Object)chainSupplier.get());
            clos = pageChain.findInContext(Closables.class);
            if (clos == null) {
                clos = new Closables(channel, this.application.control());
            }
            pageChain.addToContext(event);
            pageChain.page = (Page)channel.attr(WebSocketUpgradeActeur.PAGE_KEY).get();
            this.application.probe.onBeforeRunPage(id, event, pageChain.page);
            pagesIterable = Collections.singleton(pageChain);
        } else {
            Iterator<Page> pageIterator;
            boolean early;
            clos = new Closables(channel, this.application.control());
            ChainToPageConverter chainConverter = new ChainToPageConverter(id, event, clos);
            boolean bl = early = event instanceof HttpEvent && ((HttpEvent)event).isPreContent();
            Iterator<Page> iterator = this.disableFilterPathsAndMethods ? (early ? this.application.earlyPagesIterator() : this.application.iterator()) : (pageIterator = early ? this.application.earlyPagesIterator((HttpEvent)event) : this.application.iterator((HttpEvent)event));
            if (defaultContext != null && defaultContext.length > 0) {
                pageIterator = new ScopeWrapIterator<Page>(this.application.getRequestScope(), pageIterator, defaultContext);
            }
            pagesIterable = CollectionUtils.toIterable((Iterator)CollectionUtils.convertedIterator((Converter)chainConverter, pageIterator));
        }
        CB callback = new CB(id, event, latch, channel, clos);
        CancelOnChannelClose closer = new CancelOnChannelClose();
        channel.closeFuture().addListener((GenericFutureListener)closer);
        this.ch.submit(pagesIterable, (ChainCallback)callback, closer.cancelled, new Object[]{id, event, clos});
        return latch;
    }

    static class PageChain
    extends ArrayChain<Acteur, PageChain> {
        private Page page;
        private Object[] ctx;
        private final AtomicBoolean first = new AtomicBoolean(true);
        private final ReentrantScope scope;
        private static final Object[] EMPTY = new Object[0];
        boolean isReconstituted;
        private Application app;

        PageChain(Application app, Instantiator deps, ReentrantScope scope, Class<? super Acteur> type, Page page, Object ... ctx) {
            super(deps, type, page.acteurs(app.isDefaultCorsHandlingEnabled()));
            this.page = page;
            this.ctx = ctx;
            this.scope = scope;
            this.app = app;
        }

        PageChain(Application app, Instantiator deps, ReentrantScope scope, Class<? super Acteur> type, List<Object> pages, Object[] ctx) {
            super(deps, type, pages);
            this.isReconstituted = true;
            this.scope = scope;
            this.ctx = ctx;
            this.page = null;
            this.app = app;
        }

        public <T> T findInContext(Class<T> type) {
            if (this.ctx != null) {
                for (int i = this.ctx.length - 1; i >= 0; --i) {
                    if (!type.isInstance(this.ctx[i])) continue;
                    return type.cast(this.ctx[i]);
                }
            }
            return null;
        }

        public Iterator<Acteur> iterator() {
            Iterator orig;
            Iterator result = orig = super.iterator();
            if (this.isReconstituted) {
                result = new Iterator<Acteur>(){

                    @Override
                    public boolean hasNext() {
                        return orig.hasNext();
                    }

                    @Override
                    public Acteur next() {
                        try (QuietAutoClosable cl1 = scope.enter(ctx);){
                            Acteur acteur;
                            block12: {
                                QuietAutoClosable cl = Page.set(page);
                                try {
                                    acteur = (Acteur)((Object)orig.next());
                                    if (cl == null) break block12;
                                }
                                catch (Throwable throwable) {
                                    if (cl != null) {
                                        try {
                                            cl.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                cl.close();
                            }
                            return acteur;
                        }
                    }
                };
            }
            return result;
        }

        public Object[] getContextContribution() {
            if (this.first.compareAndSet(true, false)) {
                return this.ctx;
            }
            return EMPTY;
        }

        public String toString() {
            return "Chain for " + this.page;
        }

        public Supplier<PageChain> remnantSupplier(Object ... scopeContents) {
            Object[] context = ArrayUtils.concatenate((Object[])this.ctx, (Object[])scopeContents);
            assert (this.chainPosition != null) : "Called out of sequence";
            int pos = this.chainPosition.get();
            ArrayList rem = new ArrayList(this.types.size() - pos);
            for (int i = pos; i < this.types.size(); ++i) {
                rem.add(this.types.get(i));
            }
            return () -> {
                ArrayList<Object> l = new ArrayList<Object>(rem);
                PageChain chain = new PageChain(this.app, this.deps, this.scope, (Class<? super Acteur>)this.type, l, context);
                chain.page = this.page;
                return chain;
            };
        }

        private void addToContext(Event<?> event) {
            this.ctx = ArrayUtils.concatenate((Object[])this.ctx, (Object[])new Object[]{event});
        }
    }

    class ChainToPageConverter
    implements Converter<PageChain, Page> {
        private final RequestID id;
        private final Event<?> event;
        private final Closables clos;

        private ChainToPageConverter(RequestID id, Event<?> event, Closables clos) {
            this.id = id;
            this.event = event;
            this.clos = clos;
        }

        public PageChain convert(Page r) {
            r.setApplication(PagesImpl2.this.application);
            if (this.event instanceof HttpEvent) {
                Path pth = ((HttpEvent)this.event).path();
                Thread.currentThread().setName(pth + " for " + r.getClass().getName());
            } else {
                Thread.currentThread().setName(this.id + " of " + r.getClass().getName());
            }
            ((PagesImpl2)PagesImpl2.this).application.probe.onBeforeRunPage(this.id, this.event, r);
            PageChain result = new PageChain(PagesImpl2.this.application, (Instantiator)PagesImpl2.this.application.getDependencies(), PagesImpl2.this.application.getRequestScope(), Acteur.class, r, r, this.id, this.event, this.clos);
            return result;
        }

        public Page unconvert(PageChain t) {
            return t.page;
        }
    }

    static class ScopeWrapIterator<T>
    implements Iterator<T> {
        private final ReentrantScope scope;
        private final Iterator<T> delegate;
        private final Object[] ctx;

        ScopeWrapIterator(ReentrantScope scope, Iterator<T> delegate, Object ... ctx) {
            this.scope = scope;
            this.delegate = delegate;
            this.ctx = ctx;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            try (QuietAutoClosable clos = this.scope.enter(this.ctx);){
                T t = this.delegate.next();
                return t;
            }
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    class CB
    implements ChainCallback<Acteur, State, PageChain, Response, ResponseImpl>,
    ResponseSender {
        private final Event<?> event;
        private final CountDownLatch latch;
        private final Channel channel;
        private final RequestID id;
        private final Closables closables;
        boolean inUncaughtException = false;

        CB(RequestID id, Event<?> event, CountDownLatch latch, Channel channel, Closables closeables) {
            this.event = event;
            this.latch = latch;
            this.channel = channel;
            this.id = id;
            this.closables = closeables;
        }

        public void onBeforeRunOne(PageChain chain) {
            if (chain.page != null) {
                Page.set(chain.page);
            }
        }

        public void onBeforeRunOne(PageChain chain, List<ResponseImpl> responsesThusFar) {
            ResponseImpl.shadowResponses.set(responsesThusFar);
        }

        public void onAfterRunOne(PageChain chain, Acteur acteur) {
            Page p = Page.get();
            if (p == chain.page) {
                Page.clear();
            }
            ((PagesImpl2)PagesImpl2.this).application.probe.onActeurWasRun(this.id, this.event, p, acteur, null);
        }

        public void onAfterRunOne(PageChain chain, Acteur acteur, ActeurState state) {
            ((PagesImpl2)PagesImpl2.this).application.probe.onActeurWasRun(this.id, this.event, Page.get(), acteur, state);
            this.onAfterRunOne(chain, acteur);
        }

        public void onDone(State state, List<ResponseImpl> responses) {
            ResponseImpl finalR = new ResponseImpl();
            for (ResponseImpl r : responses) {
                finalR.merge(r);
            }
            this.receive(state.getActeur(), state, finalR);
            this.latch.countDown();
        }

        public void onRejected(State state) {
            throw new UnsupportedOperationException("Should not ever be called from ChainsRunner");
        }

        public void onNoResponse() {
            PagesImpl2.this.application.send404(this.id, this.event, this.channel);
            this.latch.countDown();
        }

        public void onFailure(Throwable ex) {
            this.uncaughtException(Thread.currentThread(), ex);
            this.latch.countDown();
        }

        @Override
        public void receive(Acteur acteur, State state, ResponseImpl response) {
            boolean isWebSocketResponse;
            ((PagesImpl2)PagesImpl2.this).application.probe.onBeforeSendResponse(this.id, this.event, acteur, response.status, response.hasListener(), response.message());
            boolean bl = isWebSocketResponse = this.event.request() instanceof WebSocketFrame && !(acteur instanceof WebSocketUpgradeActeur) && response.isModified();
            if (isWebSocketResponse) {
                if (this.handleWebsocketResponse(response, state)) {
                    return;
                }
            } else if (response.isModified() && response.status != null) {
                this.handleHttpResponse(response, state, acteur);
            } else {
                this.onNoResponse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleHttpResponse(ResponseImpl response, State state, Acteur acteur) {
            try (QuietAutoClosable clos = Page.set((Page)PagesImpl2.this.application.getDependencies().getInstance(Page.class));){
                if (!this.channel.isOpen()) {
                    this.latch.countDown();
                    return;
                }
                PagesImpl2.this.application._onBeforeSendResponse(response.status, this.event, response, state.getActeur(), state.getLockedPage());
                HttpResponse httpResponse = response.toResponse(this.event, ((PagesImpl2)PagesImpl2.this).application.charset);
                httpResponse = PagesImpl2.this.application._decorateResponse(this.id, this.event, state.getLockedPage(), acteur, httpResponse);
                if (PagesImpl2.this.debug && response.hasListener()) {
                    httpResponse.headers().add(X_BODY_GENERATOR.name(), (Object)response.listenerString());
                }
                if (!this.channel.isOpen()) {
                    this.latch.countDown();
                    return;
                }
                HttpResponse resp = httpResponse;
                try {
                    ResponseTrigger c = new ResponseTrigger(response, resp, state, acteur, this.closables, this.event);
                    Duration delay = response.getDelay();
                    if (delay == null) {
                        c.call();
                        return;
                    }
                    if (PagesImpl2.this.debug) {
                        System.err.println("Response will be delayed for " + delay);
                    }
                    ((PagesImpl2)PagesImpl2.this).application.probe.onInfo("Response delayed {0}", delay);
                    ScheduledFuture<ChannelFuture> s = PagesImpl2.this.scheduler.schedule(c, delay.toMillis(), TimeUnit.MILLISECONDS);
                    this.channel.closeFuture().addListener((GenericFutureListener)new CancelOnClose(s));
                    return;
                }
                finally {
                    this.latch.countDown();
                }
            }
            catch (OutOfMemoryError | ThreadDeath ee) {
                Exceptions.chuck((Throwable)ee);
                return;
            }
            catch (Error | Exception e) {
                this.uncaughtException(Thread.currentThread(), e);
                return;
            }
            finally {
                ReferenceCounted rc;
                Object o = this.event.request();
                if (o instanceof ReferenceCounted && (rc = (ReferenceCounted)o).refCnt() > 0) {
                    ((ReferenceCounted)o).release();
                }
            }
        }

        private boolean handleWebsocketResponse(ResponseImpl response, State state) {
            if (response.getMessage() instanceof WebSocketFrame) {
                this.channel.writeAndFlush(response.getMessage());
                return true;
            }
            if (response.getMessage() == null) {
                return true;
            }
            try (QuietAutoClosable cl = Page.set(state.getLockedPage());){
                HttpResponse resp = response.toResponse(this.event, ((PagesImpl2)PagesImpl2.this).application.charset);
                if (resp instanceof FullHttpResponse) {
                    BinaryWebSocketFrame frame = new BinaryWebSocketFrame(((FullHttpResponse)resp).content());
                    this.channel.writeAndFlush((Object)frame);
                }
            }
            catch (Exception ex) {
                this.uncaughtException(Thread.currentThread(), ex);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable thrwbl) {
            try {
                if (this.inUncaughtException) {
                    throw thrwbl;
                }
                ((PagesImpl2)PagesImpl2.this).application.probe.onThrown(this.id, this.event, thrwbl);
                if (thrwbl instanceof ThreadDeath || thrwbl instanceof OutOfMemoryError) {
                    Exceptions.chuck((Throwable)thrwbl);
                }
                if (!(thrwbl instanceof ResponseException) || thrwbl instanceof InvalidInputException) {
                    PagesImpl2.this.application.internalOnError(thrwbl);
                }
                ErrorPage pg = new ErrorPage();
                pg.setApplication(PagesImpl2.this.application);
                try (QuietAutoClosable ac = Page.set(pg);){
                    this.inUncaughtException = true;
                    try (QuietAutoClosable ac2 = PagesImpl2.this.application.getRequestScope().enter(new Object[]{this.id, this.event, this.channel});){
                        Acteur err = Acteur.error(null, pg, thrwbl, (Event)PagesImpl2.this.application.getDependencies().getInstance(Event.class), PagesImpl2.this.renderStackTraces);
                        this.receive(err, err.getState(), err.getResponse());
                    }
                }
                finally {
                    this.inUncaughtException = false;
                }
            }
            catch (Throwable ex) {
                if (ex != thrwbl) {
                    thrwbl.addSuppressed(ex);
                }
                ((PagesImpl2)PagesImpl2.this).application.probe.onThrown(this.id, this.event, thrwbl);
                try {
                    if (this.channel.isOpen()) {
                        HttpResponse resp;
                        if (((PagesImpl2)PagesImpl2.this).application.failureResponses != null) {
                            resp = ((PagesImpl2)PagesImpl2.this).application.failureResponses.createFallbackResponse(ex);
                        } else {
                            ByteBuf buf;
                            if (PagesImpl2.this.renderStackTraces) {
                                buf = this.channel.alloc().ioBuffer();
                                buf.touch((Object)"uncaught-exception-handling-a");
                                try (PrintStream ps = new PrintStream((OutputStream)new ByteBufOutputStream(buf));){
                                    thrwbl.printStackTrace(ps);
                                }
                            } else {
                                String msg = ex.getMessage();
                                if (msg == null) {
                                    msg = ex.getClass().getSimpleName();
                                }
                                byte[] bytes = msg.getBytes(CharsetUtil.UTF_8);
                                buf = Unpooled.wrappedBuffer((byte[])bytes);
                                buf.touch((Object)"uncaught-exception-handling-b");
                            }
                            resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, buf);
                            ((DefaultFullHttpResponse)resp).touch((Object)"uncaught-exception-handling-c");
                            Headers.write((HeaderValueType)Headers.CONTENT_TYPE, (Object)MimeType.PLAIN_TEXT_UTF_8, (HttpMessage)resp);
                            Headers.write((HeaderValueType)Headers.CONTENT_LENGTH, (Object)buf.writerIndex(), (HttpMessage)resp);
                            Headers.write((HeaderValueType)Headers.CONTENT_LANGUAGE, (Object)Locale.ENGLISH, (HttpMessage)resp);
                            Headers.write((HeaderValueType)Headers.CACHE_CONTROL, (Object)CacheControl.PRIVATE_NO_CACHE_NO_STORE, (HttpMessage)resp);
                            Headers.write((HeaderValueType)Headers.DATE, (Object)ZonedDateTime.now(), (HttpMessage)resp);
                        }
                        this.channel.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                }
                finally {
                    PagesImpl2.this.application.internalOnError(ex);
                }
            }
        }

        private class ResponseTrigger
        implements Callable<ChannelFuture> {
            private final ResponseImpl response;
            private final HttpResponse resp;
            private final State state;
            private final Acteur acteur;
            private final Closables closeables;
            private final Event<?> evt;

            ResponseTrigger(ResponseImpl response, HttpResponse resp, State state, Acteur acteur, Closables closeables, Event<?> evt) {
                this.response = response;
                this.resp = resp;
                this.state = state;
                this.acteur = acteur;
                this.closeables = closeables;
                this.evt = evt;
            }

            @Override
            public ChannelFuture call() throws Exception {
                PagesImpl2.this.application.onBeforeRespond(CB.this.id, CB.this.event, this.response.internalStatus());
                ChannelFuture fut = PagesImpl2.this.canPostponeFlush(this.evt, this.response) ? CB.this.channel.write((Object)this.resp) : CB.this.channel.writeAndFlush((Object)this.resp);
                fut.addListener((GenericFutureListener)((PagesImpl2)PagesImpl2.this).application.errorLoggingListener);
                Page pg = this.state.getLockedPage();
                ChannelFuture bodyFuture = this.response.sendMessage(CB.this.event, fut, (HttpMessage)this.resp, this.response.hasListener());
                if (bodyFuture == fut && this.resp instanceof FullHttpResponse) {
                    this.closeables.closeOn(fut);
                }
                if (bodyFuture != fut && !this.response.hasListener()) {
                    bodyFuture.addListener((GenericFutureListener)((PagesImpl2)PagesImpl2.this).application.errorLoggingListener);
                }
                PagesImpl2.this.application.onAfterRespond(CB.this.id, CB.this.event, this.acteur, pg, this.state, HttpResponseStatus.OK, this.resp);
                return bodyFuture;
            }
        }
    }

    static class CancelOnChannelClose
    implements ChannelFutureListener {
        final AtomicBoolean cancelled = new AtomicBoolean();

        CancelOnChannelClose() {
        }

        public void operationComplete(ChannelFuture f) throws Exception {
            this.cancelled.set(true);
        }
    }

    static class ErrorPage
    extends Page {
        ErrorPage() {
        }
    }

    static class CancelOnClose
    implements ChannelFutureListener {
        private final ScheduledFuture future;

        CancelOnClose(ScheduledFuture future) {
            this.future = future;
        }

        public void operationComplete(ChannelFuture f) throws Exception {
            this.future.cancel(true);
        }
    }
}

