/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.PagePathAndMethodFilter;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.settings.Settings;
import io.netty.handler.codec.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.inject.Inject;

abstract class PathFilters {
    PathFilters() {
    }

    abstract boolean isEarlyPageMatch(HttpRequest var1);

    abstract PagePathAndMethodFilter normalPages();

    abstract void addEarlyPage(Page var1);

    abstract void addEarlyPage(Class<? extends Page> var1);

    abstract void addNormalPage(Page var1);

    abstract void addNormalPage(Class<? extends Page> var1);

    abstract PagePathAndMethodFilter earlyPages();

    static PathFilters create(Supplier<Dependencies> deps) {
        InitialPathFilters initial = new InitialPathFilters();
        return new DelegatingPathFilters(initial, deps);
    }

    private static class InitialPathFilters
    extends PathFilters {
        private final List<Object> earlyPages = new ArrayList<Object>(25);
        private final List<Object> normalPages = new ArrayList<Object>(25);

        private InitialPathFilters() {
        }

        @Override
        boolean isEarlyPageMatch(HttpRequest req) {
            throw new IllegalStateException("Not yet initialized");
        }

        @Override
        PagePathAndMethodFilter normalPages() {
            throw new IllegalStateException("Not yet initialized");
        }

        @Override
        void addEarlyPage(Page page) {
            this.earlyPages.add(page);
        }

        @Override
        void addEarlyPage(Class<? extends Page> page) {
            this.earlyPages.add(page);
        }

        @Override
        void addNormalPage(Page page) {
            this.normalPages.add(page);
        }

        @Override
        void addNormalPage(Class<? extends Page> page) {
            this.normalPages.add(page);
        }

        @Override
        PagePathAndMethodFilter earlyPages() {
            throw new IllegalStateException("Not yet initialized");
        }

        private PathFilters toInitializedInstance(String basePath) {
            PagePathAndMethodFilter normal = new PagePathAndMethodFilter(basePath);
            this.addToFilter(this.normalPages, normal);
            PagePathAndMethodFilter early = null;
            if (!this.earlyPages.isEmpty()) {
                early = new PagePathAndMethodFilter(basePath);
                this.addToFilter(this.earlyPages, early);
            }
            return new InitializedPathFilters(basePath, normal, early);
        }

        private void addToFilter(List<Object> objects, PagePathAndMethodFilter to) {
            for (Object o : objects) {
                if (o instanceof Page) {
                    to.add((Page)o);
                    continue;
                }
                if (o instanceof Class) {
                    to.add((Class)o);
                    continue;
                }
                throw new AssertionError((Object)("Neither a page nor a Class<? extends Page>: " + o));
            }
        }
    }

    private static class DelegatingPathFilters
    extends PathFilters {
        private final AtomicReference<PathFilters> filters = new AtomicReference();
        private final Supplier<Dependencies> supp;

        DelegatingPathFilters(PathFilters orig, Supplier<Dependencies> supp) {
            this.filters.set(orig);
            this.supp = supp;
        }

        PathFilters delegate() {
            PathFilters result = this.filters.get();
            if (result instanceof InitialPathFilters) {
                InitialPathFilters ipf = (InitialPathFilters)result;
                Dependencies deps = this.supp.get();
                if (deps != null) {
                    Settings settings = (Settings)deps.getInstance(Settings.class);
                    if (settings == null) {
                        result = ipf.toInitializedInstance(null);
                    } else {
                        String bp = settings.getString("basepath");
                        if (PagePathAndMethodFilter.DEBUG) {
                            System.out.println("Initialize path filters with base path: '" + bp + "'.\nNormal pages: \n" + ipf.normalPages + "\nEarly pages: \n" + ipf.earlyPages);
                        }
                        result = ipf.toInitializedInstance(bp);
                    }
                }
            }
            return result;
        }

        @Override
        boolean isEarlyPageMatch(HttpRequest req) {
            return this.delegate().isEarlyPageMatch(req);
        }

        @Override
        PagePathAndMethodFilter normalPages() {
            return this.delegate().normalPages();
        }

        @Override
        void addEarlyPage(Page page) {
            this.delegate().addEarlyPage(page);
        }

        @Override
        void addEarlyPage(Class<? extends Page> page) {
            this.delegate().addEarlyPage(page);
        }

        @Override
        void addNormalPage(Page page) {
            this.delegate().addNormalPage(page);
        }

        @Override
        void addNormalPage(Class<? extends Page> page) {
            this.delegate().addNormalPage(page);
        }

        @Override
        PagePathAndMethodFilter earlyPages() {
            return this.delegate().earlyPages();
        }
    }

    private static final class InitializedPathFilters
    extends PathFilters {
        private final String basePath;
        private final PagePathAndMethodFilter filter;
        private PagePathAndMethodFilter earlyPageMatcher;

        @Inject
        InitializedPathFilters(String basePath, PagePathAndMethodFilter filter, PagePathAndMethodFilter earlyPageMatcher) {
            this.basePath = basePath;
            this.filter = filter;
            this.earlyPageMatcher = earlyPageMatcher;
        }

        @Override
        boolean isEarlyPageMatch(HttpRequest req) {
            boolean result = this.earlyPageMatcher != null && this.earlyPageMatcher.match(req);
            return result;
        }

        @Override
        PagePathAndMethodFilter normalPages() {
            return this.filter;
        }

        @Override
        void addEarlyPage(Page page) {
            this.earlyPages().add(page);
        }

        @Override
        void addEarlyPage(Class<? extends Page> page) {
            this.earlyPages().add(page);
        }

        @Override
        PagePathAndMethodFilter earlyPages() {
            if (this.earlyPageMatcher == null) {
                this.earlyPageMatcher = new PagePathAndMethodFilter(this.basePath);
            }
            return this.earlyPageMatcher;
        }

        @Override
        void addNormalPage(Page page) {
            this.normalPages().add(page);
        }

        @Override
        void addNormalPage(Class<? extends Page> page) {
            this.normalPages().add(page);
        }
    }
}

