/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;

@Singleton
class PathPatterns {
    private final Map<String, Boolean> matchCache = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, String> exactPathForRegex = new ConcurrentHashMap<String, String>();
    private static final String INVALID = "::////";
    private final Map<String, Pattern> patternCache = new ConcurrentHashMap<String, Pattern>();

    @Inject
    public PathPatterns() {
    }

    static String patternFromGlob(String pattern) {
        if (pattern.length() > 0 && pattern.charAt(0) == '/') {
            pattern = pattern.substring(1);
        }
        StringBuilder match = new StringBuilder("^\\/?");
        block5: for (char c : pattern.toCharArray()) {
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '/': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '}': {
                    match.append("\\").append(c);
                    continue block5;
                }
                case '*': {
                    match.append("[^\\/]*?");
                    continue block5;
                }
                case '?': {
                    match.append("[^\\/]?");
                    continue block5;
                }
                default: {
                    match.append(c);
                }
            }
        }
        match.append("$");
        return match.toString();
    }

    String exactPathForRegex(String regex) {
        String result = this.exactPathForRegex.get(regex);
        if (result != null) {
            if (!INVALID.equals(result)) {
                return result;
            }
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = regex.toCharArray();
        boolean precedingWasBackslash = false;
        boolean endMarkerFound = false;
        boolean startMarkerFound = false;
        block5: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i == 0 && c == '^') continue;
            if (i == chars.length - 1 && c == '$') {
                endMarkerFound = true;
                continue;
            }
            if (i == 0 && c == '^') {
                startMarkerFound = true;
            }
            switch (c) {
                case '\\': {
                    if (i == chars.length - 1) break;
                    precedingWasBackslash = true;
                    break;
                }
                case '*': {
                    if (precedingWasBackslash) {
                        sb.append(c);
                        continue block5;
                    }
                }
                case '$': 
                case '&': 
                case '+': 
                case '?': 
                case '[': 
                case '^': {
                    this.exactPathForRegex.put(regex, INVALID);
                    return null;
                }
                default: {
                    sb.append(c);
                }
            }
            precedingWasBackslash = c == '\\';
        }
        if (!endMarkerFound || !startMarkerFound) {
            this.exactPathForRegex.put(regex, INVALID);
            return null;
        }
        result = sb.length() > 0 && sb.charAt(0) == '/' ? sb.substring(1) : sb.toString();
        this.exactPathForRegex.put(regex, result);
        return result;
    }

    boolean isExactGlob(String s) {
        Boolean match = this.matchCache.get(s);
        if (match != null) {
            return match;
        }
        boolean result = true;
        for (char c : s.toCharArray()) {
            if ('*' != c) continue;
            result = false;
            break;
        }
        this.matchCache.put(s, result);
        return result;
    }

    Pattern getPattern(String regex) {
        Pattern result = this.patternCache.get(regex);
        if (result == null) {
            result = Pattern.compile(regex);
            this.patternCache.put(regex, result);
        }
        return result;
    }
}

