/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.google.inject.Key;
import com.google.inject.name.Names;
import com.mastfrog.acteur.Acteur;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.HttpEvent;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.Response;
import com.mastfrog.acteur.ResponseWriter;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.acteur.server.ServerModule;
import com.mastfrog.acteur.spi.ApplicationControl;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.giulius.scope.ReentrantScope;
import com.mastfrog.marshallers.netty.NettyContentMarshallers;
import com.mastfrog.mime.MimeType;
import com.mastfrog.util.codec.Codec;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import com.mastfrog.util.thread.ThreadLocalTransfer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

final class ResponseImpl
extends Response {
    static boolean DEBUG_BAD_LISTENER_STRINGS = Boolean.getBoolean("acteur.debug.listeners.strings");
    private volatile boolean modified;
    HttpResponseStatus status;
    private final List<Entry<?>> headers = new ArrayList(3);
    private Object message;
    ChannelFutureListener listener;
    private boolean chunked;
    private Duration delay;
    private static final boolean debug = Boolean.getBoolean("acteur.debug");
    static final ThreadLocalTransfer<List<ResponseImpl>> shadowResponses = new ThreadLocalTransfer();
    List<ResponseImpl> alsoConsult;
    private static final AsciiString ZERO = AsciiString.of((CharSequence)"0");
    static Set<String> WARNED = ConcurrentHashMap.newKeySet();
    private static final AsciiString TRUE = AsciiString.of((CharSequence)"1");
    static final SendEmptyLastChunk SEND_EMPTY_LAST_CHUNK = new SendEmptyLastChunk();

    ResponseImpl() {
        List previousActeursResponses = (List)shadowResponses.get();
        if (previousActeursResponses != null) {
            this.alsoConsult = CollectionUtils.reversed((List)previousActeursResponses);
        }
    }

    boolean hasListener() {
        return this.listener != null;
    }

    Object message() {
        return this.message;
    }

    boolean isModified() {
        return this.modified;
    }

    void modify() {
        this.modified = true;
    }

    void merge(ResponseImpl other) {
        Checks.notNull((String)"other", (Object)other);
        this.modified |= other.modified;
        if (other.modified) {
            for (Entry<?> e : other.headers) {
                this.addEntry(e);
            }
            if (other.status != null) {
                this.status(other.status);
            }
            if (other.message != null) {
                this.content(other.message);
            }
            if (other.chunked) {
                this.chunked(true);
            }
            if (other.listener != null) {
                this.contentWriter(other.listener);
            }
            if (other.delay != null) {
                this.delay = other.delay;
            }
        }
    }

    private <T> void addEntry(Entry<T> e) {
        this.add(((Entry)e).decorator, ((Entry)e).value);
    }

    @Override
    public Response content(Object message) {
        this.modify();
        this.message = message;
        return this;
    }

    @Override
    public Response delayedBy(Duration delay) {
        this.modify();
        this.delay = delay;
        return this;
    }

    @Override
    public Response status(HttpResponseStatus status) {
        this.modify();
        this.status = status;
        return this;
    }

    HttpResponseStatus rawStatus() {
        return this.status;
    }

    public HttpResponseStatus getResponseCode() {
        if (this.status == null && this.alsoConsult != null) {
            for (ResponseImpl previous : this.alsoConsult) {
                HttpResponseStatus raw = previous.rawStatus();
                if (raw == null) continue;
                return raw;
            }
        }
        return this.status == null ? HttpResponseStatus.OK : this.status;
    }

    @Override
    public Response contentWriter(ResponseWriter writer) {
        Page p = Page.get();
        Application app = p.getApplication();
        Dependencies deps = app.getDependencies();
        HttpEvent evt = (HttpEvent)deps.getInstance(HttpEvent.class);
        Charset charset = (Charset)deps.getInstance(Charset.class);
        ByteBufAllocator allocator = (ByteBufAllocator)deps.getInstance(ByteBufAllocator.class);
        Codec mapper = (Codec)deps.getInstance(Codec.class);
        Key key = Key.get(ExecutorService.class, (Annotation)Names.named((String)"workers"));
        ExecutorService svc = (ExecutorService)deps.getInstance(key);
        this.setWriter(writer, charset, allocator, mapper, evt, svc, app.control());
        return this;
    }

    Duration getDelay() {
        return this.delay;
    }

    private String cookieName(Object o) {
        if (o instanceof io.netty.handler.codec.http.cookie.Cookie) {
            return ((io.netty.handler.codec.http.cookie.Cookie)o).name();
        }
        if (o instanceof Cookie) {
            return ((Cookie)o).name();
        }
        return null;
    }

    private boolean compareCookies(Object old, Object nue) {
        return Objects.equals(this.cookieName(old), this.cookieName(nue));
    }

    @Override
    public <T> Response add(HeaderValueType<T> decorator, T value) {
        LinkedList old = new LinkedList();
        Iterator<Entry<?>> it = this.headers.iterator();
        while (it.hasNext()) {
            Entry<?> e = it.next();
            if (decorator.is((CharSequence)HttpHeaderNames.SET_COOKIE) && ((Entry)e).decorator.is((CharSequence)HttpHeaderNames.SET_COOKIE)) {
                if (!this.compareCookies(((Entry)e).value, value)) continue;
                it.remove();
                continue;
            }
            if (e.match(decorator) == null) continue;
            old.add(e);
            it.remove();
        }
        Entry<Object> e = new Entry<Object>(decorator, value);
        if (!old.isEmpty() && decorator.is((CharSequence)HttpHeaderNames.ALLOW)) {
            old.add(e);
            EnumSet<Method> all = EnumSet.noneOf(Method.class);
            for (Entry entry : old) {
                Method[] m = (Method[])entry.value;
                all.addAll(Arrays.asList(m));
            }
            value = all.toArray(new Method[all.size()]);
            e = new Entry<Object>(decorator, value);
        }
        this.headers.add(e);
        this.modify();
        return this;
    }

    @Override
    public <T> T get(HeaderValueType<T> decorator) {
        T result;
        block1: {
            ResponseImpl preceding;
            result = this.internalGet(decorator);
            if (result != null || this.alsoConsult == null) break block1;
            Iterator<ResponseImpl> iterator = this.alsoConsult.iterator();
            while (iterator.hasNext() && (result = (preceding = iterator.next()).internalGet(decorator)) == null) {
            }
        }
        return result;
    }

    <T> T internalGet(HeaderValueType<T> headerType) {
        for (Entry<?> e : this.headers) {
            HeaderValueType<T> d = e.match(headerType);
            if (d == null) continue;
            return d.type().cast(((Entry)e).value);
        }
        return null;
    }

    @Override
    public Response chunked(boolean chunked) {
        if (chunked != this.chunked) {
            this.chunked = chunked;
            this.modify();
        }
        return this;
    }

    <T extends ResponseWriter> void setWriter(T w, Dependencies deps, HttpEvent evt) {
        Charset charset = (Charset)deps.getInstance(Charset.class);
        ByteBufAllocator allocator = (ByteBufAllocator)deps.getInstance(ByteBufAllocator.class);
        Codec mapper = (Codec)deps.getInstance(Codec.class);
        Key key = Key.get(ExecutorService.class, (Annotation)Names.named((String)"workers"));
        ExecutorService svc = (ExecutorService)deps.getInstance(key);
        ApplicationControl ctrl = (ApplicationControl)deps.getInstance(ApplicationControl.class);
        this.setWriter(w, charset, allocator, mapper, evt, svc, ctrl);
    }

    <T extends ResponseWriter> void setWriter(Class<T> w, Dependencies deps, HttpEvent evt) {
        Charset charset = (Charset)deps.getInstance(Charset.class);
        ByteBufAllocator allocator = (ByteBufAllocator)deps.getInstance(ByteBufAllocator.class);
        Key key = Key.get(ExecutorService.class, (Annotation)Names.named((String)"workers"));
        ExecutorService svc = (ExecutorService)deps.getInstance(key);
        Codec mapper = (Codec)deps.getInstance(Codec.class);
        this.setWriter(new DynResponseWriter(w, deps), charset, allocator, mapper, evt, svc, (ApplicationControl)deps.getInstance(ApplicationControl.class));
    }

    private boolean hasTransferEncodingChunked() {
        for (Entry<?> entry : this.headers) {
            if (!Headers.TRANSFER_ENCODING.is(((Entry)entry).decorator.name())) continue;
            return Strings.charSequencesEqual((CharSequence)HttpHeaderValues.CHUNKED, (CharSequence)entry.stringValue(), (boolean)true);
        }
        return false;
    }

    private boolean hasContentLength() {
        for (Entry<?> entry : this.headers) {
            if (!Headers.CONTENT_LENGTH.equals(((Entry)entry).decorator)) continue;
            return Strings.charSequencesEqual((CharSequence)HttpHeaderValues.CHUNKED, (CharSequence)entry.stringValue(), (boolean)true);
        }
        return false;
    }

    private boolean isHttp10StyleResponse() {
        return this.listener != null && !this.chunked && !this.hasTransferEncodingChunked() && !this.hasContentLength();
    }

    boolean isKeepAlive(Event<?> evt) {
        boolean result;
        boolean bl = result = evt instanceof HttpEvent ? ((HttpEvent)evt).requestsConnectionStayOpen() : false;
        if (result) {
            result = !this.isHttp10StyleResponse();
        }
        return result;
    }

    void setWriter(ResponseWriter w, Charset charset, ByteBufAllocator allocator, Codec mapper, Event<?> evt, ExecutorService svc, ApplicationControl ctrl) {
        this.contentWriter(new ResponseWriterListener(evt, w, charset, allocator, mapper, this.chunked, !this.isKeepAlive(evt), svc, ctrl));
    }

    String listenerString() {
        if (this.listener != null) {
            if (this.listener instanceof ResponseWriterListener) {
                return ResponseImpl.checkValidCharacters(((ResponseWriterListener)this.listener).writer.getClass().getName());
            }
            if (this.listener instanceof Acteur.ScopeWrapper || this.listener instanceof Acteur.IWrapper) {
                return ResponseImpl.checkValidCharacters(this.listener.toString());
            }
            return ResponseImpl.checkValidCharacters(this.listener.getClass().getName());
        }
        return "no-listener";
    }

    static String checkValidCharacters(String ls) {
        if (!DEBUG_BAD_LISTENER_STRINGS) {
            return ls;
        }
        for (int i = 0; i < ls.length(); ++i) {
            char c = ls.charAt(i);
            if (c != '\u0000') continue;
            new IllegalArgumentException("Bad string '" + ls + "'").printStackTrace();
            return "bad-listener-string";
        }
        return ls;
    }

    @Override
    public Response contentWriter(ChannelFutureListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("Listener already set to " + this.listener);
        }
        this.listener = listener;
        return this;
    }

    public Object getMessage() {
        return this.message;
    }

    final boolean canHaveBody(HttpResponseStatus status) {
        switch (status.code()) {
            case 204: 
            case 205: 
            case 304: {
                return false;
            }
        }
        return true;
    }

    private ByteBuf writeMessage(Event<?> evt, Charset charset) throws Exception {
        if (this.message == null) {
            return null;
        }
        if (this.message instanceof ByteBuf) {
            return (ByteBuf)this.message;
        }
        Page p = Page.get();
        if (p == null) {
            throw new IllegalStateException("Call to write message with Page.set() not called (outside request scope?)");
        }
        NettyContentMarshallers marshallers = (NettyContentMarshallers)p.getApplication().getDependencies().getInstance(NettyContentMarshallers.class);
        ByteBuf buf = evt.channel().alloc().ioBuffer();
        buf.touch((Object)"response-impl-write-message");
        marshallers.write(this.message, (Object)buf, new Object[]{charset});
        return buf;
    }

    HttpResponseStatus internalStatus() {
        return this.status == null ? HttpResponseStatus.OK : this.status;
    }

    private boolean has(CharSequence headerName) {
        for (Entry<?> e : this.headers) {
            if (!e.is(headerName)) continue;
            return true;
        }
        return false;
    }

    boolean hasNoPayload() {
        HttpResponseStatus status = this.internalStatus();
        if (status == HttpResponseStatus.NOT_MODIFIED || status == HttpResponseStatus.NO_CONTENT) {
            return true;
        }
        return this.listener == null && (this.message == null || this.message instanceof String && ((String)this.message).isEmpty());
    }

    public HttpResponse toResponse(Event<?> evt, Charset defaultCharset) throws Exception {
        DefaultHttpResponse result;
        ByteBuf buf;
        MimeType mimeType;
        HttpResponseStatus status = this.internalStatus();
        if (!this.canHaveBody(status) && (this.message != null || this.listener != null) && debug && this.listener != ChannelFutureListener.CLOSE && this.listener != SEND_EMPTY_LAST_CHUNK) {
            System.err.println(evt + " attempts to attach a body to " + status + " which cannot have one: " + this.message + " - " + this.listener);
        }
        if ((mimeType = (MimeType)this.get(Headers.CONTENT_TYPE)) != null && mimeType.charset().isPresent()) {
            defaultCharset = (Charset)mimeType.charset().get();
        }
        if ((buf = this.writeMessage(evt, defaultCharset)) != null && this.listener != null) {
            throw new IllegalStateException("Both outbound buffer, and listener for header flush are present; either one can write the response body, but not both");
        }
        DefaultHttpHeaders hdrs = new DefaultHttpHeaders();
        boolean noBody = this.listener == null && buf == null || status == HttpResponseStatus.NO_CONTENT || status == HttpResponseStatus.NOT_MODIFIED;
        boolean hasInternalCompress = this.has((CharSequence)ServerModule.X_INTERNAL_COMPRESS);
        boolean hasContentEncoding = this.has((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        boolean hasTransferEncoding = this.has((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        boolean hasContentLength = false;
        boolean addIdentityContentEncoding = buf != null && !hasContentEncoding && !hasInternalCompress;
        for (Entry<?> e : this.headers) {
            if (noBody) {
                if (e.is((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) continue;
                if (e.is((CharSequence)HttpHeaderNames.CONTENT_ENCODING)) {
                    hasContentEncoding = false;
                    continue;
                }
                if (e.is((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                    hasTransferEncoding = false;
                    continue;
                }
            }
            if (addIdentityContentEncoding && e.is((CharSequence)HttpHeaderNames.CONTENT_ENCODING)) continue;
            hasContentLength |= e.is((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            e.write((HttpHeaders)hdrs);
        }
        if (debug && evt instanceof HttpEvent) {
            System.out.println("\n\n********************\n" + ((HttpEvent)evt).path() + " " + status + " hasInternalCompress " + hasInternalCompress + " hasContentLength " + hasContentLength + " hasTransferEncoding " + hasTransferEncoding + " hasContentEncoding " + hasContentEncoding + " chunked " + this.chunked + " noBody " + noBody);
        }
        if (addIdentityContentEncoding) {
            hdrs.add((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)HttpHeaderValues.IDENTITY);
        }
        if (noBody) {
            if (buf != null) {
                buf.release();
            }
            if (debug) {
                System.out.println("noBody - set content-length: 0, chunked false");
            }
            hdrs.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)ZERO);
            this.chunked = false;
            DefaultFullHttpResponse result2 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.EMPTY_BUFFER, (HttpHeaders)hdrs, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            result2.touch((Object)"response-impl-a");
            return result2;
        }
        if (this.chunked) {
            if (!hasTransferEncoding) {
                hdrs.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
        } else if (buf != null) {
            hdrs.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buf.readableBytes());
        }
        HttpVersion version = HttpVersion.HTTP_1_1;
        if (!this.chunked && buf == null && this.listener != null && !hasContentEncoding) {
            if (!hasContentLength && this.listener != ChannelFutureListener.CLOSE && this.listener != SEND_EMPTY_LAST_CHUNK) {
                ResponseImpl.warn(evt);
                version = HttpVersion.HTTP_1_0;
            }
            hdrs.set((CharSequence)ServerModule.X_INTERNAL_COMPRESS, (Object)true);
        }
        if (debug) {
            System.out.println(" final headers " + this.headersString((HttpHeaders)hdrs));
        }
        if (buf != null) {
            this.listener = new SendOneBuffer(buf);
            result = new DefaultHttpResponse(version, status, (HttpHeaders)hdrs);
        } else {
            result = new DefaultHttpResponse(version, status, (HttpHeaders)hdrs);
        }
        return result;
    }

    static void warn(Event<?> evt) {
        String mth;
        String pth = evt instanceof HttpEvent ? ((HttpEvent)evt).path().toString() : "";
        String string = mth = evt instanceof HttpEvent ? ((HttpEvent)evt).method().toString() : "";
        if (WARNED.add(mth + pth)) {
            System.err.println("Response to " + mth + " " + pth + " is non-chunked, has no content-length header but will send response chunks using a listener.  The only way to avoid hanging the client is to close the connection, HTTP 1.0 style, once all data is sent.");
        }
    }

    private String headersString(HttpHeaders resp) {
        StringBuilder sb = new StringBuilder();
        if (resp != null) {
            for (Map.Entry e : resp.entries()) {
                sb.append('\n').append((String)e.getKey()).append(": ").append((String)e.getValue());
            }
        }
        return sb.toString();
    }

    ChannelFuture sendMessage(Event<?> evt, ChannelFuture future, HttpMessage resp, boolean trigger) throws Exception {
        if (this.listener != null) {
            if (trigger) {
                this.listener.operationComplete((Future)future);
            } else {
                future = future.addListener((GenericFutureListener)this.listener);
            }
            return future;
        }
        if (!this.isKeepAlive(evt)) {
            future = future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return future;
    }

    public String toString() {
        return "Response{modified=" + this.modified + ", status=" + this.status + ", headers=" + this.headers + ", message=" + this.message + ", listener=" + this.listener + ", chunked=" + this.chunked + '}';
    }

    private static final class Entry<T> {
        private final HeaderValueType<T> decorator;
        private final T value;

        Entry(HeaderValueType<T> decorator, T value) {
            Checks.notNull((String)"decorator", decorator);
            Checks.notNull((String)decorator.name().toString(), value);
            this.decorator = decorator;
            this.value = value;
        }

        public void decorate(HttpMessage msg) {
            msg.headers().set(this.decorator.name(), this.value);
        }

        public boolean is(CharSequence name) {
            return this.decorator.is(name);
        }

        public void write(HttpMessage msg) {
            Headers.write(this.decorator, this.value, (HttpMessage)msg);
        }

        void write(HttpHeaders headers) {
            Headers.write(this.decorator, this.value, (HttpHeaders)headers);
        }

        public CharSequence stringValue() {
            return this.decorator.toCharSequence(this.value);
        }

        public String toString() {
            return this.decorator.name() + ": " + this.decorator.toCharSequence(this.value);
        }

        public int hashCode() {
            return this.decorator.name().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Entry && ((Entry)o).decorator.name().equals(this.decorator.name());
        }

        public <R> HeaderValueType<R> match(HeaderValueType<R> decorator) {
            if (this.decorator.equals(decorator)) {
                if (this.decorator.type() != decorator.type() && debug) {
                    System.err.println("Requesting header " + decorator + " of type " + decorator.type().getName() + " but returning header of type " + this.decorator.type().getName() + " - if set, this will probably throw a ClassCastException.");
                }
                return this.decorator;
            }
            if (this.decorator.name().equals(decorator.name()) && this.decorator.type().equals(decorator.type())) {
                return decorator;
            }
            if (Strings.charSequencesEqual((CharSequence)this.decorator.name(), (CharSequence)decorator.name(), (boolean)true)) {
                // empty if block
            }
            return null;
        }
    }

    static class DynResponseWriter
    extends ResponseWriter {
        private final AtomicReference<ResponseWriter> actual = new AtomicReference();
        private final Callable<ResponseWriter> resp;

        DynResponseWriter(final Class<? extends ResponseWriter> type, final Dependencies deps) {
            ReentrantScope scope = (ReentrantScope)deps.getInstance(ReentrantScope.class);
            assert (scope.inScope());
            this.resp = scope.wrap((Callable)new Callable<ResponseWriter>(){

                @Override
                public ResponseWriter call() throws Exception {
                    ResponseWriter w = (ResponseWriter)actual.get();
                    if (w == null) {
                        w = (ResponseWriter)deps.getInstance(type);
                        actual.set(w);
                    }
                    return w;
                }

                public String toString() {
                    return type.toString();
                }
            });
        }

        @Override
        public ResponseWriter.Status write(Event<?> evt, ResponseWriter.Output out) throws Exception {
            ResponseWriter actual = this.resp.call();
            return actual.write(evt, out);
        }

        @Override
        public ResponseWriter.Status write(Event<?> evt, ResponseWriter.Output out, int iteration) throws Exception {
            ResponseWriter actual = this.resp.call();
            return actual.write(evt, out, iteration);
        }

        public String toString() {
            return "DynResponseWriter for " + this.resp.toString();
        }
    }

    private static final class ResponseWriterListener
    extends ResponseWriter.AbstractOutput
    implements ChannelFutureListener {
        private volatile ChannelFuture future;
        private volatile int callCount = 0;
        private final boolean chunked;
        final ResponseWriter writer;
        private final boolean shouldClose;
        private final Event<?> evt;
        private final ExecutorService svc;
        private final ApplicationControl ctrl;
        volatile boolean inOperationComplete;
        volatile int entryCount = 0;

        ResponseWriterListener(Event<?> evt, ResponseWriter writer, Charset charset, ByteBufAllocator allocator, Codec mapper, boolean chunked, boolean shouldClose, ExecutorService svc, ApplicationControl ctrl) {
            super(charset, allocator, mapper);
            this.chunked = chunked;
            this.writer = writer;
            this.shouldClose = shouldClose;
            this.evt = evt;
            this.svc = svc;
            this.ctrl = ctrl;
        }

        @Override
        public Channel channel() {
            if (this.future == null) {
                throw new IllegalStateException("No future -> no channel");
            }
            return this.future.channel();
        }

        @Override
        public ResponseWriter.Output write(ByteBuf buf) throws IOException {
            assert (this.future != null);
            this.future = this.chunked ? this.future.channel().writeAndFlush((Object)new DefaultHttpContent(buf)) : this.future.channel().writeAndFlush((Object)buf);
            return this;
        }

        public void operationComplete(final ChannelFuture future) throws Exception {
            if (future.cause() != null) {
                this.ctrl.internalOnError(future.cause());
                if (future.channel() != null && future.channel().isOpen()) {
                    future.channel().close();
                }
                return;
            }
            try {
                if (this.entryCount > 0) {
                    this.svc.submit(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    this.operationComplete(future);
                                }
                                catch (Exception ex) {
                                    ctrl.internalOnError(ex);
                                    if (future == null || !future.channel().isOpen()) break block2;
                                    future.channel().close();
                                }
                            }
                        }
                    });
                    return;
                }
                ++this.entryCount;
                Callable<Void> c = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        inOperationComplete = true;
                        try {
                            future = future;
                            ResponseWriter.Status status = writer.write(evt, this, callCount++);
                            if (status.isCallback()) {
                                future = future.addListener((GenericFutureListener)this);
                            } else if (status == ResponseWriter.Status.DONE) {
                                if (chunked) {
                                    future = future.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                                }
                                if (shouldClose) {
                                    future = future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ctrl.internalOnError(ex);
                        }
                        finally {
                            inOperationComplete = false;
                        }
                        return null;
                    }
                };
                if (!this.inOperationComplete) {
                    c.call();
                } else {
                    this.svc.submit(c);
                }
            }
            finally {
                --this.entryCount;
            }
        }

        @Override
        public ChannelFuture future() {
            return this.future;
        }

        @Override
        public ResponseWriter.Output write(HttpContent chunk) throws IOException {
            this.future = !this.chunked ? this.future.channel().writeAndFlush((Object)chunk.content()) : this.future.channel().writeAndFlush((Object)chunk);
            return this;
        }

        @Override
        public ResponseWriter.Output write(FileRegion region) throws IOException {
            this.future = this.future.channel().writeAndFlush((Object)region);
            if (this.shouldClose) {
                this.future.addListener((GenericFutureListener)CLOSE);
            }
            return this;
        }
    }

    static final class SendEmptyLastChunk
    implements ChannelFutureListener {
        SendEmptyLastChunk() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isDone() || future.isSuccess()) {
                future.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else if (future.cause() != null) {
                future.cause().printStackTrace();
            }
        }
    }

    static final class SendOneBuffer
    implements ChannelFutureListener {
        private final ByteBuf buf;

        public SendOneBuffer(ByteBuf buf) {
            this.buf = buf;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isDone() || future.isSuccess()) {
                future.channel().writeAndFlush((Object)new DefaultLastHttpContent(this.buf));
            }
        }
    }
}

