/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur;

import com.mastfrog.acteur.Event;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.util.codec.Codec;
import com.mastfrog.util.streams.Streams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.HttpContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class ResponseWriter {
    public Status write(Event<?> evt, Output out, int iteration) throws Exception {
        return this.write(evt, out);
    }

    public Status write(Event<?> evt, Output out) throws Exception {
        throw new UnsupportedOperationException("Must override one of the write() methods");
    }

    public static interface Output {
        public Output writeObject(Object var1) throws IOException;

        public Output writeObjectIf(Object var1, boolean var2) throws IOException;

        public Output writeIf(boolean var1, String var2) throws IOException;

        public Output write(String var1) throws IOException;

        public Output write(byte[] var1) throws IOException;

        public Output write(InputStream var1) throws IOException;

        public Output write(ByteBuffer var1) throws IOException;

        public Output write(ByteBuf var1) throws IOException;

        public Output write(FileRegion var1) throws IOException;

        public Output write(HttpContent var1) throws IOException;

        public <T> Output trailer(HeaderValueType<T> var1, T var2);

        public Channel channel();

        public ChannelFuture future();
    }

    public static enum Status {
        NOT_DONE,
        DEFERRED,
        DONE;


        boolean isCallback() {
            return this == NOT_DONE;
        }
    }

    static abstract class AbstractOutput
    implements Output {
        private final Charset charset;
        private final ByteBufAllocator allocator;
        private final Codec mapper;

        protected AbstractOutput(Charset charset, ByteBufAllocator allocator, Codec mapper) {
            this.charset = charset;
            this.allocator = allocator;
            this.mapper = mapper;
        }

        @Override
        public Output writeObject(Object o) throws IOException {
            return this.write(this.mapper.writeValueAsString(o));
        }

        @Override
        public Output writeObjectIf(Object o, boolean condition) throws IOException {
            if (condition) {
                return this.writeObject(o);
            }
            return this;
        }

        @Override
        public Output writeIf(boolean condition, String what) throws IOException {
            if (condition) {
                return this.write(what);
            }
            return this;
        }

        @Override
        public Output write(String string) throws IOException {
            return this.write(string.getBytes(this.charset));
        }

        @Override
        public Output write(byte[] bytes) throws IOException {
            ByteBuf b = this.buf();
            b.writeBytes(bytes);
            return this.write(b);
        }

        @Override
        public Output write(InputStream in) throws IOException {
            ByteBuf b = this.buf();
            ByteBufOutputStream out = new ByteBufOutputStream(b);
            Streams.copy((InputStream)in, (OutputStream)out);
            return this.write(b);
        }

        @Override
        public Output write(ByteBuffer buf) throws IOException {
            ByteBuf b = this.buf().writeBytes(buf);
            return this.write(b);
        }

        protected ByteBuf buf() {
            return this.allocator.compositeBuffer();
        }

        @Override
        public <T> Output trailer(HeaderValueType<T> type, T value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

