/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.annotations;

import com.google.inject.ImplementedBy;
import com.google.inject.name.Named;
import com.mastfrog.acteur.Application;
import com.mastfrog.acteur.ImplicitBindings;
import com.mastfrog.acteur.Page;
import com.mastfrog.acteur.annotations.HttpCall;
import com.mastfrog.acteur.annotations.HttpCallRegistryLoader;
import com.mastfrog.acteur.preconditions.Methods;
import com.mastfrog.acteur.preconditions.Path;
import com.mastfrog.acteur.preconditions.PathRegex;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.strings.AlignedText;
import com.mastfrog.util.strings.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class GenericApplication
extends Application {
    public GenericApplication(boolean withHelp) {
        this(new GenericApplicationSettingsImpl(), Collections.emptySet());
    }

    public GenericApplication() {
        this(new Class[0]);
    }

    public GenericApplication(Class<?> ... excludePages) {
        this(new GenericApplicationSettingsImpl(), CollectionUtils.setOf((Object[])excludePages));
    }

    @Inject
    public GenericApplication(GenericApplicationSettings settings, @Named(value="excluded") Set<Class<?>> excludePages) {
        boolean helpEnabled = settings.helpEnabled;
        Set<Class<?>> excluded = excludePages;
        ImplicitBindings implicit = this.getClass().getAnnotation(ImplicitBindings.class);
        HashSet alreadyBound = implicit == null ? Collections.emptySet() : new HashSet(Arrays.asList(implicit.value()));
        HttpCallRegistryLoader loader = new HttpCallRegistryLoader(this.getClass());
        ArrayList<Class<? extends Page>> originalOrder = new ArrayList<Class<? extends Page>>();
        for (Class<? extends Page> clazz : loader) {
            originalOrder.add(clazz);
        }
        if (Boolean.getBoolean("acteur.debug")) {
            GenericApplication.logClasses(originalOrder, alreadyBound, excluded, helpEnabled);
        }
        for (Class<Page> clazz : originalOrder) {
            if (alreadyBound.contains(clazz) || excluded.contains(clazz)) continue;
            this.add(clazz);
        }
        if (helpEnabled) {
            this.add(Application.helpPageType());
        }
        if (settings.corsEnabled) {
        }
    }

    private static void logClasses(List<Class<? extends Page>> originalOrder, Set<Class<?>> alreadyBound, Set<Class<?>> excluded, boolean helpEnabled) {
        StringBuilder appInfo = new StringBuilder();
        ArrayList<Class<? extends Page>> sorted = new ArrayList<Class<? extends Page>>(originalOrder);
        if (helpEnabled) {
            sorted.add(Application.helpPageType());
        }
        Collections.sort(sorted, (a, b) -> {
            int ob;
            int oa = GenericApplication.orderOf(a);
            return oa == (ob = GenericApplication.orderOf(b)) ? 0 : (oa > ob ? 1 : -1);
        });
        for (Class clazz : sorted) {
            if (alreadyBound.contains(clazz) || excluded.contains(clazz)) continue;
            GenericApplication.pageTypeToString(clazz, appInfo);
        }
        System.err.println("Acteur application with the following HTTP calls:\n");
        System.err.println(AlignedText.formatTabbed((CharSequence)appInfo));
    }

    private static int orderOf(Class<? extends Page> pg) {
        HttpCall call = pg.getAnnotation(HttpCall.class);
        if (call != null) {
            return call.order();
        }
        return 0;
    }

    private static StringBuilder pageTypeToString(Class<? extends Page> pg, StringBuilder into) {
        into.append(" * ");
        String nm = pg.getSimpleName();
        if (nm.endsWith("__GenPage")) {
            nm = nm.substring(0, nm.length() - "__GenPage".length());
        }
        String pkg = pg.getPackage().toString();
        into.append(nm).append('\t');
        GenericApplication.method(pg, into).append('\t').append('\t');
        GenericApplication.path(pg, into).append('\t').append(" (").append(pkg).append(')').append('\n');
        return into;
    }

    private static StringBuilder method(Class<? extends Page> pg, StringBuilder into) {
        Methods mths = pg.getAnnotation(Methods.class);
        if (mths != null) {
            into.append(Strings.join((char)'/', Arrays.asList(mths.value())));
        } else {
            into.append("???");
        }
        return into;
    }

    private static StringBuilder path(Class<? extends Page> pg, StringBuilder into) {
        Path path = pg.getAnnotation(Path.class);
        if (path != null) {
            into.append(Strings.join((String)", ", Arrays.asList(path.value())));
        } else {
            PathRegex regexen = pg.getAnnotation(PathRegex.class);
            if (regexen != null) {
                into.append(Strings.join((String)" ", Arrays.asList(regexen.value())));
            } else {
                into.append("/???????");
            }
        }
        return into;
    }

    static class GenericApplicationSettingsImpl
    extends GenericApplicationSettings {
        @Inject
        GenericApplicationSettingsImpl() {
            super(false, false);
        }
    }

    @ImplementedBy(value=GenericApplicationSettingsImpl.class)
    public static class GenericApplicationSettings {
        public final boolean corsEnabled;
        public final boolean helpEnabled;

        public GenericApplicationSettings(boolean corsEnabled, boolean helpEnabled) {
            this.corsEnabled = corsEnabled;
            this.helpEnabled = helpEnabled;
        }
    }
}

