/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.annotations;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.mastfrog.acteur.annotations.GenericApplication;
import com.mastfrog.acteur.annotations.HttpCallRegistryLoader;
import com.mastfrog.acteur.server.ServerModule;
import com.mastfrog.giulius.scope.ReentrantScope;
import com.mastfrog.settings.Settings;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Exceptions;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;

public class GenericApplicationModule<T extends GenericApplication>
extends ServerModule<T> {
    protected final Settings settings;
    private final Class<?>[] exclude;
    public static final String EXCLUDED_CLASSES = "excluded";

    public GenericApplicationModule(Settings settings) {
        this(settings, GenericApplication.class, (Class<?>[])new Class[0]);
    }

    public GenericApplicationModule(Settings settings, Class<?> ... exclude) {
        this(settings, GenericApplication.class, exclude);
    }

    public GenericApplicationModule(Settings settings, Class<? extends T> appType, Class<?> ... exclude) {
        super(appType);
        this.settings = settings;
        this.exclude = exclude;
    }

    public GenericApplicationModule(ReentrantScope scope, Settings settings, Class<? extends T> appType, Class<?> ... exclude) {
        super(scope, appType, -1, -1, -1);
        this.settings = settings;
        this.exclude = exclude;
    }

    public static <T extends Module> T instantiateModule(Class<T> m, Settings settings, ReentrantScope scope) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean log = settings.getBoolean("gamlog", false);
        try {
            Constructor<T> c = m.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return (T)((Module)c.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            try {
                if (log) {
                    e.printStackTrace();
                }
                try {
                    Constructor<T> c = m.getDeclaredConstructor(Settings.class);
                    c.setAccessible(true);
                    return (T)((Module)c.newInstance(settings));
                }
                catch (NoSuchMethodException e1) {
                    if (log) {
                        e1.printStackTrace();
                    }
                    try {
                        Constructor<T> c = m.getDeclaredConstructor(Settings.class, ReentrantScope.class);
                        c.setAccessible(true);
                        return (T)((Module)c.newInstance(settings, scope));
                    }
                    catch (NoSuchMethodException e2) {
                        if (log) {
                            e2.printStackTrace();
                        }
                        try {
                            Constructor<T> c = m.getDeclaredConstructor(ReentrantScope.class, Settings.class);
                            c.setAccessible(true);
                            return (T)((Module)c.newInstance(scope, settings));
                        }
                        catch (NoSuchMethodException e3) {
                            if (log) {
                                e3.printStackTrace();
                            }
                            Constructor<T> c = m.getDeclaredConstructor(ReentrantScope.class);
                            c.setAccessible(true);
                            return (T)((Module)c.newInstance(scope));
                        }
                    }
                }
            }
            catch (NoSuchMethodException e2) {
                if (log) {
                    e2.printStackTrace();
                }
                return (T)((Module)m.newInstance());
            }
        }
    }

    @Override
    protected void configure() {
        try {
            super.configure();
            HttpCallRegistryLoader ldr = new HttpCallRegistryLoader(this.appType);
            ImmutableSet toExclude = ImmutableSet.copyOf((Collection)CollectionUtils.setOf((Object[])this.exclude));
            this.bind(Class[].class).annotatedWith((Annotation)Names.named((String)EXCLUDED_CLASSES)).toInstance(this.exclude);
            this.bind(new GenericArrayOfClasses()).annotatedWith((Annotation)Names.named((String)EXCLUDED_CLASSES)).toInstance(this.exclude);
            this.bind(new SetOfClasses()).annotatedWith((Annotation)Names.named((String)EXCLUDED_CLASSES)).toInstance((Object)toExclude);
            for (Class<?> clazz : ldr.implicitBindings()) {
                if (toExclude.contains(clazz)) continue;
                this.scope.bindTypes(this.binder(), new Class[]{clazz});
            }
            for (Class<Object> clazz : ldr.modules()) {
                if (toExclude.contains(clazz)) continue;
                this.install((Module)GenericApplicationModule.instantiateModule(clazz, this.settings, this.scope));
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    private static final class GenericArrayOfClasses
    extends TypeLiteral<Class<?>[]> {
        private GenericArrayOfClasses() {
        }
    }

    private static final class SetOfClasses
    extends TypeLiteral<Set<Class<?>>> {
        private SetOfClasses() {
        }
    }
}

