/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteur.annotations;

import com.google.inject.Module;
import com.mastfrog.acteur.Page;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.collections.Converter;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.streams.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpCallRegistryLoader
implements Iterable<Class<? extends Page>> {
    private final Class<?> type;
    private final List<Entry> entries = new LinkedList<Entry>();

    public HttpCallRegistryLoader(Class<?> type) {
        this.type = type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Class<?>> implicitBindings() {
        LinkedHashSet types = new LinkedHashSet();
        for (Entry e : this.entries()) {
            types.addAll(e.bindings);
        }
        ClassLoader cl = this.type.getClassLoader();
        if (cl == null) return types;
        try {
            HashSet<String> seenLines = new HashSet<String>();
            Enumeration<URL> numbleLists = cl.getResources("META-INF/http/numble.list");
            if (numbleLists == null) return types;
            Iterator iterator = CollectionUtils.toIterable(numbleLists).iterator();
            block12: while (iterator.hasNext()) {
                URL url = (URL)iterator.next();
                try {
                    InputStream in = url.openStream();
                    try {
                        String[] lines;
                        String[] stringArray = lines = Streams.readString((InputStream)in, (String)"UTF-8").split("\n");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block12;
                            String line = stringArray[n2];
                            if (!((line = line.trim()).isEmpty() || line.startsWith("#") || seenLines.contains(line))) {
                                seenLines.add(line);
                                try {
                                    types.add(cl.loadClass(line));
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    types.add(Class.forName(line));
                                }
                            }
                            ++n2;
                        }
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (ClassNotFoundException ex) {
                    return (Set)Exceptions.chuck((Throwable)ex);
                }
            }
            return types;
        }
        catch (IOException ex) {
            return (Set)Exceptions.chuck((Throwable)ex);
        }
    }

    public Set<Class<? extends Module>> modules() throws IOException, ClassNotFoundException {
        HashSet<Class<? extends Module>> types = new HashSet<Class<? extends Module>>();
        ClassLoader cl = this.type.getClassLoader();
        if (cl == null) {
            return Collections.emptySet();
        }
        Enumeration<URL> eurls = cl.getResources("META-INF/http/modules.list");
        if (eurls == null) {
            return Collections.emptySet();
        }
        for (URL url : CollectionUtils.toIterable(eurls)) {
            InputStream in = url.openStream();
            try {
                String[] lines;
                for (String line : lines = Streams.readString((InputStream)in, (String)"UTF-8").split("\n")) {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                    Class<?> moduleType = Class.forName(line);
                    if (!Module.class.isAssignableFrom(moduleType)) {
                        throw new ClassCastException("Not a subclass of " + Module.class.getName() + ": " + line);
                    }
                    types.add(moduleType);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        return types;
    }

    private synchronized List<Entry> entries() {
        if (this.entries.isEmpty()) {
            try {
                ClassLoader cl = this.type.getClassLoader();
                Pattern classAndOrder = Pattern.compile("(.*?):(-?\\d+)");
                Pattern classAndOrderWithImplicitBindings = Pattern.compile("(.*?):(-?\\d+)\\{(.*)\\}$");
                int ix = 0;
                if (cl == null) {
                    return Collections.emptyList();
                }
                Enumeration<URL> eurls = cl.getResources("META-INF/http/pages.list");
                if (eurls == null) {
                    return Collections.emptyList();
                }
                for (URL url : CollectionUtils.toIterable(eurls)) {
                    InputStream in = url.openStream();
                    try {
                        String[] lines;
                        for (String line : lines = Streams.readString((InputStream)in, (String)"UTF-8").split("\n")) {
                            int order;
                            String className;
                            if (line.isEmpty() || line.charAt(0) == '#') continue;
                            Matcher m = classAndOrderWithImplicitBindings.matcher(line);
                            if (m.find()) {
                                className = m.group(1);
                                order = Integer.parseInt(m.group(2));
                                String bindings = m.group(3);
                                this.entries.add(new Entry(ix, className, order, url, bindings));
                                continue;
                            }
                            m = classAndOrder.matcher(line);
                            if (!m.find()) continue;
                            className = m.group(1);
                            order = Integer.parseInt(m.group(2));
                            this.entries.add(new Entry(ix, className, order, url));
                        }
                        ++ix;
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.chuck((Throwable)ex);
            }
            Collections.sort(this.entries);
        }
        return this.entries;
    }

    @Override
    public Iterator<Class<? extends Page>> iterator() {
        return CollectionUtils.convertedIterator((Converter)new EntryConverter(), this.entries().iterator());
    }

    private static class Entry
    implements Comparable<Entry> {
        private final int order;
        private final int classpathOrder;
        private final Class<? extends Page> type;
        private final Set<Class<?>> bindings = new LinkedHashSet();

        Entry(int classpathOrder, String className, int order, URL url) throws ClassNotFoundException {
            this.order = order;
            this.classpathOrder = classpathOrder;
            Class<?> type = Class.forName(className);
            if (!Page.class.isAssignableFrom(type)) {
                throw new ClassCastException(type.getName() + " is not a subtype of " + Page.class.getName() + " in " + url);
            }
            this.type = type;
        }

        Entry(int classpathOrder, String className, int order, URL url, String bindings) throws ClassNotFoundException {
            this(classpathOrder, className, order, url);
            for (String type : bindings.split(",")) {
                type = type.trim();
                this.bindings.add(Class.forName(type));
            }
        }

        @Override
        public int compareTo(Entry o) {
            Integer theirs;
            Integer mine = this.classpathOrder;
            if (mine.equals(theirs = Integer.valueOf(o.classpathOrder))) {
                mine = this.order;
                theirs = o.order;
            }
            return mine.compareTo(theirs);
        }

        public String toString() {
            return this.type.getSimpleName();
        }
    }

    static class EntryConverter
    implements Converter<Class<? extends Page>, Entry> {
        EntryConverter() {
        }

        public Class<? extends Page> convert(Entry r) {
            return r.type;
        }

        public Entry unconvert(Class<? extends Page> t) {
            throw new UnsupportedOperationException();
        }
    }
}

